/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group.command;

import java.util.List;
import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.ColumnGroupReorderLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.reorder.command.MultiColumnReorderCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupMultiColumnReorderCommandHandler
extends AbstractLayerCommandHandler<MultiColumnReorderCommand> {
    private final ColumnGroupReorderLayer columnGroupReorderLayer;

    public GroupMultiColumnReorderCommandHandler(ColumnGroupReorderLayer columnGroupReorderLayer) {
        this.columnGroupReorderLayer = columnGroupReorderLayer;
    }

    @Override
    public Class<MultiColumnReorderCommand> getCommandClass() {
        return MultiColumnReorderCommand.class;
    }

    @Override
    protected boolean doCommand(MultiColumnReorderCommand command) {
        ColumnGroupModel model;
        List<Integer> fromColumnPositions;
        int toColumnIndex;
        int toColumnPosition = command.getToColumnPosition();
        ILayer underlyingLayer = this.columnGroupReorderLayer.getUnderlyingLayer();
        if (this.updateModel(underlyingLayer, toColumnIndex = underlyingLayer.getColumnIndexByPosition(toColumnPosition), fromColumnPositions = command.getFromColumnPositions(), model = this.columnGroupReorderLayer.getModel())) {
            return underlyingLayer.doCommand(command);
        }
        return false;
    }

    private boolean updateModel(ILayer underlyingLayer, int toColumnIndex, List<Integer> fromColumnPositions, ColumnGroupModel model) {
        if (model.isPartOfAGroup(toColumnIndex)) {
            String toGroupName = model.getColumnGroupNameForIndex(toColumnIndex);
            if (model.isPartOfAnUnbreakableGroup(toColumnIndex)) {
                return false;
            }
            for (Integer fromColumnPosition : fromColumnPositions) {
                int fromColumnIndex = underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
                if (toGroupName.equals(model.getColumnGroupNameForIndex(fromColumnIndex))) continue;
                model.removeColumnFromGroup(fromColumnIndex);
                model.addColumnsIndexesToGroup(toGroupName, fromColumnIndex);
            }
            return true;
        }
        if (!model.isPartOfAGroup(toColumnIndex)) {
            for (Integer fromColumnPosition : fromColumnPositions) {
                int fromColumnIndex = underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
                if (!model.isPartOfAGroup(fromColumnIndex) || model.removeColumnFromGroup(fromColumnIndex)) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

