/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.grid.command;

import net.sourceforge.nattable.command.ILayerCommandHandler;
import net.sourceforge.nattable.grid.layer.GridLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.print.command.TurnViewportOffCommand;
import net.sourceforge.nattable.print.command.TurnViewportOnCommand;
import net.sourceforge.nattable.resize.MaxCellBoundsHelper;
import net.sourceforge.nattable.resize.command.AutoResizeColumnsCommand;
import net.sourceforge.nattable.resize.command.MultiColumnResizeCommand;
import net.sourceforge.nattable.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoResizeColumnCommandHandler
implements ILayerCommandHandler<AutoResizeColumnsCommand> {
    private final GridLayer gridLayer;

    public AutoResizeColumnCommandHandler(GridLayer gridLayer) {
        this.gridLayer = gridLayer;
    }

    @Override
    public Class<AutoResizeColumnsCommand> getCommandClass() {
        return AutoResizeColumnsCommand.class;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, AutoResizeColumnsCommand command) {
        targetLayer.doCommand(new TurnViewportOffCommand());
        int[] columnPositions = ObjectUtils.asIntArray(command.getColumnPositions());
        int[] gridColumnPositions = this.convertFromSelectionToGrid(columnPositions);
        int[] gridColumnWidths = MaxCellBoundsHelper.getPreferedColumnWidths(command.getConfigRegistry(), command.getGC(), this.gridLayer, gridColumnPositions);
        this.gridLayer.doCommand(new MultiColumnResizeCommand((ILayer)this.gridLayer, gridColumnPositions, gridColumnWidths));
        targetLayer.doCommand(new TurnViewportOnCommand());
        return true;
    }

    private int[] convertFromSelectionToGrid(int[] columnPositions) {
        int[] gridColumnPositions = new int[columnPositions.length];
        int i = 0;
        while (i < columnPositions.length) {
            gridColumnPositions[i] = this.gridLayer.underlyingToLocalColumnPosition(this.gridLayer.getBodyLayer(), columnPositions[i]);
            ++i;
        }
        return gridColumnPositions;
    }
}

