/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.util;

import java.util.regex.Pattern;

public final class SparqlNameUtils {
    private static final Pattern PN_LOCAL_CHUNK = Pattern.compile("(?:%[0-9A-Fa-f]{2}|[-\\p{L}\\p{N}_\\u00B7]|:)+");

    private SparqlNameUtils() {
    }

    public static boolean isPNLocal(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (s.charAt(s.length() - 1) == '.') {
            return false;
        }
        char first = s.charAt(0);
        if (first != ':' && !Character.isLetter(first) && first != '_' && !Character.isDigit(first)) {
            return false;
        }
        int i = 0;
        boolean needChunk = true;
        while (i < s.length()) {
            int j;
            for (j = i; j < s.length() && s.charAt(j) != '.'; ++j) {
            }
            String chunk = s.substring(i, j);
            if (needChunk && chunk.isEmpty()) {
                return false;
            }
            if (!chunk.isEmpty() && !PN_LOCAL_CHUNK.matcher(chunk).matches()) {
                return false;
            }
            i = j + 1;
            needChunk = false;
        }
        return true;
    }
}

