/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.stash;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.StashCreateOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class StashCreateUI {
    private Repository repo;

    public StashCreateUI(Repository repo) {
        this.repo = repo;
    }

    public boolean createStash(Shell shell) {
        if (!UIUtils.saveAllEditors(this.repo)) {
            return false;
        }
        StashCreateDialog commitMessageDialog = new StashCreateDialog(shell);
        if (commitMessageDialog.open() != 0) {
            return false;
        }
        String message = commitMessageDialog.getValue();
        if (message.length() == 0) {
            message = null;
        }
        boolean includeUntracked = commitMessageDialog.getIncludeUntracked();
        final StashCreateOperation op = new StashCreateOperation(this.repo, message, includeUntracked);
        WorkspaceJob job = new WorkspaceJob(UIText.StashCreateCommand_jobTitle){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                    RevCommit commit = op.getCommit();
                    if (commit == null) {
                        StashCreateUI.showNoChangesToStash();
                    }
                }
                catch (CoreException e) {
                    Activator.logError(UIText.StashCreateCommand_stashFailed, e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.STASH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return true;
    }

    private static void showNoChangesToStash() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openInformation((Shell)shell, (String)UIText.StashCreateCommand_titleNoChanges, (String)UIText.StashCreateCommand_messageNoChanges);
            }
        });
    }

    private static class StashCreateDialog
    extends Dialog {
        private Text text;
        private Button untrackedButton;
        private String commitMessage = "";
        private boolean includeUntracked;
        private final IPreferenceStore store = Activator.getDefault().getPreferenceStore();

        public StashCreateDialog(Shell shell) {
            super(shell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.getShell().setText(UIText.StashCreateCommand_titleEnterCommitMessage);
            Label label = new Label(composite, 64);
            label.setText(UIText.StashCreateCommand_messageEnterCommitMessage);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.text = new Text(composite, 2052);
            this.text.setLayoutData((Object)new GridData(768));
            this.untrackedButton = new Button(composite, 32);
            this.untrackedButton.setText(UIText.StashCreateCommand_includeUntrackedLabel);
            this.includeUntracked = this.store.getBoolean("stashIncludeUntracked");
            this.untrackedButton.setSelection(this.includeUntracked);
            this.text.setFocus();
            return composite;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.commitMessage = this.text.getText();
                this.includeUntracked = this.untrackedButton.getSelection();
                this.store.setValue("stashIncludeUntracked", this.includeUntracked);
            } else {
                this.commitMessage = null;
                this.includeUntracked = false;
            }
            super.buttonPressed(buttonId);
        }

        public String getValue() {
            return this.commitMessage;
        }

        public boolean getIncludeUntracked() {
            return this.includeUntracked;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, UIText.StashCreateCommand_ButtonOK, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }
}

