/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTSemanticMatcher;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class MultiCatchCleanUpCore
extends AbstractMultiFix {
    public MultiCatchCleanUpCore() {
        this(Collections.emptyMap());
    }

    public MultiCatchCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.multi_catch");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.multi_catch")) {
            return new String[]{MultiFixMessages.MultiCatchCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        bld.append("try {\n");
        bld.append("    obj.throwingMethod();\n");
        if (this.isEnabled("cleanup.multi_catch")) {
            bld.append("} catch (IllegalArgumentException | IOException ioe) {\n");
            bld.append("    ioe.printStackTrace();\n");
            bld.append("}\n\n\n");
        } else {
            bld.append("} catch (IllegalArgumentException iae) {\n");
            bld.append("    iae.printStackTrace();\n");
            bld.append("} catch (IOException ioe) {\n");
            bld.append("    ioe.printStackTrace();\n");
            bld.append("}\n");
        }
        return bld.toString();
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.multi_catch")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(TryStatement visited) {
                List catchClauses = visited.catchClauses();
                AbstractBinding[] typeBindings = this.resolveTypeBindings(catchClauses);
                int i = 0;
                while (i < catchClauses.size() - 1) {
                    ArrayList<CatchClause> mergeableCatchClauses = new ArrayList<CatchClause>(catchClauses.size());
                    mergeableCatchClauses.add((CatchClause)catchClauses.get(i));
                    Enum direction = null;
                    int j = i + 1;
                    while (j < catchClauses.size()) {
                        MergeDirection newDirection = this.mergeDirection(typeBindings, i, j);
                        if (!MergeDirection.NONE.equals((Object)newDirection) && (direction == null || direction.equals((Object)newDirection)) && this.matchMultiCatch((CatchClause)catchClauses.get(i), (CatchClause)catchClauses.get(j))) {
                            direction = newDirection;
                            mergeableCatchClauses.add((CatchClause)catchClauses.get(j));
                        }
                        ++j;
                    }
                    if (mergeableCatchClauses.size() > 1) {
                        rewriteOperations.add(new MultiCatchOperation((List<CatchClause>)mergeableCatchClauses, (MergeDirection)direction));
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private AbstractBinding[] resolveTypeBindings(List<CatchClause> catchClauses) {
                AbstractBinding[] results = new AbstractBinding[catchClauses.size()];
                int i = 0;
                while (i < catchClauses.size()) {
                    results[i] = this.resolveBinding(catchClauses.get(i));
                    ++i;
                }
                return results;
            }

            private AbstractBinding resolveBinding(CatchClause catchClause) {
                SingleVariableDeclaration singleVariableDeclaration = catchClause.getException();
                Type type = singleVariableDeclaration.getType();
                switch (type.getNodeType()) {
                    case 43: {
                        return new SingleBinding(type.resolveBinding());
                    }
                    case 84: {
                        List types = ((UnionType)type).types();
                        ITypeBinding[] typeBindings = new ITypeBinding[types.size()];
                        int i = 0;
                        while (i < types.size()) {
                            typeBindings[i] = ((Type)types.get(i)).resolveBinding();
                            ++i;
                        }
                        return new MultiBinding(typeBindings);
                    }
                }
                return null;
            }

            private MergeDirection mergeDirection(AbstractBinding[] typeBindings, int start, int end) {
                if (this.canMergeTypesDown(typeBindings, start, end)) {
                    return MergeDirection.DOWN;
                }
                if (this.canMergeTypesUp(typeBindings, start, end)) {
                    return MergeDirection.UP;
                }
                return MergeDirection.NONE;
            }

            private boolean canMergeTypesDown(AbstractBinding[] types, int start, int end) {
                AbstractBinding startType = types[start];
                int i = start + 1;
                while (i < end) {
                    AbstractBinding type = types[i];
                    if (startType.isSubTypeCompatible(type)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private boolean canMergeTypesUp(AbstractBinding[] types, int start, int end) {
                AbstractBinding endType = types[end];
                int i = start + 1;
                while (i < end) {
                    AbstractBinding type = types[i];
                    if (type.isSubTypeCompatible(endType)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private boolean matchMultiCatch(CatchClause firstCatchClause, CatchClause secondCatchClause) {
                MultiCatchASTMatcher matcher = new MultiCatchASTMatcher(firstCatchClause, secondCatchClause);
                return ASTNodes.match((ASTSemanticMatcher)matcher, (ASTNode)firstCatchClause.getBody(), (ASTNode)secondCatchClause.getBody());
            }

            abstract class AbstractBinding {
                AbstractBinding() {
                }

                protected abstract boolean isSubTypeCompatible(AbstractBinding var1);
            }

            class MultiBinding
            extends AbstractBinding {
                private final ITypeBinding[] typeBindings;

                public MultiBinding(ITypeBinding[] typeBindings) {
                    this.typeBindings = typeBindings;
                }

                @Override
                protected boolean isSubTypeCompatible(AbstractBinding other) {
                    int n;
                    if (other instanceof SingleBinding) {
                        ITypeBinding[] iTypeBindingArray = this.typeBindings;
                        n = this.typeBindings.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITypeBinding selfTypeBinding = iTypeBindingArray[n2];
                            if (new SingleBinding(selfTypeBinding).isSubTypeCompatible(other)) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                    if (other instanceof MultiBinding) {
                        MultiBinding o = (MultiBinding)other;
                        ITypeBinding[] iTypeBindingArray = o.typeBindings;
                        int n3 = o.typeBindings.length;
                        n = 0;
                        while (n < n3) {
                            ITypeBinding otherTypeBinding = iTypeBindingArray[n];
                            if (!this.isSubTypeCompatible(new SingleBinding(otherTypeBinding))) {
                                return false;
                            }
                            ++n;
                        }
                        return true;
                    }
                    return false;
                }
            }

            final class MultiCatchASTMatcher
            extends ASTSemanticMatcher {
                private final Map<ASTNode, ASTNode> matchingVariables = new HashMap<ASTNode, ASTNode>();

                public MultiCatchASTMatcher(CatchClause catchClause1, CatchClause catchClause2) {
                    this.matchingVariables.put((ASTNode)catchClause1.getException(), (ASTNode)catchClause2.getException());
                }

                @Override
                public boolean match(VariableDeclarationStatement node, Object other) {
                    return super.match(node, other) || this.matchVariableDeclarationsWithDifferentNames(node, other);
                }

                private boolean matchVariableDeclarationsWithDifferentNames(VariableDeclarationStatement node, Object other) {
                    if (!(other instanceof VariableDeclarationStatement)) {
                        return false;
                    }
                    List fragments1 = node.fragments();
                    List fragments2 = ((VariableDeclarationStatement)other).fragments();
                    if (fragments1.size() == fragments2.size()) {
                        Iterator it1 = fragments1.iterator();
                        Iterator it2 = fragments2.iterator();
                        while (it1.hasNext() && it2.hasNext()) {
                            VariableDeclarationFragment f1 = (VariableDeclarationFragment)it1.next();
                            VariableDeclarationFragment f2 = (VariableDeclarationFragment)it2.next();
                            if (ASTNodes.resolveTypeBinding((VariableDeclaration)f1) == null || !Objects.equals(ASTNodes.resolveTypeBinding((VariableDeclaration)f1), ASTNodes.resolveTypeBinding((VariableDeclaration)f2)) || !ASTNodes.match((ASTSemanticMatcher)this, (ASTNode)f1.getInitializer(), (ASTNode)f2.getInitializer())) continue;
                            this.matchingVariables.put((ASTNode)f1, (ASTNode)f2);
                            return true;
                        }
                    }
                    return false;
                }

                public boolean match(SimpleName node, Object other) {
                    return super.match(node, other) || this.areBothReferringToSameVariables((ASTNode)node, other);
                }

                public boolean match(MethodInvocation methodInvocation1, Object other) {
                    if (other instanceof MethodInvocation) {
                        MethodInvocation methodInvocation2 = (MethodInvocation)other;
                        return super.match(methodInvocation1, (Object)methodInvocation2) && this.isSameMethodBinding(methodInvocation1.resolveMethodBinding(), methodInvocation2.resolveMethodBinding());
                    }
                    return false;
                }

                public boolean match(SuperMethodInvocation superMethodInvocation1, Object other) {
                    if (other instanceof SuperMethodInvocation) {
                        SuperMethodInvocation superMethodInvocation2 = (SuperMethodInvocation)other;
                        return super.match(superMethodInvocation1, (Object)superMethodInvocation2) && this.isSameMethodBinding(superMethodInvocation1.resolveMethodBinding(), superMethodInvocation2.resolveMethodBinding());
                    }
                    return false;
                }

                public boolean match(ClassInstanceCreation classInstanceCreation1, Object other) {
                    if (other instanceof ClassInstanceCreation) {
                        ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)other;
                        return super.match(classInstanceCreation1, (Object)classInstanceCreation2) && this.isSameMethodBinding(classInstanceCreation1.resolveConstructorBinding(), classInstanceCreation2.resolveConstructorBinding());
                    }
                    return false;
                }

                private boolean isSameMethodBinding(IMethodBinding binding1, IMethodBinding binding2) {
                    return binding1 != null && binding2 != null && (binding1.equals((Object)binding2) || binding1.overrides(binding2) || binding2.overrides(binding1) || this.areOverridingSameMethod(binding1, binding2));
                }

                private boolean areOverridingSameMethod(IMethodBinding binding1, IMethodBinding binding2) {
                    Set<IMethodBinding> commonOverridenMethods = ASTNodes.getOverridenMethods(binding1);
                    commonOverridenMethods.retainAll(ASTNodes.getOverridenMethods(binding2));
                    return !commonOverridenMethods.isEmpty();
                }

                private boolean areBothReferringToSameVariables(ASTNode node, Object other) {
                    for (Map.Entry<ASTNode, ASTNode> pairedVariables : this.matchingVariables.entrySet()) {
                        if (!ASTNodes.isSameVariable(node, pairedVariables.getKey())) continue;
                        return other instanceof ASTNode && ASTNodes.isSameVariable((ASTNode)other, pairedVariables.getValue());
                    }
                    return false;
                }
            }

            class SingleBinding
            extends AbstractBinding {
                private final ITypeBinding typeBinding;

                public SingleBinding(ITypeBinding typeBinding) {
                    this.typeBinding = typeBinding;
                }

                @Override
                protected boolean isSubTypeCompatible(AbstractBinding other) {
                    if (this.typeBinding == null) {
                        return false;
                    }
                    if (other instanceof SingleBinding) {
                        SingleBinding o = (SingleBinding)other;
                        if (o.typeBinding == null) {
                            return false;
                        }
                        return this.typeBinding.isSubTypeCompatible(o.typeBinding);
                    }
                    if (other instanceof MultiBinding) {
                        MultiBinding o = (MultiBinding)other;
                        ITypeBinding[] iTypeBindingArray = o.typeBindings;
                        int n = o.typeBindings.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITypeBinding otherTypeBinding = iTypeBindingArray[n2];
                            if (!this.isSubTypeCompatible(new SingleBinding(otherTypeBinding))) {
                                return false;
                            }
                            ++n2;
                        }
                        return true;
                    }
                    return false;
                }
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.MultiCatchCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static enum MergeDirection {
        NONE,
        UP,
        DOWN;

    }

    private static class MultiCatchOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final List<CatchClause> mergeableCatchClauses;
        private final MergeDirection direction;

        public MultiCatchOperation(List<CatchClause> mergeableCatchClauses, MergeDirection direction) {
            this.mergeableCatchClauses = mergeableCatchClauses;
            this.direction = direction;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.MultiCatchCleanUp_description, cuRewrite);
            ArrayList<Type> typesByClause = new ArrayList<Type>();
            for (CatchClause mergeableCatchClause : this.mergeableCatchClauses) {
                typesByClause.add(mergeableCatchClause.getException().getType());
            }
            ArrayList<Type> allTypes = new ArrayList<Type>();
            this.collectAllUnionedTypes(typesByClause, allTypes);
            this.removeSupersededAlternatives(allTypes);
            UnionType newUnionType = ast.newUnionType();
            newUnionType.types().addAll(ASTNodes.createMoveTarget(rewrite, allTypes));
            ArrayList<CatchClause> removedClauses = new ArrayList<CatchClause>(this.mergeableCatchClauses);
            CatchClause mergedClause = MergeDirection.UP.equals((Object)this.direction) ? (CatchClause)removedClauses.remove(0) : (CatchClause)removedClauses.remove(removedClauses.size() - 1);
            rewrite.set((ASTNode)mergedClause.getException(), (StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY, (Object)newUnionType, group);
            for (CatchClause mergeableCatchClause : removedClauses) {
                rewrite.remove((ASTNode)mergeableCatchClause, group);
            }
        }

        private void collectAllUnionedTypes(Collection<Type> inputTypes, List<Type> outputTypes) {
            for (Type type : inputTypes) {
                if (type instanceof UnionType) {
                    UnionType unionType = (UnionType)type;
                    this.collectAllUnionedTypes(unionType.types(), outputTypes);
                    continue;
                }
                outputTypes.add(type);
            }
        }

        private void removeSupersededAlternatives(List<Type> allTypes) {
            ListIterator<Type> it1 = allTypes.listIterator();
            block0: while (it1.hasNext()) {
                ITypeBinding binding1 = it1.next().resolveBinding();
                ListIterator<Type> it2 = allTypes.listIterator(it1.nextIndex());
                while (it2.hasNext()) {
                    ITypeBinding binding2 = it2.next().resolveBinding();
                    if (binding1 == null || !binding1.isSubTypeCompatible(binding2)) continue;
                    it1.remove();
                    continue block0;
                }
            }
        }
    }
}

