/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IClassFileDisassembler;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.jdt.internal.core.util.Disassembler;
import org.eclipse.jdt.internal.core.util.PublicScanner;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;

public class ToolFactory {
    public static final int M_FORMAT_NEW = 0;
    public static final int M_FORMAT_EXISTING = 1;

    public static ICodeFormatter createCodeFormatter() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.core", "codeFormatter");
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    try {
                        Object execExt = configElement.createExecutableExtension("class");
                        if (execExt instanceof ICodeFormatter) {
                            return (ICodeFormatter)execExt;
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return ToolFactory.createDefaultCodeFormatter(null);
    }

    public static CodeFormatter createCodeFormatter(Map options) {
        return ToolFactory.createCodeFormatter(options, M_FORMAT_NEW);
    }

    public static CodeFormatter createCodeFormatter(Map options, int mode) {
        String formatterId;
        if (options == null) {
            options = JavaCore.getOptions();
        }
        HashMap<String, String> currentOptions = new HashMap<String, String>(options);
        if (mode == M_FORMAT_NEW) {
            currentOptions.put("org.eclipse.jdt.core.formatter.format_line_comment_starting_on_first_column", "true");
            currentOptions.put("org.eclipse.jdt.core.formatter.never_indent_block_comments_on_first_column", "false");
            currentOptions.put("org.eclipse.jdt.core.formatter.never_indent_line_comments_on_first_column", "false");
        }
        if ((formatterId = (String)options.get("org.eclipse.jdt.core.javaFormatter")) != null) {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.core", "javaFormatter");
            if (extension != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = extension.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] configElements;
                    IExtension ext = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                    int n3 = configElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configElement = iConfigurationElementArray[n4];
                        String initializerID = configElement.getAttribute("id");
                        if (initializerID != null && initializerID.equals(formatterId)) {
                            try {
                                Object execExt = configElement.createExecutableExtension("class");
                                if (execExt instanceof CodeFormatter) {
                                    CodeFormatter formatter = (CodeFormatter)execExt;
                                    formatter.setOptions(currentOptions);
                                    return formatter;
                                }
                            }
                            catch (CoreException e) {
                                org.eclipse.jdt.internal.core.util.Util.log(e.getStatus());
                                break;
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            org.eclipse.jdt.internal.core.util.Util.log(2, "Unable to instantiate formatter extension '" + formatterId + "', returning built-in formatter.");
        }
        return new DefaultCodeFormatter(currentOptions);
    }

    public static ClassFileBytesDisassembler createDefaultClassFileBytesDisassembler() {
        return new Disassembler();
    }

    public static IClassFileDisassembler createDefaultClassFileDisassembler() {
        class DeprecatedDisassembler
        extends Disassembler
        implements IClassFileDisassembler {
            DeprecatedDisassembler() {
            }
        }
        return new DeprecatedDisassembler();
    }

    public static IClassFileReader createDefaultClassFileReader(IClassFile classfile, int decodingFlag) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)classfile.getAncestor(3);
        if (root != null) {
            try {
                if (root instanceof JarPackageFragmentRoot) {
                    String archiveName = null;
                    ZipFile jar = null;
                    try {
                        jar = ((JarPackageFragmentRoot)root).getJar();
                        archiveName = jar.getName();
                    }
                    finally {
                        JavaModelManager.getJavaModelManager().closeZipFile(jar);
                    }
                    PackageFragment packageFragment = (PackageFragment)classfile.getParent();
                    String classFileName = classfile.getElementName();
                    String entryName = org.eclipse.jdt.internal.core.util.Util.concatWith(packageFragment.names, classFileName, '/');
                    return ToolFactory.createDefaultClassFileReader(archiveName, entryName, decodingFlag);
                }
                try {
                    Throwable throwable = null;
                    Object var4_9 = null;
                    try (InputStream in = ((IFile)((JavaElement)((Object)classfile)).resource()).getContents();){
                        return ToolFactory.createDefaultClassFileReader(in, decodingFlag);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public static IClassFileReader createDefaultClassFileReader(InputStream stream, int decodingFlag) {
        try {
            return new ClassFileReader(Util.getInputStreamAsByteArray((InputStream)stream), decodingFlag);
        }
        catch (IOException | ClassFormatException e) {
            return null;
        }
    }

    public static IClassFileReader createDefaultClassFileReader(String fileName, int decodingFlag) {
        try {
            return new ClassFileReader(Util.getFileByteContent((File)new File(fileName)), decodingFlag);
        }
        catch (IOException | ClassFormatException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IClassFileReader createDefaultClassFileReader(String zipFileName, String zipEntryName, int decodingFlag) {
        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
            JavaModelManager.trace("(" + String.valueOf(Thread.currentThread()) + ") [ToolFactory.createDefaultClassFileReader()] Creating ZipFile on " + zipFileName);
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(zipFileName);){
                ZipEntry zipEntry = zipFile.getEntry(zipEntryName);
                if (zipEntry == null) {
                    return null;
                }
                if (!zipEntryName.toLowerCase().endsWith(".class")) {
                    return null;
                }
                byte[] classFileBytes = Util.getZipEntryByteContent((ZipEntry)zipEntry, (ZipFile)zipFile);
                return new ClassFileReader(classFileBytes, decodingFlag);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | ClassFormatException e) {
            return null;
        }
    }

    public static ICodeFormatter createDefaultCodeFormatter(Map options) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        return new org.eclipse.jdt.internal.formatter.old.CodeFormatter(options);
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean assertMode, boolean recordLineSeparator) {
        long complianceLevelValue = CompilerOptions.versionToJdkLevel((String)JavaCore.getOption("org.eclipse.jdt.core.compiler.compliance"));
        if (complianceLevelValue == 0L) {
            complianceLevelValue = 0x300000L;
        }
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, assertMode ? 0x300000L : 0x2F0000L, complianceLevelValue, null, null, true, true, recordLineSeparator);
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel) {
        long sourceLevelValue;
        long complianceLevelValue = CompilerOptions.versionToJdkLevel((String)JavaCore.getOption("org.eclipse.jdt.core.compiler.compliance"));
        if (complianceLevelValue == 0L) {
            complianceLevelValue = 0x300000L;
        }
        if ((sourceLevelValue = CompilerOptions.versionToJdkLevel((String)sourceLevel)) == 0L) {
            sourceLevelValue = 0x2F0000L;
        }
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, sourceLevelValue, complianceLevelValue, null, null, true, true, recordLineSeparator);
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel, String complianceLevel) {
        return ToolFactory.createScanner(tokenizeComments, tokenizeWhiteSpace, recordLineSeparator, sourceLevel, complianceLevel, true);
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel, String complianceLevel, boolean enablePreview) {
        long complianceLevelValue;
        PublicScanner scanner = null;
        long sourceLevelValue = CompilerOptions.versionToJdkLevel((String)sourceLevel);
        if (sourceLevelValue == 0L) {
            sourceLevelValue = 0x2F0000L;
        }
        if ((complianceLevelValue = CompilerOptions.versionToJdkLevel((String)complianceLevel)) == 0L) {
            complianceLevelValue = 0x300000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, sourceLevelValue, complianceLevelValue, null, null, true, enablePreview, recordLineSeparator);
        return scanner;
    }
}

