/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.rcptt.ecl.core.util.ECLBinaryResourceImpl;
import org.eclipse.rcptt.tesla.core.TeslaSerializationOptions;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandTransfer;

public class DataSerializer {
    public static void writeTransfer(DataOutputStream stream, CommandTransfer transfer) throws IOException {
        ECLBinaryResourceImpl resource = new ECLBinaryResourceImpl();
        resource.getContents().add((Object)transfer);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        XMLMapImpl map = new XMLMapImpl();
        TeslaSerializationOptions.fillOptions(map);
        options.put("XML_MAP", map);
        options.put("ENCODING", "utf-8");
        options.put("ESCAPE_USING_CDATA", Boolean.TRUE);
        options.put("SKIP_ESCAPE", Boolean.FALSE);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        resource.save((OutputStream)bytes, options);
        stream.writeInt(bytes.size());
        bytes.writeTo(stream);
        stream.flush();
    }

    public static void writeEObject(DataOutputStream stream, EObject transfer) throws IOException {
        ECLBinaryResourceImpl resource = new ECLBinaryResourceImpl();
        resource.getContents().add((Object)transfer);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        resource.save((OutputStream)bytes, options);
        stream.writeInt(bytes.size());
        bytes.writeTo(stream);
        stream.flush();
    }

    public static CommandTransfer readTransfer(DataInputStream stream) throws IOException {
        int read = stream.readInt();
        byte[] bytes = DataSerializer.readBytes(stream, read);
        if (bytes.length != read) {
            throw new RuntimeException("Failed to retrive tesla command");
        }
        ECLBinaryResourceImpl resource = new ECLBinaryResourceImpl();
        resource.load((InputStream)new ByteArrayInputStream(bytes), null);
        EList contents = resource.getContents();
        for (EObject eObject : contents) {
            if (!(eObject instanceof CommandTransfer)) continue;
            return (CommandTransfer)eObject;
        }
        return null;
    }

    public static EObject readEObject(DataInputStream stream) throws IOException {
        int read = stream.readInt();
        byte[] bytes = DataSerializer.readBytes(stream, read);
        if (bytes.length != read) {
            throw new RuntimeException("Failed to retrive tesla command");
        }
        ECLBinaryResourceImpl resource = new ECLBinaryResourceImpl();
        resource.load((InputStream)new ByteArrayInputStream(bytes), null);
        EList contents = resource.getContents();
        if (contents.size() == 1) {
            return (EObject)contents.get(0);
        }
        return null;
    }

    private static byte[] readBytes(DataInputStream stream, int read) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] part = new byte[1024];
        while (read > 0) {
            int k = read;
            if (k > 1023) {
                k = 1023;
            }
            int len = stream.read(part, 0, k);
            bout.write(part, 0, len);
            read -= len;
        }
        return bout.toByteArray();
    }
}

