/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.license;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.licenses.model.api.LicensePlan;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.report.internal.core.license.LicenseStorage;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class Licenses
implements LicenseStorage {
    private LicenseRegistry licenses;

    @Override
    public List<LicensePlan> plans() {
        return StreamSupport.stream(this.licenses.plans().spliterator(), false).collect(Collectors.toList());
    }

    public List<PersonalLicensePack> personal(String plan) {
        return this.licenses(plan, LicensePlan::getPersonal);
    }

    public List<FloatingLicensePack> floating(String plan) {
        return this.licenses(plan, LicensePlan::getFloating);
    }

    private <T> List<T> licenses(String plan, Function<LicensePlan, List<T>> get) {
        Optional<LicensePlan> mayBePlan = this.plan(plan);
        if (!mayBePlan.isPresent()) {
            return Collections.emptyList();
        }
        return get.apply(mayBePlan.get());
    }

    @Override
    public Optional<LicensePlan> plan(String plan) {
        return this.licenses.plan(plan);
    }

    @Reference
    public void installLicenseRegistry(LicenseRegistry registry) {
        this.licenses = registry;
    }
}

