/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.util.ObjectUtil;

public final class RepositoryManager {
    public static final RepositoryManager INSTANCE = new RepositoryManager();
    private static final String REPOSITORIES_KEY = "repositories";
    private static final String ACTIVE_REPOSITORY_KEY = "activeRepository";
    private final IDialogSettings settings;
    private final List<RepositoryManagerListener> listeners = new ArrayList<RepositoryManagerListener>();
    private final LinkedList<String> repositories = new LinkedList();
    private String currentProfileLocation;
    private String activeRepository;

    private RepositoryManager() {
        try {
            Profile currentProfile = P2Util.getAgentManager().getCurrentAgent().getCurrentProfile();
            this.currentProfileLocation = URI.createFileURI((String)currentProfile.getLocation().toString()).toString();
        }
        catch (Throwable throwable) {}
        this.settings = P2UIPlugin.INSTANCE.getDialogSettings(this.getClass().getSimpleName());
        String[] array = this.settings.getArray(REPOSITORIES_KEY);
        if (array != null) {
            this.repositories.addAll(Arrays.asList(array));
        }
        if (this.currentProfileLocation != null) {
            this.repositories.add(this.currentProfileLocation);
        }
        this.activeRepository = this.normalize(this.settings.get(ACTIVE_REPOSITORY_KEY));
    }

    private String normalize(String repository) {
        if (repository != null && repository.length() == 0) {
            return null;
        }
        return repository;
    }

    private void rememberRepositories() {
        ArrayList<String> filteredRepositories = new ArrayList<String>(this.repositories);
        filteredRepositories.remove(this.currentProfileLocation);
        int size = filteredRepositories.size();
        String[] array = size != 0 ? filteredRepositories.toArray(new String[size]) : null;
        this.settings.put(REPOSITORIES_KEY, array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String repository) {
        RepositoryManagerListener[] array;
        List<RepositoryManagerListener> list = this.listeners;
        synchronized (list) {
            array = this.listeners.toArray(new RepositoryManagerListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < array.length) {
            RepositoryManagerListener listener = array[i];
            try {
                if (repository == null) {
                    listener.repositoriesChanged(this);
                } else {
                    listener.activeRepositoryChanged(this, repository);
                }
            }
            catch (Exception ex) {
                P2UIPlugin.INSTANCE.log(ex);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(RepositoryManagerListener listener) {
        List<RepositoryManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(RepositoryManagerListener listener) {
        List<RepositoryManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRepositories() {
        LinkedList<String> linkedList = this.repositories;
        synchronized (linkedList) {
            return this.repositories.toArray(new String[this.repositories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRepository(String repository) {
        boolean changed = false;
        LinkedList<String> linkedList = this.repositories;
        synchronized (linkedList) {
            if (this.repositories.isEmpty() || !this.repositories.getFirst().equals(repository)) {
                this.repositories.remove(repository);
                this.repositories.addFirst(repository);
                this.rememberRepositories();
                changed = true;
            }
        }
        if (changed) {
            this.notifyListeners(null);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRepository(String repository) {
        boolean changed = false;
        LinkedList<String> linkedList = this.repositories;
        synchronized (linkedList) {
            if (this.repositories.remove(repository)) {
                this.rememberRepositories();
                changed = true;
            }
        }
        if (changed) {
            this.notifyListeners(null);
        }
        return changed;
    }

    public String getActiveRepository() {
        return this.activeRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setActiveRepository(String repository) {
        if (!ObjectUtil.equals((Object)this.activeRepository, (Object)(repository = this.normalize(repository)))) {
            if (repository != null) {
                this.addRepository(repository);
            }
            RepositoryManager repositoryManager = this;
            synchronized (repositoryManager) {
                this.activeRepository = repository;
                this.settings.put(ACTIVE_REPOSITORY_KEY, repository);
            }
            this.notifyListeners(repository);
            return true;
        }
        return false;
    }

    public static interface RepositoryManagerListener {
        public void repositoriesChanged(RepositoryManager var1);

        public void activeRepositoryChanged(RepositoryManager var1, String var2);
    }
}

