/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.IBlockTextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.MultiStringMatcher;
import org.eclipse.jface.text.MultiTextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public final class SelectionProcessor {
    private final Implementation<ISelection> NULL_IMPLEMENTATION = new Implementation();
    private final Implementation<ITextSelection> RANGE_IMPLEMENTATION = new Implementation<ITextSelection>(){

        @Override
        TextEdit replace(ITextSelection selection, String replacement) {
            return new ReplaceEdit(selection.getOffset(), selection.getLength(), replacement);
        }

        @Override
        String getText(ITextSelection selection) {
            return selection.getText();
        }

        @Override
        boolean isEmpty(ITextSelection selection) {
            return selection.getLength() <= 0;
        }

        @Override
        boolean isMultiline(ITextSelection selection) throws BadLocationException {
            return SelectionProcessor.this.fDocument.getLineOfOffset(selection.getOffset()) < SelectionProcessor.this.fDocument.getLineOfOffset(selection.getOffset() + selection.getLength());
        }

        @Override
        TextEdit delete(ITextSelection selection) {
            return this.isEmpty(selection) ? new DeleteEdit(selection.getOffset(), 1) : new DeleteEdit(selection.getOffset(), selection.getLength());
        }

        @Override
        TextEdit backspace(ITextSelection selection) throws BadLocationException {
            return this.isEmpty(selection) ? new DeleteEdit(selection.getOffset() - 1, 1) : new DeleteEdit(selection.getOffset(), selection.getLength());
        }

        @Override
        ITextSelection makeEmpty(ITextSelection selection, boolean beginning) {
            return beginning ? new TextSelection(SelectionProcessor.this.fDocument, selection.getOffset(), 0) : new TextSelection(SelectionProcessor.this.fDocument, selection.getOffset() + selection.getLength(), 0);
        }

        @Override
        IRegion[] getRanges(ITextSelection selection) {
            return new IRegion[]{new Region(selection.getOffset(), selection.getLength())};
        }

        @Override
        int getCoveredLines(ITextSelection selection) throws BadLocationException {
            return selection.getEndLine() - selection.getStartLine() + 1;
        }

        @Override
        ITextSelection makeReplaceSelection(ITextSelection selection, String replacement) {
            return new TextSelection(SelectionProcessor.this.fDocument, selection.getOffset() + replacement.length(), 0);
        }

        @Override
        public ISelection makeBackspaceSelection(ITextSelection selection) throws BadLocationException {
            if (this.isEmpty(selection)) {
                return new TextSelection(Math.max(0, selection.getOffset() - 1), selection.getLength());
            }
            return this.makeEmpty(selection, true);
        }
    };
    private final Implementation<IMultiTextSelection> RANGES_IMPLEMENTATION = new Implementation<IMultiTextSelection>(){

        private MultiTextEdit rangeEdits(IMultiTextSelection selection, Function<IRegion, TextEdit> regionToTextEdit) {
            MultiTextEdit res = new MultiTextEdit();
            Arrays.stream(selection.getRegions()).map(regionToTextEdit).filter(Objects::nonNull).forEach(arg_0 -> ((MultiTextEdit)res).addChild(arg_0));
            return res;
        }

        @Override
        TextEdit replace(IMultiTextSelection selection, String replacement) {
            if (replacement.isBlank() || !replacement.contains(System.lineSeparator())) {
                return this.rangeEdits(selection, region -> new ReplaceEdit(region.getOffset(), region.getLength(), replacement));
            }
            MultiTextEdit root = new MultiTextEdit();
            String[] delimiters = SelectionProcessor.this.fDocument.getLegalLineDelimiters();
            MultiStringMatcher delimiterMatcher = MultiStringMatcher.create((String[])delimiters);
            int lastDelim = 0;
            IRegion[] iRegionArray = selection.getRegions();
            int n = iRegionArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                IRegion region2 = iRegionArray[n2];
                if (lastDelim == -1) {
                    string = "";
                } else {
                    MultiStringMatcher.Match m = delimiterMatcher.indexOf((CharSequence)replacement, lastDelim);
                    if (m == null) {
                        string = replacement.substring(lastDelim);
                        lastDelim = -1;
                    } else {
                        string = replacement.substring(lastDelim, m.getOffset());
                        lastDelim = m.getOffset() + m.getText().length();
                    }
                }
                ReplaceEdit replace = new ReplaceEdit(region2.getOffset(), region2.getLength(), string);
                root.addChild((TextEdit)replace);
                ++n2;
            }
            return root;
        }

        @Override
        String getText(IMultiTextSelection selection) throws BadLocationException {
            StringBuilder builder = new StringBuilder();
            IRegion[] iRegionArray = selection.getRegions();
            int n = iRegionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRegion region = iRegionArray[n2];
                builder.append(SelectionProcessor.this.fDocument.get(region.getOffset(), region.getLength()));
                ++n2;
            }
            return builder.toString();
        }

        @Override
        boolean isEmpty(IMultiTextSelection selection) {
            return Arrays.stream(selection.getRegions()).allMatch(r -> r.getLength() == 0);
        }

        @Override
        boolean isMultiline(IMultiTextSelection selection) throws BadLocationException {
            int line = -1;
            IRegion[] iRegionArray = selection.getRegions();
            int n = iRegionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRegion region = iRegionArray[n2];
                if (line == -1) {
                    line = SelectionProcessor.this.fDocument.getLineOfOffset(region.getOffset());
                } else if (line != SelectionProcessor.this.fDocument.getLineOfOffset(region.getOffset()) || line != SelectionProcessor.this.fDocument.getLineOfOffset(region.getOffset() + region.getLength())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        TextEdit delete(IMultiTextSelection selection) {
            if (this.isEmpty(selection)) {
                return this.rangeEdits(selection, region -> new DeleteEdit(region.getOffset(), 1));
            }
            return this.rangeEdits(selection, region -> new DeleteEdit(region.getOffset(), region.getLength()));
        }

        @Override
        TextEdit backspace(IMultiTextSelection selection) throws BadLocationException {
            if (this.isEmpty(selection)) {
                return this.rangeEdits(selection, region -> region.getOffset() == 0 ? null : new DeleteEdit(region.getOffset() - 1, 1));
            }
            return this.rangeEdits(selection, region -> {
                if (region.getLength() > 0) {
                    return new DeleteEdit(region.getOffset(), region.getLength());
                }
                if (region.getOffset() > 0) {
                    return new DeleteEdit(region.getOffset() - 1, 1);
                }
                return null;
            });
        }

        @Override
        IMultiTextSelection makeEmpty(IMultiTextSelection selection, boolean beginning) {
            int[] deletedCount = new int[1];
            return new MultiTextSelection(SelectionProcessor.this.fDocument, (IRegion[])Arrays.stream(selection.getRegions()).map(region -> {
                Region res = beginning ? new Region(region.getOffset() - deletedCount[0], 0) : new Region(region.getOffset() - deletedCount[0] + region.getLength(), 0);
                nArray[0] = deletedCount[0] + region.getLength();
                return res;
            }).toArray(Region[]::new));
        }

        @Override
        IRegion[] getRanges(IMultiTextSelection selection) {
            return (IRegion[])selection.getRegions().clone();
        }

        @Override
        int getCoveredLines(IMultiTextSelection selection) throws BadLocationException {
            int res = 0;
            int lastLine = -1;
            IRegion[] iRegionArray = selection.getRegions();
            int n = iRegionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRegion region = iRegionArray[n2];
                if (lastLine == SelectionProcessor.this.fDocument.getLineOfOffset(region.getOffset())) {
                    --res;
                }
                ++res;
                res += SelectionProcessor.this.fDocument.getLineOfOffset(region.getOffset() + region.getLength()) - SelectionProcessor.this.fDocument.getLineOfOffset(region.getOffset());
                lastLine = SelectionProcessor.this.fDocument.getLineOfOffset(region.getOffset() + region.getLength());
                ++n2;
            }
            return res;
        }

        @Override
        IMultiTextSelection makeReplaceSelection(IMultiTextSelection selection, String replacement) {
            if (!replacement.contains(System.lineSeparator())) {
                int[] offset = new int[1];
                return new MultiTextSelection(SelectionProcessor.this.fDocument, (IRegion[])Arrays.stream(selection.getRegions()).map(region -> {
                    Region res = new Region(region.getOffset() + offset[0] + replacement.length(), 0);
                    nArray[0] = offset[0] + (replacement.length() - region.getLength());
                    return res;
                }).toArray(Region[]::new));
            }
            TextEdit edit = this.replace(selection, replacement);
            if (edit instanceof MultiTextEdit) {
                int offsetDelta = 0;
                ArrayList<Region> afterEdit = new ArrayList<Region>(Math.min(edit.getLength(), selection.getLength()));
                int i = 0;
                while (i < Math.min(edit.getChildrenSize(), selection.getLength())) {
                    ReplaceEdit currentEdit = (ReplaceEdit)edit.getChildren()[i];
                    afterEdit.add(new Region(currentEdit.getOffset() + (offsetDelta += currentEdit.getText().length() - currentEdit.getRegion().getLength()), 0));
                    ++i;
                }
                return new MultiTextSelection(SelectionProcessor.this.fDocument, (IRegion[])afterEdit.toArray(IRegion[]::new));
            }
            return new TextSelection(SelectionProcessor.this.fDocument, edit.getOffset() + replacement.length() - edit.getRegion().getLength(), 0);
        }

        @Override
        public ISelection makeBackspaceSelection(IMultiTextSelection selection) throws BadLocationException {
            int[] removedChars = new int[1];
            return new MultiTextSelection(SelectionProcessor.this.fDocument, (IRegion[])Arrays.stream(selection.getRegions()).map(region -> {
                int length = region.getLength() != 0 ? region.getLength() : (region.getOffset() != 0 ? 1 : 0);
                Region res = new Region(Math.max(0, region.getOffset() - removedChars[0] - (region.getLength() == 0 ? length : 0)), 0);
                nArray[0] = removedChars[0] + length;
                return res;
            }).toArray(Region[]::new));
        }

        @Override
        public ISelection makeDeleteSelection(IMultiTextSelection selection) throws BadLocationException {
            int[] removedChars = new int[1];
            return new MultiTextSelection(SelectionProcessor.this.fDocument, (IRegion[])Arrays.stream(selection.getRegions()).map(region -> {
                int length = region.getLength() != 0 ? region.getLength() : 1;
                Region res = new Region(Math.max(0, region.getOffset() - removedChars[0]), 0);
                nArray[0] = removedChars[0] + length;
                return res;
            }).toArray(Region[]::new));
        }
    };
    private final Implementation<IBlockTextSelection> COLUMN_IMPLEMENTATION = new Implementation<IBlockTextSelection>(){

        private TextEdit replace(IBlockTextSelection selection, String replacement, boolean delete) throws BadLocationException {
            try {
                int startLine = selection.getStartLine();
                int endLine = selection.getEndLine();
                int startColumn = selection.getStartColumn();
                int endColumn = selection.getEndColumn();
                int visualStartColumn = this.computeVisualColumn(startLine, startColumn);
                int visualEndColumn = this.computeVisualColumn(endLine, endColumn);
                MultiTextEdit root = new MultiTextEdit();
                String[] delimiters = SelectionProcessor.this.fDocument.getLegalLineDelimiters();
                MultiStringMatcher delimiterMatcher = MultiStringMatcher.create((String[])delimiters);
                int lastDelim = 0;
                int line = startLine;
                while (line <= endLine) {
                    String string;
                    if (lastDelim == -1) {
                        string = "";
                    } else {
                        MultiStringMatcher.Match m = delimiterMatcher.indexOf((CharSequence)replacement, lastDelim);
                        if (m == null) {
                            string = replacement.substring(lastDelim);
                            lastDelim = -1;
                        } else {
                            string = replacement.substring(lastDelim, m.getOffset());
                            lastDelim = m.getOffset() + m.getText().length();
                        }
                    }
                    TextEdit replace = this.createReplaceEdit(line, visualStartColumn, visualEndColumn, string, delete);
                    root.addChild(replace);
                    ++line;
                }
                while (lastDelim != -1) {
                    TextEdit edit;
                    Object string;
                    MultiStringMatcher.Match m = delimiterMatcher.indexOf((CharSequence)replacement, lastDelim);
                    if (m == null) {
                        string = replacement.substring(lastDelim);
                        lastDelim = -1;
                    } else {
                        string = replacement.substring(lastDelim, m.getOffset());
                        lastDelim = m.getOffset() + m.getText().length();
                    }
                    if (++endLine < SelectionProcessor.this.fDocument.getNumberOfLines()) {
                        edit = this.createReplaceEdit(endLine, visualStartColumn, visualEndColumn, (String)string, delete);
                    } else {
                        int insertLocation = root.getExclusiveEnd();
                        int spaces = visualStartColumn;
                        char[] array = new char[spaces];
                        Arrays.fill(array, ' ');
                        string = TextUtilities.getDefaultLineDelimiter((IDocument)SelectionProcessor.this.fDocument) + String.valueOf(array) + (String)string;
                        edit = new InsertEdit(insertLocation, (String)string);
                        insertLocation += ((String)string).length();
                    }
                    root.addChild(edit);
                }
                return root;
            }
            catch (MalformedTreeException x) {
                Assert.isTrue((boolean)false);
                return null;
            }
        }

        @Override
        TextEdit replace(IBlockTextSelection selection, String replacement) throws BadLocationException {
            return this.replace(selection, replacement, false);
        }

        @Override
        String getText(IBlockTextSelection selection) throws BadLocationException {
            StringBuilder buf = new StringBuilder(selection.getLength());
            int startLine = selection.getStartLine();
            int endLine = selection.getEndLine();
            int startColumn = selection.getStartColumn();
            int endColumn = selection.getEndColumn();
            int visualStartColumn = this.computeVisualColumn(startLine, startColumn);
            int visualEndColumn = this.computeVisualColumn(endLine, endColumn);
            int line = startLine;
            while (line <= endLine) {
                this.appendColumnRange(buf, line, visualStartColumn, visualEndColumn);
                if (line != endLine) {
                    buf.append(SelectionProcessor.this.fDocument.getLineDelimiter(line));
                }
                ++line;
            }
            return buf.toString();
        }

        @Override
        boolean isEmpty(IBlockTextSelection selection) throws BadLocationException {
            int startLine = selection.getStartLine();
            int endLine = selection.getEndLine();
            int startColumn = selection.getStartColumn();
            int endColumn = selection.getEndColumn();
            int visualStartColumn = this.computeVisualColumn(startLine, startColumn);
            int visualEndColumn = this.computeVisualColumn(endLine, endColumn);
            return visualEndColumn == visualStartColumn;
        }

        @Override
        boolean isMultiline(IBlockTextSelection selection) {
            return selection.getEndLine() > selection.getStartLine();
        }

        @Override
        TextEdit delete(IBlockTextSelection selection) throws BadLocationException {
            if (this.isEmpty(selection)) {
                selection = new BlockTextSelection(SelectionProcessor.this.fDocument, selection.getStartLine(), selection.getStartColumn(), selection.getEndLine(), selection.getEndColumn() + 1, SelectionProcessor.this.fTabWidth);
            }
            return this.replace(selection, "", true);
        }

        @Override
        TextEdit backspace(IBlockTextSelection selection) throws BadLocationException {
            if (this.isEmpty(selection) && selection.getStartColumn() > 0) {
                selection = new BlockTextSelection(SelectionProcessor.this.fDocument, selection.getStartLine(), selection.getStartColumn() - 1, selection.getEndLine(), selection.getEndColumn(), SelectionProcessor.this.fTabWidth);
            }
            return this.replace(selection, "");
        }

        @Override
        IBlockTextSelection makeEmpty(IBlockTextSelection selection, boolean beginning) throws BadLocationException {
            int endColumn;
            int endLine;
            int startColumn;
            int startLine;
            if (beginning) {
                startLine = selection.getStartLine();
                startColumn = selection.getStartColumn();
                endLine = selection.getEndLine();
                endColumn = this.computeCharacterColumn(endLine, this.computeVisualColumn(startLine, startColumn));
            } else {
                endLine = selection.getEndLine();
                endColumn = selection.getEndColumn();
                startLine = selection.getStartLine();
                startColumn = this.computeCharacterColumn(startLine, this.computeVisualColumn(endLine, endColumn));
            }
            return new BlockTextSelection(SelectionProcessor.this.fDocument, startLine, startColumn, endLine, endColumn, SelectionProcessor.this.fTabWidth);
        }

        @Override
        IBlockTextSelection makeReplaceSelection(IBlockTextSelection selection, String replacement) throws BadLocationException {
            MultiStringMatcher.Match m = MultiStringMatcher.indexOf((CharSequence)replacement, (int)0, (String[])SelectionProcessor.this.fDocument.getLegalLineDelimiters());
            int length = m != null ? m.getOffset() : replacement.length();
            int startLine = selection.getStartLine();
            int column = selection.getStartColumn() + length;
            int endLine = selection.getEndLine();
            int endColumn = this.computeCharacterColumn(endLine, this.computeVisualColumn(startLine, column));
            return new BlockTextSelection(SelectionProcessor.this.fDocument, startLine, column, endLine, endColumn, SelectionProcessor.this.fTabWidth);
        }

        @Override
        public ISelection makeBackspaceSelection(IBlockTextSelection selection) throws BadLocationException {
            if (!this.isEmpty(selection)) {
                return this.makeEmpty(selection, true);
            }
            int column = Math.max(0, selection.getStartColumn());
            return new BlockTextSelection(SelectionProcessor.this.fDocument, selection.getStartLine(), column, selection.getEndLine(), column, SelectionProcessor.this.fTabWidth);
        }

        @Override
        IRegion[] getRanges(IBlockTextSelection selection) throws BadLocationException {
            int startLine = selection.getStartLine();
            int endLine = selection.getEndLine();
            int visualStartColumn = this.computeVisualColumn(startLine, selection.getStartColumn());
            int visualEndColumn = this.computeVisualColumn(endLine, selection.getEndColumn());
            IRegion[] ranges = new IRegion[endLine - startLine + 1];
            int line = startLine;
            while (line <= endLine) {
                int startColumn = this.computeCharacterColumn(line, visualStartColumn);
                int endColumn = this.computeCharacterColumn(line, visualEndColumn);
                IRegion lineInfo = SelectionProcessor.this.fDocument.getLineInformation(line);
                int lineEnd = lineInfo.getLength();
                startColumn = Math.min(startColumn, lineEnd);
                endColumn = Math.min(endColumn, lineEnd);
                ranges[line - startLine] = new Region(lineInfo.getOffset() + startColumn, endColumn - startColumn);
                ++line;
            }
            return ranges;
        }

        @Override
        int getCoveredLines(IBlockTextSelection selection) throws BadLocationException {
            return selection.getEndLine() - selection.getStartLine() + 1;
        }

        private TextEdit createReplaceEdit(int line, int visualStartColumn, int visualEndColumn, String replacement, boolean delete) throws BadLocationException {
            IRegion info = SelectionProcessor.this.fDocument.getLineInformation(line);
            int lineLength = info.getLength();
            String content = SelectionProcessor.this.fDocument.get(info.getOffset(), lineLength);
            int startColumn = -1;
            int endColumn = -1;
            int visual = 0;
            int offset = 0;
            while (offset < lineLength) {
                if (startColumn == -1) {
                    if (visual == visualStartColumn) {
                        startColumn = !delete && this.isWider(content.charAt(offset), visual) && replacement.isEmpty() ? offset - 1 : offset;
                    } else if (visual > visualStartColumn) {
                        startColumn = this.isWider(content.charAt(offset - 1), visual) ? offset - 1 : offset;
                    }
                }
                if (startColumn != -1) {
                    if (visual == visualEndColumn) {
                        endColumn = offset;
                        break;
                    }
                    if (visual > visualEndColumn) {
                        if (!delete && this.isWider(content.charAt(offset - 1), visual)) {
                            endColumn = offset - 1;
                            break;
                        }
                        endColumn = offset;
                        break;
                    }
                }
                visual += this.visualSizeIncrement(content.charAt(offset), visual);
                ++offset;
            }
            if (startColumn == -1) {
                boolean materializeVirtualSpace;
                boolean bl = materializeVirtualSpace = !replacement.isEmpty();
                if (materializeVirtualSpace) {
                    int spaces = Math.max(0, visualStartColumn - visual);
                    char[] array = new char[spaces];
                    Arrays.fill(array, ' ');
                    return new InsertEdit(info.getOffset() + lineLength, String.valueOf(array) + replacement);
                }
                return new MultiTextEdit();
            }
            if (endColumn == -1) {
                endColumn = lineLength;
            }
            if (replacement.isEmpty()) {
                return new DeleteEdit(info.getOffset() + startColumn, endColumn - startColumn);
            }
            return new ReplaceEdit(info.getOffset() + startColumn, endColumn - startColumn, replacement);
        }

        private void appendColumnRange(StringBuilder buf, int line, int visualStartColumn, int visualEndColumn) throws BadLocationException {
            IRegion info = SelectionProcessor.this.fDocument.getLineInformation(line);
            int lineLength = info.getLength();
            String content = SelectionProcessor.this.fDocument.get(info.getOffset(), lineLength);
            int startColumn = -1;
            int endColumn = -1;
            int visual = 0;
            int offset = 0;
            while (offset < lineLength) {
                if (startColumn == -1 && visual >= visualStartColumn) {
                    startColumn = offset;
                }
                if (visual >= visualEndColumn) {
                    endColumn = offset;
                    break;
                }
                visual += this.visualSizeIncrement(content.charAt(offset), visual);
                ++offset;
            }
            if (startColumn != -1) {
                buf.append(content.substring(startColumn, endColumn == -1 ? lineLength : endColumn));
            }
            if (endColumn == -1) {
                int spaces = Math.max(0, visualEndColumn - Math.max(visual, visualStartColumn));
                int i = 0;
                while (i < spaces) {
                    buf.append(' ');
                    ++i;
                }
            }
        }

        private int computeVisualColumn(int line, int column) throws BadLocationException {
            IRegion info = SelectionProcessor.this.fDocument.getLineInformation(line);
            int lineLength = info.getLength();
            int to = Math.min(lineLength, column);
            String content = SelectionProcessor.this.fDocument.get(info.getOffset(), lineLength);
            int visual = 0;
            int offset = 0;
            while (offset < to) {
                visual += this.visualSizeIncrement(content.charAt(offset), visual);
                ++offset;
            }
            if (column > lineLength) {
                visual += column - lineLength;
            }
            return visual;
        }

        private int computeCharacterColumn(int line, int visualColumn) throws BadLocationException {
            IRegion info = SelectionProcessor.this.fDocument.getLineInformation(line);
            int lineLength = info.getLength();
            String content = SelectionProcessor.this.fDocument.get(info.getOffset(), lineLength);
            int visual = 0;
            int offset = 0;
            while (offset < lineLength) {
                if (visual >= visualColumn) {
                    return offset;
                }
                visual += this.visualSizeIncrement(content.charAt(offset), visual);
                ++offset;
            }
            return lineLength + Math.max(0, visualColumn - visual);
        }

        private boolean isWider(char character, int visual) {
            return this.visualSizeIncrement(character, visual) > 1;
        }

        private int visualSizeIncrement(char character, int visual) {
            if (character > '\u00ff' && SelectionProcessor.this.fStyledText != null) {
                GC gc = null;
                try {
                    gc = new GC((Drawable)SelectionProcessor.this.fStyledText);
                    int charWidth = gc.stringExtent((String)new String((String)Character.toString((char)character))).x;
                    int singleCharWidth = gc.stringExtent((String)" ").x;
                    int n = (int)Math.ceil((double)charWidth / (double)singleCharWidth);
                    return n;
                }
                finally {
                    if (gc != null) {
                        gc.dispose();
                    }
                }
            }
            if (character != '\t') {
                return 1;
            }
            if (SelectionProcessor.this.fTabWidth <= 0) {
                return 0;
            }
            return SelectionProcessor.this.fTabWidth - visual % SelectionProcessor.this.fTabWidth;
        }
    };
    private final IDocument fDocument;
    private final int fTabWidth;
    private IRewriteTarget fRewriteTarget;
    private ISelectionProvider fSelectionProvider;
    private StyledText fStyledText;

    public SelectionProcessor(ITextViewer viewer) {
        this(viewer.getDocument(), viewer.getTextWidget().getTabs());
        if (viewer instanceof ITextViewerExtension) {
            ITextViewerExtension ext = (ITextViewerExtension)((Object)viewer);
            this.fRewriteTarget = ext.getRewriteTarget();
        }
        this.fSelectionProvider = viewer.getSelectionProvider();
        this.fStyledText = viewer.getTextWidget();
    }

    public SelectionProcessor(IDocument document, int tabWidth) {
        Assert.isNotNull((Object)document);
        Assert.isTrue((tabWidth >= 0 ? 1 : 0) != 0);
        this.fDocument = document;
        this.fTabWidth = tabWidth;
    }

    public TextEdit delete(ISelection selection) throws BadLocationException {
        return this.getImplementation(selection).delete(selection);
    }

    public TextEdit backspace(ISelection selection) throws BadLocationException {
        return this.getImplementation(selection).backspace(selection);
    }

    public TextEdit replace(ISelection selection, String replacement) throws BadLocationException {
        return this.getImplementation(selection).replace(selection, replacement);
    }

    public String getText(ISelection selection) throws BadLocationException {
        return this.getImplementation(selection).getText(selection);
    }

    public boolean isEmpty(ISelection selection) throws BadLocationException {
        return this.getImplementation(selection).isEmpty(selection);
    }

    public boolean isMultiline(ISelection selection) throws BadLocationException {
        return this.getImplementation(selection).isMultiline(selection);
    }

    public ISelection makeEmpty(ISelection selection, boolean beginning) throws BadLocationException {
        return this.getImplementation(selection).makeEmpty(selection, beginning);
    }

    private ISelection makeReplaceSelection(ISelection selection, String replacement) throws BadLocationException {
        return this.getImplementation(selection).makeReplaceSelection(selection, replacement);
    }

    private ISelection makeBackspaceSelection(ISelection selection) throws BadLocationException {
        return this.getImplementation(selection).makeBackspaceSelection(selection);
    }

    private ISelection makeDeleteSelection(ISelection selection) throws BadLocationException {
        return this.getImplementation(selection).makeDeleteSelection(selection);
    }

    public void doDelete(ISelection selection) throws BadLocationException {
        TextEdit edit = this.delete(selection);
        boolean complex = edit.hasChildren();
        if (complex && this.fRewriteTarget != null) {
            this.fRewriteTarget.beginCompoundChange();
        }
        try {
            edit.apply(this.fDocument, 2);
            if (this.fSelectionProvider != null) {
                ISelection empty = this.makeDeleteSelection(selection);
                this.fSelectionProvider.setSelection(empty);
            }
        }
        finally {
            if (complex && this.fRewriteTarget != null) {
                this.fRewriteTarget.endCompoundChange();
            }
        }
    }

    public void doBackspace(ISelection selection) throws BadLocationException {
        TextEdit edit = this.backspace(selection);
        boolean complex = edit.hasChildren();
        if (complex && this.fRewriteTarget != null) {
            this.fRewriteTarget.beginCompoundChange();
        }
        try {
            ISelection newSelection = this.makeBackspaceSelection(selection);
            edit.apply(this.fDocument, 2);
            if (this.fSelectionProvider != null) {
                this.fSelectionProvider.setSelection(newSelection);
            }
        }
        finally {
            if (complex && this.fRewriteTarget != null) {
                this.fRewriteTarget.endCompoundChange();
            }
        }
    }

    public void doReplace(ISelection selection, String replacement) throws BadLocationException {
        TextEdit edit = this.replace(selection, replacement);
        boolean complex = edit.hasChildren();
        if (complex && this.fRewriteTarget != null) {
            this.fRewriteTarget.beginCompoundChange();
        }
        try {
            edit.apply(this.fDocument, 2);
            if (this.fSelectionProvider != null) {
                ISelection empty = this.makeReplaceSelection(selection, replacement);
                this.fSelectionProvider.setSelection(empty);
            }
        }
        finally {
            if (complex && this.fRewriteTarget != null) {
                this.fRewriteTarget.endCompoundChange();
            }
        }
    }

    public IRegion[] getRanges(ISelection selection) throws BadLocationException {
        return this.getImplementation(selection).getRanges(selection);
    }

    public int getCoveredLines(ISelection selection) throws BadLocationException {
        return this.getImplementation(selection).getCoveredLines(selection);
    }

    private <T extends ISelection> Implementation<T> getImplementation(ISelection selection) {
        if (selection instanceof IBlockTextSelection) {
            return this.COLUMN_IMPLEMENTATION;
        }
        if (selection instanceof IMultiTextSelection && ((IMultiTextSelection)selection).getRegions().length > 1) {
            return this.RANGES_IMPLEMENTATION;
        }
        if (selection instanceof ITextSelection) {
            return this.RANGE_IMPLEMENTATION;
        }
        return this.NULL_IMPLEMENTATION;
    }

    private static class Implementation<T extends ISelection> {
        private Implementation() {
        }

        TextEdit replace(T selection, String replacement) throws BadLocationException {
            return new MultiTextEdit();
        }

        String getText(T selection) throws BadLocationException {
            return "";
        }

        boolean isEmpty(T selection) throws BadLocationException {
            return selection.isEmpty();
        }

        boolean isMultiline(T selection) throws BadLocationException {
            if (selection == null) {
                throw new NullPointerException();
            }
            return false;
        }

        TextEdit delete(T selection) throws BadLocationException {
            return this.replace(selection, "");
        }

        TextEdit backspace(T selection) throws BadLocationException {
            return this.replace(selection, "");
        }

        T makeEmpty(T selection, boolean beginning) throws BadLocationException {
            return selection;
        }

        IRegion[] getRanges(T selection) throws BadLocationException {
            return new IRegion[0];
        }

        int getCoveredLines(T selection) throws BadLocationException {
            return 0;
        }

        T makeReplaceSelection(T selection, String replacement) throws BadLocationException {
            return this.makeEmpty(selection, false);
        }

        public ISelection makeBackspaceSelection(T selection) throws BadLocationException {
            return this.makeEmpty(selection, true);
        }

        public ISelection makeDeleteSelection(T selection) throws BadLocationException {
            return this.makeEmpty(selection, true);
        }
    }
}

