/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.annotations.Feature;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IGroupSolver;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.AbstractClauseSelectorSolver;

@Feature(value="solver")
public class GroupClauseSelectorSolver<T extends ISolver>
extends AbstractClauseSelectorSolver<T>
implements IGroupSolver {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Integer> varToHighLevel = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> highLevelToVar = new HashMap<Integer, Integer>();

    public GroupClauseSelectorSolver(T solver) {
        super(solver);
    }

    public IConstr addControlableClause(IVecInt literals, int desc) throws ContradictionException {
        if (desc == 0) {
            return super.addClause(literals);
        }
        Integer hlvar = this.getGroupVar(literals, desc);
        literals.push(hlvar);
        return super.addClause(literals);
    }

    protected Integer getGroupVar(IVecInt literals, int groupid) {
        Integer hlvar = this.highLevelToVar.get(groupid);
        if (hlvar == null) {
            hlvar = this.createNewVar(literals);
            this.highLevelToVar.put(groupid, hlvar);
            this.varToHighLevel.put(hlvar, groupid);
        }
        return hlvar;
    }

    public IConstr addNonControlableClause(IVecInt literals) throws ContradictionException {
        return super.addClause(literals);
    }

    @Override
    public IConstr addClause(IVecInt literals, int desc) throws ContradictionException {
        return this.addControlableClause(literals, desc);
    }

    @Override
    public Collection<Integer> getAddedVars() {
        return this.varToHighLevel.keySet();
    }

    @Override
    public int[] model() {
        int[] fullmodel = super.modelWithInternalVariables();
        if (fullmodel == null) {
            return null;
        }
        int[] model = new int[fullmodel.length - this.varToHighLevel.size()];
        int j = 0;
        for (int element : fullmodel) {
            if (this.varToHighLevel.get(Math.abs(element)) != null) continue;
            model[j++] = element;
        }
        return model;
    }

    public Map<Integer, Integer> getVarToHighLevel() {
        return this.varToHighLevel;
    }

    @Override
    public IVecInt unsatExplanation() {
        IVecInt internal = super.unsatExplanation();
        VecInt external = new VecInt(internal.size());
        IteratorInt it = internal.iterator();
        while (it.hasNext()) {
            Integer group;
            int p = it.next();
            if (p > 0) {
                group = this.varToHighLevel.get(p);
            } else {
                Integer negGroup = this.varToHighLevel.get(-p);
                Integer n = group = negGroup == null ? null : Integer.valueOf(-negGroup.intValue());
            }
            if (group == null) continue;
            external.push(group);
        }
        return external;
    }
}

