/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.setup.internal.sync.Messages;
import org.eclipse.oomph.util.HexUtil;
import org.eclipse.oomph.util.IOExceptionWithCause;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.osgi.util.NLS;

public final class SyncUtil {
    private SyncUtil() {
    }

    public static ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new BaseResourceFactoryImpl());
        return resourceSet;
    }

    public static void inititalizeFile(File file, EClass eClass, ResourceSet resourceSet) {
        if (file.length() == 0L) {
            EObject rootObject = EcoreUtil.create((EClass)eClass);
            Resource resource = resourceSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
            resource.getContents().add((Object)rootObject);
            BaseUtil.saveEObject((EObject)rootObject);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDigest(File file) throws IOException {
        String string;
        if (!file.exists()) {
            return null;
        }
        FileInputStream contents = null;
        try {
            contents = new FileInputStream(file);
            string = HexUtil.bytesToHex((byte[])IOUtil.getSHA1((InputStream)contents));
        }
        catch (IOException ex) {
            try {
                throw ex;
                catch (NoSuchAlgorithmException ex2) {
                    throw new IOExceptionWithCause((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(contents);
                throw throwable;
            }
        }
        IOUtil.closeSilent((Closeable)contents);
        return string;
    }

    public static void deleteFile(File file) throws IOException {
        if (file.isFile() && !file.delete()) {
            throw new IOException(NLS.bind((String)Messages.SyncUtil_CouldNotDelete_exception, (Object)file));
        }
    }
}

