/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerDescriptionField;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerItem;

public class MarkerSeverityAndDescriptionField
extends MarkerDescriptionField {
    @Override
    public int compare(MarkerItem item1, MarkerItem item2) {
        int c = Integer.compare(MarkerSupportInternalUtilities.getSeverity(item1), MarkerSupportInternalUtilities.getSeverity(item2));
        if (c != 0) {
            return c;
        }
        return super.compare(item1, item2);
    }

    private Image getImage(MarkerItem item) {
        if (item.getMarker() == null) {
            int severity = ((MarkerCategory)item).getHighestSeverity();
            if (severity >= 1) {
                return MarkerSupportInternalUtilities.getSeverityImage(severity);
            }
            return null;
        }
        int severity = MarkerSupportInternalUtilities.getSeverity(item);
        return MarkerSupportInternalUtilities.getSeverityImage(severity);
    }

    @Override
    public void update(ViewerCell cell) {
        super.update(cell);
        MarkerItem item = (MarkerItem)cell.getElement();
        cell.setImage(this.annotateImage(item, this.getImage(item)));
    }
}

