/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.net.URL;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.Window;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerPage;
import org.eclipse.oomph.ui.MouseHandler;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public abstract class AbstractSimpleDialog
extends Shell {
    public static final Color COLOR_WHITE = UIUtil.getDisplay().getSystemColor(1);
    public static final Color COLOR_LIGHTEST_GRAY = SetupInstallerPlugin.getColor((int)245, (int)245, (int)245);
    public static final Color COLOR_LABEL_FOREGROUND = SetupInstallerPlugin.getColor((int)85, (int)85, (int)85);
    private Composite titleComposite;
    private int returnCode = 0;

    public AbstractSimpleDialog(Display display, int style, int width, int height) {
        super(display, style);
        String titleImageKey;
        Bundle brandingBundle;
        GridLayout verticalLayout = UIUtil.createGridLayout((int)1);
        verticalLayout.marginWidth = 1;
        verticalLayout.marginHeight = 1;
        verticalLayout.verticalSpacing = 0;
        this.setLayout((Layout)verticalLayout);
        this.setSize(width, height);
        this.setImages(Window.getDefaultImages());
        this.setText(PropertiesUtil.getProductName());
        this.setBackground(SetupInstallerPlugin.getColor((int)207, (int)207, (int)207));
        Rectangle bounds = display.getPrimaryMonitor().getBounds();
        this.setLocation(bounds.x + (bounds.width - width) / 2, bounds.y + (bounds.height - height) / 2);
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    AbstractSimpleDialog.this.exitSelected();
                    e.detail = 0;
                    e.doit = false;
                }
            }
        });
        GridLayout titleLayout = UIUtil.createGridLayout((int)2);
        titleLayout.horizontalSpacing = 0;
        titleLayout.verticalSpacing = 0;
        titleLayout.marginLeft = 20;
        titleLayout.marginRight = 14;
        this.titleComposite = new Composite((Composite)this, 0);
        this.titleComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(-1, 72).create());
        this.titleComposite.setLayout((Layout)titleLayout);
        this.titleComposite.setBackgroundMode(2);
        this.titleComposite.setBackground(COLOR_LIGHTEST_GRAY);
        Label titleImageLabel = new Label(this.titleComposite, 0);
        titleImageLabel.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).indent(-1, 26).align(1, 1).create());
        Image titleImage = null;
        IProduct product = Platform.getProduct();
        if (product != null && (brandingBundle = product.getDefiningBundle()) != null && (titleImageKey = product.getProperty("titleImage")) != null) {
            URL url;
            URI titleImageURI = URI.createURI((String)titleImageKey);
            if (titleImageURI.isRelative() && (url = brandingBundle.getEntry(titleImageKey)) != null) {
                titleImageURI = URI.createURI((String)url.toString());
            }
            titleImage = ExtendedImageRegistry.INSTANCE.getImage((Object)titleImageURI);
        }
        if (titleImage == null) {
            titleImage = SetupInstallerPlugin.INSTANCE.getSWTImage("simple/title.png");
        }
        titleImageLabel.setImage(titleImage);
    }

    public int show() {
        this.createUI(this.titleComposite);
        new MouseHandler.MoveAndResize((Control)this){

            protected boolean shouldHookControl(Control control) {
                return super.shouldHookControl(control) || control instanceof SimpleInstallerPage;
            }

            protected Point getMainPoint(Control control, int x, int y) {
                if (control != AbstractSimpleDialog.this) {
                    Point mainPoint = AbstractSimpleDialog.this.toControl(control.toDisplay(x, y));
                    return mainPoint;
                }
                return new Point(x, y);
            }

            protected Point getStart(Control control, int x, int y) {
                return this.getMainPoint(control, x, y);
            }

            protected void beforeStart(Control control, int x, int y) {
                Point mainPoint = this.getMainPoint(control, x, y);
                super.beforeStart((Control)AbstractSimpleDialog.this, mainPoint.x, mainPoint.y);
            }

            protected void afterStart(Control control, Point start, int x, int y) {
                Point mainPoint = this.getMainPoint(control, x, y);
                super.afterStart((Control)AbstractSimpleDialog.this, start, mainPoint.x, mainPoint.y);
            }

            protected void afterEnd(Control control, Point start, int x, int y) {
                Point mainPoint = this.getMainPoint(control, x, y);
                super.afterEnd((Control)AbstractSimpleDialog.this, start, mainPoint.x, mainPoint.y);
            }
        };
        this.open();
        this.runEventLoop();
        return this.returnCode;
    }

    protected void runEventLoop() {
        Display display = this.getDisplay();
        while (!this.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected final int getReturnCode() {
        return this.returnCode;
    }

    protected final void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    protected abstract void createUI(Composite var1);

    protected void exitSelected() {
        this.dispose();
    }

    protected void checkSubclass() {
    }
}

