/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.io.MetadataWriter;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.oomph.internal.ui.GeneralDragAdapter;
import org.eclipse.oomph.internal.ui.GeneralDropAdapter;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.P2Package;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.RepositoryProvider;
import org.eclipse.oomph.p2.impl.RequirementImpl;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.p2.internal.ui.RepositoryManager;
import org.eclipse.oomph.p2.internal.ui.SearchEclipseDialog;
import org.eclipse.oomph.p2.provider.P2ItemProviderAdapterFactory;
import org.eclipse.oomph.p2.provider.RepositoryListItemProvider;
import org.eclipse.oomph.ui.OomphDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.SearchField;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryExplorer
extends ViewPart
implements SearchField.FilterHandler {
    public static final String ID = "org.eclipse.oomph.p2.ui.RepositoryExplorer";
    private static final IDialogSettings SETTINGS = P2UIPlugin.INSTANCE.getDialogSettings(RepositoryExplorer.class.getSimpleName());
    private static final Pattern WILDCARD_FILTER_PATTERN = Pattern.compile("(\\\\.|[*?])");
    static final int DND_OPERATIONS = 7;
    static final List<? extends OomphTransferDelegate> DND_DELEGATES = Collections.singletonList(new OomphTransferDelegate.TextTransferDelegate());
    public static final Transfer[] DND_TRANSFERS = new Transfer[]{DND_DELEGATES.get(0).getTransfer()};
    static final List<? extends OomphTransferDelegate> DND_REPOSITORY_DELEGATES = OomphTransferDelegate.DELEGATES;
    public static final Transfer[] DND_REPOSITORY_TRANSFERS = OomphTransferDelegate.transfers();
    private static final String DEFAULT_CAPABILITY_NAMESPACE = "org.eclipse.equinox.p2.iu";
    private static final String CURRENT_NAMESPACE_KEY = "currentNamespace";
    private static final String EXPERT_MODE_KEY = "expertMode";
    private static final String CATEGORIZE_ITEMS_KEY = "categorizeItems";
    private static final String VERSION_SEGMENT_KEY = "versionSegment";
    private static final String COMPATIBLE_VERSION_KEY = "compatibleVersion";
    private static final String SOURCE_SUFFIX = ".source";
    private static final String SOURCE_FEATURE_SUFFIX = ".source.feature.group";
    private static final Object[] NO_ELEMENTS = new Object[0];
    private final LoadJob loadJob = new LoadJob();
    private final AnalyzeJob analyzeJob = new AnalyzeJob();
    private final Mode categoriesMode = new CategoriesMode();
    private final Mode featuresMode = new FeaturesMode();
    private final Mode capabilitiesMode = new CapabilitiesMode();
    private final RepositoryComboHandler repositoryComboHandler = new RepositoryComboHandler();
    private final RepositoryHistoryListener repositoryHistoryListener = new RepositoryHistoryListener();
    private final VersionProvider versionProvider = new VersionProvider();
    private final CollapseAllAction collapseAllAction = new CollapseAllAction();
    private final SearchRepositoriesAction searchRepositoriesAction = new SearchRepositoriesAction();
    private final SearchRequirementsAction searchRequirementsAction = new SearchRequirementsAction();
    private Composite container;
    private ComboViewer repositoryViewer;
    private CCombo repositoryCombo;
    private RepositoryProvider.Metadata repositoryProvider;
    private Composite selectorComposite;
    private Composite itemsComposite;
    private StructuredViewer itemsViewer;
    private CategoryItem itemsViewerInput;
    private TableViewer versionsViewer;
    private String currentNamespace = SETTINGS.get("currentNamespace");
    private boolean expertMode;
    private boolean categorizeItems;
    private boolean compatibleVersion;
    private Mode mode;
    private IQueryResult<IInstallableUnit> installableUnits;
    private String filter;
    private Pattern filterPattern;
    private FormToolkit formToolkit;

    public RepositoryExplorer() {
        if (this.currentNamespace == null) {
            this.currentNamespace = DEFAULT_CAPABILITY_NAMESPACE;
        }
        this.expertMode = SETTINGS.getBoolean(EXPERT_MODE_KEY);
        String value = SETTINGS.get(CATEGORIZE_ITEMS_KEY);
        this.categorizeItems = value == null || value.length() == 0 ? true : "true".equals(value);
        this.compatibleVersion = SETTINGS.getBoolean(COMPATIBLE_VERSION_KEY);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.searchRepositoriesAction.update();
        this.searchRequirementsAction.update();
    }

    public void dispose() {
        if (this.formToolkit != null) {
            this.formToolkit.dispose();
        }
        this.disposeRepositoryProvider();
        super.dispose();
    }

    private void disposeRepositoryProvider() {
        if (this.repositoryProvider != null) {
            this.repositoryProvider.dispose();
            this.repositoryProvider = null;
        }
    }

    public void setFocus() {
        this.repositoryCombo.setFocus();
    }

    private void updateMode() {
        Mode mode;
        Mode mode2 = this.expertMode ? this.capabilitiesMode : (mode = this.categorizeItems ? this.categoriesMode : this.featuresMode);
        if (this.mode != mode) {
            this.mode = mode;
            GridLayout selectorLayout = new GridLayout();
            selectorLayout.marginWidth = 0;
            selectorLayout.marginHeight = 0;
            this.selectorComposite.setLayout((Layout)selectorLayout);
            mode.fillSelector(this.selectorComposite);
            this.selectorComposite.layout();
            this.selectorComposite.getParent().layout();
            mode.fillItems(this.itemsComposite);
            this.itemsComposite.layout();
            this.itemsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)RepositoryExplorer.this.itemsViewer.getSelection();
                    if (selection.size() == 1) {
                        RepositoryExplorer.this.versionsViewer.setInput(selection.getFirstElement());
                    } else {
                        RepositoryExplorer.this.versionsViewer.setInput(null);
                    }
                }
            });
            this.itemsViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    String id = RepositoryExplorer.this.getSelectedCapatiblityID((Viewer)RepositoryExplorer.this.itemsViewer);
                    if (id != null) {
                        RepositoryExplorer.this.showIUDetails(id, null);
                    }
                }
            });
            this.collapseAllAction.updateEnablement();
            this.analyzeJob.reschedule();
        }
    }

    private void setItems(Item ... items) {
        if (!this.container.isDisposed()) {
            this.versionsViewer.setInput(null);
            this.itemsViewerInput = new CategoryItem();
            this.itemsViewerInput.setChildren(items);
            this.itemsViewer.setInput((Object)this.itemsViewerInput);
            if (this.itemsViewer instanceof TreeViewer && this.filter != null && !(this.mode instanceof CapabilitiesMode)) {
                TreeViewer treeViewer = (TreeViewer)this.itemsViewer;
                treeViewer.expandAll();
            }
        }
    }

    private boolean isFiltered(String string) {
        return this.filter == null || string == null || this.filterPattern.matcher(string).find();
    }

    public void handleFilter(String filter) {
        if (filter == null || filter.length() == 0) {
            this.filter = null;
            this.filterPattern = null;
        } else {
            StringBuffer pattern = new StringBuffer("(\\Q");
            Matcher matcher = WILDCARD_FILTER_PATTERN.matcher(filter);
            while (matcher.find()) {
                String tail;
                String separator = matcher.group(1);
                if (separator.length() == 2) {
                    matcher.appendReplacement(pattern, "");
                    if ("\\E".equals(separator)) {
                        pattern.append("\\E\\\\E\\Q");
                        continue;
                    }
                    if ("\\\\".equals(separator)) {
                        pattern.append("\\E\\\\\\Q");
                        continue;
                    }
                    pattern.append(separator.charAt(1));
                    continue;
                }
                char separatorChar = separator.charAt(0);
                switch (separatorChar) {
                    case '*': {
                        tail = ".*?";
                        break;
                    }
                    case '?': {
                        tail = ".";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Pattern " + WILDCARD_FILTER_PATTERN + " should match a single character");
                    }
                }
                matcher.appendReplacement(pattern, "\\\\E)");
                pattern.append(tail).append("(\\Q");
            }
            matcher.appendTail(pattern);
            pattern.append("\\E)");
            this.filter = filter;
            this.filterPattern = Pattern.compile(pattern.toString(), 2);
        }
        this.analyzeJob.reschedule();
    }

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        this.formToolkit = new FormToolkit(display);
        FormColors colors = this.formToolkit.getColors();
        colors.createColor("initial_repository", FormColors.blend((RGB)colors.getForeground().getRGB(), (RGB)colors.getBackground().getRGB(), (int)75));
        Form form = this.formToolkit.createForm(parent);
        this.container = form.getBody();
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.createRepositoriesArea(this.container);
        this.createItemsArea(this.container);
        this.createVersionsArea(this.container);
        this.updateMode();
        String activeRepository = RepositoryManager.INSTANCE.getActiveRepository();
        this.repositoryComboHandler.setActiveRepository(activeRepository);
        if (activeRepository != null) {
            this.triggerLoad(activeRepository);
        }
        this.hookActions();
    }

    private static CCombo createCombo(Composite parent, int style, boolean grabExcessHorizontalSpace) {
        CCombo combo = new CCombo(parent, style);
        GridData layoutData = new GridData(4, 4, grabExcessHorizontalSpace, false);
        int increaseHeight = 0;
        String ws = Platform.getWS();
        if ("cocoa".equals(ws)) {
            increaseHeight = 7;
        } else if ("gtk".equals(ws)) {
            increaseHeight = 9;
        }
        if (increaseHeight != 0) {
            FontData[] fontData = combo.getFont().getFontData();
            layoutData.heightHint = fontData[0].getHeight() + increaseHeight;
        }
        combo.setLayoutData((Object)layoutData);
        return combo;
    }

    private void createRepositoriesArea(Composite container) {
        this.repositoryCombo = RepositoryExplorer.createCombo(container, 2048, true);
        this.repositoryCombo.setToolTipText("Repository location (type a URL, drop a repository or pick from the drop down history)");
        this.repositoryCombo.addFocusListener((FocusListener)this.repositoryComboHandler);
        this.repositoryCombo.addKeyListener((KeyListener)this.repositoryHistoryListener);
        this.repositoryCombo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!RepositoryExplorer.this.repositoryCombo.isFocusControl()) {
                    RepositoryExplorer.this.repositoryCombo.setFocus();
                }
            }
        });
        this.repositoryViewer = new ComboViewer(this.repositoryCombo);
        this.repositoryViewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.repositoryViewer.setInput((Object)RepositoryManager.INSTANCE);
        this.repositoryViewer.addSelectionChangedListener((ISelectionChangedListener)this.repositoryHistoryListener);
        final GeneralDragAdapter generalDragAdapter = new GeneralDragAdapter((Viewer)this.repositoryViewer, new GeneralDragAdapter.DraggedObjectsFactory(){

            public List<Object> createDraggedObjects(ISelection selection) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                String text = RepositoryExplorer.this.repositoryCombo.getText();
                Point selectionRange = RepositoryExplorer.this.repositoryCombo.getSelection();
                if (selectionRange.y - selectionRange.x > 0) {
                    result.add(text.substring(selectionRange.x, selectionRange.y));
                }
                return result;
            }
        }, DND_REPOSITORY_DELEGATES);
        this.repositoryViewer.addDragSupport(7, DND_TRANSFERS, (DragSourceListener)generalDragAdapter);
        final RepositoryList repositoryList = P2Factory.eINSTANCE.createRepositoryList();
        GeneralDropAdapter generalDropAdapter = new GeneralDropAdapter((Viewer)this.repositoryViewer, (EObject)repositoryList, P2Package.Literals.REPOSITORY_LIST__REPOSITORIES, new GeneralDropAdapter.DroppedObjectHandler(){

            public void handleDroppedObject(Object object) throws Exception {
                Repository repository;
                String url;
                if (object instanceof Repository && !StringUtil.isEmpty((String)(url = (repository = (Repository)object).getURL()))) {
                    RepositoryExplorer.this.activateAndLoadRepository(url);
                }
            }
        });
        AdapterFactoryEditingDomain domain = (AdapterFactoryEditingDomain)ReflectUtil.getValue((String)"domain", (Object)generalDropAdapter);
        ComposedAdapterFactory composedAdapterFactory = (ComposedAdapterFactory)domain.getAdapterFactory();
        AdapterFactory factoryForType = composedAdapterFactory.getFactoryForType((Object)repositoryList);
        if (factoryForType != null) {
            composedAdapterFactory.removeAdapterFactory(factoryForType);
        }
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new P2ItemProviderAdapterFactory(){

            public Adapter createRepositoryListAdapter() {
                if (this.repositoryListItemProvider == null) {
                    this.repositoryListItemProvider = new RepositoryListItemProvider((AdapterFactory)this){

                        protected EStructuralFeature getChildFeature(Object object, Object child) {
                            return P2Package.Literals.REPOSITORY_LIST__REPOSITORIES;
                        }

                        protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
                            ArrayList<Object> filteredCollection = new ArrayList<Object>();
                            if (collection != null) {
                                for (Object object : collection) {
                                    URI uri;
                                    IPath path;
                                    if (object instanceof URI) {
                                        URI uri2 = (URI)object;
                                        if (uri2.isPlatform()) {
                                            uri2 = CommonPlugin.resolve((URI)uri2);
                                        }
                                        filteredCollection.add(uri2);
                                        continue;
                                    }
                                    try {
                                        path = (IPath)ReflectUtil.invokeMethod((String)"getFullPath", (Object)ReflectUtil.invokeMethod((String)"getResource", object));
                                        uri = CommonPlugin.resolve((URI)URI.createPlatformResourceURI((String)path.toString(), (boolean)true));
                                        filteredCollection.add(uri);
                                    }
                                    catch (Exception exception) {
                                        try {
                                            path = (IPath)ReflectUtil.invokeMethod((String)"getPath", object);
                                            uri = URI.createFileURI((String)path.toFile().getAbsolutePath());
                                            filteredCollection.add(uri);
                                        }
                                        catch (Exception exception2) {
                                            filteredCollection.add(object);
                                        }
                                    }
                                }
                            }
                            return super.createAddCommand(domain, owner, feature, filteredCollection, index);
                        }
                    };
                }
                return this.repositoryListItemProvider;
            }
        });
        this.repositoryViewer.addDropSupport(7, DND_REPOSITORY_TRANSFERS, (DropTargetListener)generalDropAdapter);
        MenuManager contextMenu = generalDragAdapter.getContextMenu();
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                IContributionItem copyAction = manager.find(ActionFactory.COPY.getId());
                if (copyAction == null) {
                    Action generalCopyAction = new Action("Copy"){

                        public void run() {
                            RepositoryExplorer.this.repositoryCombo.copy();
                        }
                    };
                    Point selection = RepositoryExplorer.this.repositoryCombo.getSelection();
                    generalCopyAction.setEnabled(selection.y - selection.x > 0);
                    generalCopyAction.setId(ActionFactory.COPY.getId());
                    generalCopyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
                    copyAction = new ActionContributionItem((IAction)generalCopyAction);
                    manager.add(copyAction);
                }
                Action cutAction = new Action("Cut"){

                    public void run() {
                        RepositoryExplorer.this.repositoryCombo.cut();
                    }
                };
                cutAction.setEnabled(copyAction.isEnabled());
                cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
                manager.insertBefore(copyAction.getId(), (IAction)cutAction);
                PasteAction pasteAction = new PasteAction(generalDragAdapter.getEditingDomain()){

                    public void run() {
                        super.run();
                        Collection result = this.command.getResult();
                        String repository = result.iterator().next().toString();
                        RepositoryExplorer.this.repositoryCombo.setText(repository);
                        RepositoryExplorer.this.repositoryCombo.setSelection(new Point(0, repository.length()));
                        RepositoryExplorer.this.repositoryHistoryListener.selectionChanged(null);
                    }
                };
                pasteAction.setText("Paste");
                pasteAction.setEnabled(pasteAction.updateSelection((IStructuredSelection)new StructuredSelection((Object)repositoryList)));
                Object generalPasteAction = pasteAction;
                if (!pasteAction.isEnabled()) {
                    generalPasteAction = new Action("Paste"){

                        public void run() {
                            RepositoryExplorer.this.repositoryCombo.paste();
                        }
                    };
                }
                generalPasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
                manager.add((IAction)generalPasteAction);
            }
        });
    }

    private void createItemsArea(Composite parent) {
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        Composite container = this.formToolkit.createComposite(parent, 0);
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        SearchField searchField = new SearchField(container, this){

            protected void finishFilter() {
                RepositoryExplorer.this.itemsViewer.getControl().setFocus();
                this.selectFirstLeaf(RepositoryExplorer.this.itemsViewerInput);
            }

            private void selectFirstLeaf(CategoryItem category) {
                Item[] children;
                if (category != null && (children = category.getChildren()) != null && children.length != 0) {
                    Item firstChild = children[0];
                    if (firstChild instanceof CategoryItem) {
                        CategoryItem firstCategory = (CategoryItem)firstChild;
                        this.selectFirstLeaf(firstCategory);
                    } else {
                        RepositoryExplorer.this.itemsViewer.setSelection((ISelection)new StructuredSelection((Object)firstChild));
                    }
                }
            }
        };
        searchField.getFilterControl().setToolTipText("Filter text may use * to match any characters or ? to match one character)");
        searchField.setLayoutData((Object)new GridData(4, 128, true, false));
        this.selectorComposite = this.formToolkit.createComposite(container, 0);
        this.selectorComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.itemsComposite = this.formToolkit.createComposite(container, 0);
        this.itemsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.itemsComposite.setLayout((Layout)new FillLayout());
    }

    private void createVersionsArea(Composite container) {
        Composite versionsComposite = this.formToolkit.createComposite(container, 0);
        GridLayout gl_versionsComposite = new GridLayout(2, false);
        gl_versionsComposite.marginWidth = 0;
        gl_versionsComposite.marginHeight = 0;
        versionsComposite.setLayout((Layout)gl_versionsComposite);
        versionsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.versionsViewer = new TableViewer(versionsComposite, 2048);
        this.versionsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.versionsViewer.setContentProvider((IContentProvider)this.versionProvider);
        this.versionsViewer.setLabelProvider((IBaseLabelProvider)this.versionProvider);
        this.addDragSupport((StructuredViewer)this.versionsViewer);
        this.versionsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Version version;
                String id = RepositoryExplorer.this.getSelectedCapatiblityID((Viewer)RepositoryExplorer.this.versionsViewer);
                if (id != null && (version = RepositoryExplorer.this.getSelectedVersion((Viewer)RepositoryExplorer.this.versionsViewer)) != null) {
                    RepositoryExplorer.this.showIUDetails(id, version);
                }
            }
        });
        this.formToolkit.adapt(this.versionsViewer.getControl(), false, false);
        Composite versionsGroup = this.formToolkit.createComposite(versionsComposite, 0);
        versionsGroup.setLayout((Layout)new GridLayout(1, false));
        versionsGroup.setLayoutData((Object)new GridData(16384, 128, false, false));
        final Button compatibleButton = new Button(versionsGroup, 32);
        compatibleButton.setText("Compatible");
        compatibleButton.setToolTipText("Show compatible versions");
        compatibleButton.setSelection(this.compatibleVersion);
        final Button majorButton = this.addVersionSegmentButton(versionsGroup, "Major", "Show major versions", VersionSegment.MAJOR);
        final Button minorButton = this.addVersionSegmentButton(versionsGroup, "Minor", "Show minor versions", VersionSegment.MINOR);
        this.addVersionSegmentButton(versionsGroup, "Micro", "Show micro versions", VersionSegment.MICRO);
        this.addVersionSegmentButton(versionsGroup, "Qualifier", "Show qualified versions", VersionSegment.QUALIFIER);
        majorButton.setEnabled(!this.compatibleVersion);
        compatibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean compatible = compatibleButton.getSelection();
                if (RepositoryExplorer.this.compatibleVersion != compatible) {
                    RepositoryExplorer.this.compatibleVersion = compatible;
                    SETTINGS.put(RepositoryExplorer.COMPATIBLE_VERSION_KEY, RepositoryExplorer.this.compatibleVersion);
                    majorButton.setEnabled(!compatible);
                    if (compatible && RepositoryExplorer.this.versionProvider.getVersionSegment() == VersionSegment.MAJOR) {
                        majorButton.setSelection(false);
                        minorButton.setSelection(true);
                        RepositoryExplorer.this.versionProvider.setVersionSegment(VersionSegment.MINOR);
                    }
                }
            }
        });
    }

    private Button addVersionSegmentButton(Composite parent, String text, String toolTip, final VersionSegment versionSegment) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.setToolTipText(toolTip);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryExplorer.this.versionProvider.setVersionSegment(versionSegment);
            }
        });
        if (versionSegment == this.versionProvider.getVersionSegment()) {
            button.setSelection(true);
        }
        return button;
    }

    private void hookActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.add((IContributionItem)new Separator("additions"));
        toolbarManager.add((IAction)this.collapseAllAction);
        toolbarManager.add((IAction)new Action("Refresh", P2UIPlugin.INSTANCE.getImageDescriptor("refresh")){
            {
                this.setToolTipText("Reload the active repository and refresh the tree");
            }

            public void run() {
                String activeRepository = RepositoryManager.INSTANCE.getActiveRepository();
                if (activeRepository != null) {
                    RepositoryExplorer.this.disposeRepositoryProvider();
                    RepositoryExplorer.this.triggerLoad(activeRepository);
                }
            }
        });
        toolbarManager.add((IContributionItem)new Separator("modes"));
        toolbarManager.add((IAction)new Action("Expert Mode", 2){
            {
                this.setImageDescriptor(P2UIPlugin.INSTANCE.getImageDescriptor("obj16/capability"));
                this.setChecked(RepositoryExplorer.this.expertMode);
            }

            public void run() {
                RepositoryExplorer.this.expertMode = this.isChecked();
                SETTINGS.put(RepositoryExplorer.EXPERT_MODE_KEY, RepositoryExplorer.this.expertMode);
                RepositoryExplorer.this.updateMode();
            }
        });
        toolbarManager.add((IContributionItem)new Separator("search"));
        toolbarManager.add((IAction)this.searchRepositoriesAction);
        toolbarManager.add((IAction)this.searchRequirementsAction);
        toolbarManager.add((IContributionItem)new Separator("end"));
    }

    void activateAndLoadRepository(String repository) {
        if (RepositoryManager.INSTANCE.setActiveRepository(repository)) {
            this.triggerLoad(repository);
        }
    }

    private void triggerLoad(String repository) {
        java.net.URI location;
        block5: {
            try {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                repository = manager.performStringSubstitution(repository);
            }
            catch (Exception exception) {}
            location = null;
            try {
                location = new java.net.URI(repository);
            }
            catch (URISyntaxException uRISyntaxException) {
                File folder = new File(repository);
                if (!folder.isDirectory()) break block5;
                location = folder.toURI();
            }
        }
        if (location != null) {
            this.loadJob.reschedule(location);
        }
    }

    private String getSelectedCapatiblityID(Viewer viewer) {
        Object firstItem = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
        if (firstItem instanceof VersionedItem) {
            VersionedItem item = (VersionedItem)firstItem;
            return item.getName();
        }
        if (firstItem instanceof VersionProvider.ItemVersion) {
            VersionProvider.ItemVersion itemVersion = (VersionProvider.ItemVersion)firstItem;
            return itemVersion.getItem().getName();
        }
        return null;
    }

    private Version getSelectedVersion(Viewer viewer) {
        Object firstVersion = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
        if (firstVersion instanceof VersionProvider.ItemVersion) {
            VersionProvider.ItemVersion itemVersion = (VersionProvider.ItemVersion)firstVersion;
            return itemVersion.getVersion();
        }
        return null;
    }

    protected void showIUDetails(String id, Version version) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IUWriter writer = new IUWriter(baos);
            boolean first = true;
            VersionRange versionRange = version == null ? VersionRange.emptyRange : P2Factory.eINSTANCE.createVersionRange(version, this.versionProvider.getVersionSegment(), this.compatibleVersion);
            IRequirement requirement = MetadataFactory.createRequirement((String)(this.expertMode ? this.currentNamespace : DEFAULT_CAPABILITY_NAMESPACE), (String)id, (VersionRange)versionRange, null, (boolean)true, (boolean)true, (boolean)true);
            IMatchExpression matches = requirement.getMatches();
            IQueryResult query = this.installableUnits.query(QueryUtil.createMatchQuery((IExpression)matches, (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
            ArrayList<Version> versions = new ArrayList<Version>();
            int count = 0;
            int limit = 100;
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)query)) {
                for (IProvidedCapability providedCapability : iu.getProvidedCapabilities()) {
                    Version providedCapabilityVersion;
                    if (!this.currentNamespace.equals(providedCapability.getNamespace()) || !id.equals(providedCapability.getName()) || !versionRange.isIncluded(providedCapabilityVersion = providedCapability.getVersion())) continue;
                    versions.add(providedCapabilityVersion);
                }
                if (++count > limit) continue;
                if (first) {
                    first = false;
                } else {
                    writer.newLine();
                }
                writer.writeInstallableUnit(iu);
                writer.flush();
            }
            if (count > limit) {
                writer.newLine();
                writer.writeString(String.valueOf(count - limit) + " more...");
                writer.newLine();
            }
            String xml = baos.toString("UTF-8");
            new IUDialog(this.getSite().getShell(), xml, this.expertMode ? this.currentNamespace : null, id, versions).open();
        }
        catch (Exception ex) {
            P2UIPlugin.INSTANCE.log(ex);
        }
    }

    private void addDragSupport(final StructuredViewer viewer) {
        final GeneralDragAdapter.DraggedObjectsFactory draggedObjectsFactory = new GeneralDragAdapter.DraggedObjectsFactory(){

            public List<Object> createDraggedObjects(ISelection selection) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                IStructuredSelection ssel = (IStructuredSelection)selection;
                for (Object element : ssel) {
                    Item item;
                    String namespace;
                    VersionRange versionRange = VersionRange.emptyRange;
                    String filter = null;
                    if (element instanceof VersionProvider.ItemVersion) {
                        VersionProvider.ItemVersion itemVersion = (VersionProvider.ItemVersion)element;
                        Version version = itemVersion.getVersion();
                        VersionSegment versionSegment = RepositoryExplorer.this.versionProvider.getVersionSegment();
                        versionRange = P2Factory.eINSTANCE.createVersionRange(version, versionSegment, RepositoryExplorer.this.compatibleVersion);
                        filter = RepositoryExplorer.this.getFilter(itemVersion.getFilters());
                        element = itemVersion.getItem();
                    }
                    if (!(element instanceof Item) || element instanceof StatusItem || element instanceof LoadingItem || (namespace = (item = (Item)element).getNamespace()) == null) continue;
                    if (filter == null && item instanceof VersionedItem) {
                        VersionedItem versionedItem = (VersionedItem)item;
                        LinkedHashSet<IMatchExpression<IInstallableUnit>> allFilters = new LinkedHashSet<IMatchExpression<IInstallableUnit>>();
                        for (Set<IMatchExpression<IInstallableUnit>> filterSets : versionedItem.getVersions().values()) {
                            allFilters.addAll(filterSets);
                        }
                        filter = RepositoryExplorer.this.getFilter(allFilters);
                    }
                    Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                    requirement.setNamespace(namespace);
                    requirement.setName(item.getName());
                    requirement.setVersionRange(versionRange);
                    requirement.setFilter(filter);
                    result.add(requirement);
                }
                return result;
            }
        };
        GeneralDragAdapter generalDragAdapter = new GeneralDragAdapter((Viewer)viewer, draggedObjectsFactory, DND_DELEGATES);
        viewer.addDragSupport(7, DND_TRANSFERS, (DragSourceListener)generalDragAdapter);
        final CopyAction copyAction = new CopyAction(generalDragAdapter.getEditingDomain());
        try {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            copyAction.setText("Copy with Version Range");
        }
        catch (RuntimeException runtimeException) {}
        MenuManager contextMenu = generalDragAdapter.getContextMenu();
        final CopyAction simpleCopyAction = generalDragAdapter.getCopyAction();
        viewer.getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                RepositoryExplorer.this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), null);
            }

            public void focusGained(FocusEvent e) {
                RepositoryExplorer.this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)simpleCopyAction);
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList selectedObjects = new ArrayList();
                try {
                    selectedObjects.addAll(draggedObjectsFactory.createDraggedObjects(event.getSelection()));
                }
                catch (Exception ex) {
                    P2UIPlugin.INSTANCE.log(ex);
                }
                simpleCopyAction.setEnabled(simpleCopyAction.updateSelection((IStructuredSelection)new StructuredSelection(selectedObjects)));
            }
        });
        contextMenu.addMenuListener(new IMenuListener(){
            final Action showDetailsAction;
            {
                this.showDetailsAction = new Action("Show Details..."){

                    public void run() {
                        String id = RepositoryExplorer.this.getSelectedCapatiblityID((Viewer)structuredViewer);
                        if (id != null) {
                            RepositoryExplorer.this.showIUDetails(id, RepositoryExplorer.this.getSelectedVersion((Viewer)structuredViewer));
                        }
                    }
                };
            }

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                ArrayList<Object> versionItems = new ArrayList<Object>();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    Object[] elements = RepositoryExplorer.this.versionProvider.getElements(object);
                    if (elements.length > 0) {
                        versionItems.add(elements[elements.length - 1]);
                    }
                    ++n2;
                }
                try {
                    List draggedObjects = draggedObjectsFactory.createDraggedObjects((ISelection)new StructuredSelection(versionItems));
                    if (!draggedObjects.isEmpty()) {
                        copyAction.updateSelection((IStructuredSelection)new StructuredSelection(draggedObjects));
                        manager.add((IAction)copyAction);
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)this.showDetailsAction);
                    }
                }
                catch (Exception ex) {
                    P2UIPlugin.INSTANCE.log(ex);
                }
            }
        });
    }

    private String getFilter(Set<IMatchExpression<IInstallableUnit>> filters) {
        if (filters.contains(null)) {
            return null;
        }
        LinkedHashSet<String> expressions = new LinkedHashSet<String>();
        for (IMatchExpression<IInstallableUnit> filter : filters) {
            expressions.add(RequirementImpl.formatMatchExpression(filter));
        }
        if (expressions.size() == 1) {
            return (String)expressions.iterator().next();
        }
        StringBuilder result = new StringBuilder("");
        for (String expression : expressions) {
            if (result.length() == 0) {
                result.append("(|");
            }
            result.append(expression);
        }
        result.append(')');
        return result.toString();
    }

    private static String[] sortStrings(Collection<String> c) {
        Object[] array = c.toArray(new String[c.size()]);
        Arrays.sort(array);
        return array;
    }

    static void minimizeNamespaces(Set<String> flavors, Set<String> namespaces) {
        String[] flavorIDs = RepositoryExplorer.getMinimalFlavors(flavors);
        Iterator<String> it = namespaces.iterator();
        block0: while (it.hasNext()) {
            String namespace = it.next();
            int i = 0;
            while (i < flavorIDs.length) {
                String flavor = flavorIDs[i];
                if (namespace.startsWith(flavor)) {
                    it.remove();
                    continue block0;
                }
                ++i;
            }
        }
    }

    private static String[] getMinimalFlavors(Set<String> flavors) {
        String[] flavorIDs = RepositoryExplorer.sortStrings(flavors);
        int start = 0;
        while (start < flavorIDs.length) {
            boolean changed = false;
            int i = start + 1;
            while (i < flavorIDs.length) {
                String flavorID = flavorIDs[i];
                if (flavorID.startsWith(flavorIDs[start])) {
                    flavors.remove(flavorID);
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                flavorIDs = RepositoryExplorer.sortStrings(flavors);
            }
            ++start;
        }
        return flavorIDs;
    }

    private static boolean isCategory(IInstallableUnit iu) {
        return "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category"));
    }

    private static boolean isFeature(IInstallableUnit iu) {
        return iu.getId().endsWith(".feature.group");
    }

    public static boolean explore(String repository) {
        IWorkbenchPage page;
        IWorkbenchWindow window = UIUtil.WORKBENCH.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart view = page.findView(ID);
            try {
                view = page.showView(ID);
            }
            catch (PartInitException ex) {
                P2UIPlugin.INSTANCE.log(ex);
            }
            if (view instanceof RepositoryExplorer) {
                if (!StringUtil.isEmpty((String)repository)) {
                    RepositoryExplorer explorer = (RepositoryExplorer)view;
                    explorer.activateAndLoadRepository(repository);
                }
                return true;
            }
        }
        return false;
    }

    public static SearchEclipseDialog.Repositories getSearchEclipseRepositoriesDialog() {
        IViewPart view;
        IWorkbenchPage page;
        IWorkbenchWindow window = UIUtil.WORKBENCH.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (view = page.findView(ID)) instanceof RepositoryExplorer) {
            RepositoryExplorer repositoryExplorer = (RepositoryExplorer)view;
            if (!repositoryExplorer.searchRepositoriesAction.isChecked()) {
                repositoryExplorer.searchRepositoriesAction.setChecked(true);
                repositoryExplorer.searchRepositoriesAction.run();
            }
        }
        return SearchEclipseDialog.Repositories.openFor(window);
    }

    public static SearchEclipseDialog.Requirements getSearchEclipseRequirementDialog() {
        IViewPart view;
        IWorkbenchPage page;
        IWorkbenchWindow window = UIUtil.WORKBENCH.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (view = page.findView(ID)) instanceof RepositoryExplorer) {
            RepositoryExplorer repositoryExplorer = (RepositoryExplorer)view;
            if (!repositoryExplorer.searchRequirementsAction.isChecked()) {
                repositoryExplorer.searchRequirementsAction.setChecked(true);
                repositoryExplorer.searchRequirementsAction.run();
            }
        }
        return SearchEclipseDialog.Requirements.openFor(window);
    }

    private final class AnalyzeJob
    extends SafeJob {
        public AnalyzeJob() {
            super("Analyzing repository");
        }

        public void reschedule() {
            this.cancel();
            if (RepositoryExplorer.this.installableUnits != null) {
                this.schedule();
            }
        }

        protected void doSafe(IProgressMonitor monitor) throws Throwable {
            RepositoryExplorer.this.mode.analyzeInstallableUnits(monitor);
        }
    }

    private final class CapabilitiesMode
    extends Mode {
        private ComboViewer namespaceViewer;

        private CapabilitiesMode() {
        }

        public void fillSelector(Composite parent) {
            this.disposeChildren(parent);
            CCombo namespaceCombo = RepositoryExplorer.createCombo(parent, 0x800808, false);
            namespaceCombo.setToolTipText("Select the namespace of the capabilities to show");
            this.namespaceViewer = new ComboViewer(namespaceCombo);
            this.namespaceViewer.setComparator(new ViewerComparator());
            this.namespaceViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.namespaceViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.namespaceViewer.setInput((Object)new String[]{RepositoryExplorer.this.currentNamespace});
            this.namespaceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)CapabilitiesMode.this.namespaceViewer.getSelection();
                    String newNamespace = (String)selection.getFirstElement();
                    if (newNamespace != null && !ObjectUtil.equals((Object)newNamespace, (Object)RepositoryExplorer.this.currentNamespace)) {
                        SETTINGS.put(RepositoryExplorer.CURRENT_NAMESPACE_KEY, newNamespace);
                        RepositoryExplorer.this.currentNamespace = newNamespace;
                        RepositoryExplorer.this.analyzeJob.reschedule();
                    }
                }
            });
            this.namespaceViewer.setSelection((ISelection)new StructuredSelection((Object)RepositoryExplorer.this.currentNamespace));
        }

        public void fillItems(Composite parent) {
            this.disposeChildren(parent);
            TableViewer capabilitiesViewer = new TableViewer(parent, 268437506);
            capabilitiesViewer.setUseHashlookup(true);
            capabilitiesViewer.setContentProvider((IContentProvider)new ItemContentProvider());
            capabilitiesViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider(capabilitiesViewer.getControl().getFont()));
            RepositoryExplorer.this.addDragSupport((StructuredViewer)capabilitiesViewer);
            RepositoryExplorer.this.itemsViewer = (StructuredViewer)capabilitiesViewer;
        }

        public void analyzeInstallableUnits(IProgressMonitor monitor) {
            HashSet<String> flavors = new HashSet<String>();
            final HashSet<String> namespaces = new HashSet<String>();
            HashMap versions = new HashMap();
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)RepositoryExplorer.this.installableUnits)) {
                IMatchExpression filter = iu.getFilter();
                for (IProvidedCapability capability : iu.getProvidedCapabilities()) {
                    LinkedHashMap map;
                    P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                    String namespace = capability.getNamespace();
                    String name = capability.getName();
                    if ("org.eclipse.equinox.p2.flavor".equals(namespace)) {
                        flavors.add(name);
                    } else if (!"A.PDE.Target.Platform".equalsIgnoreCase(namespace)) {
                        namespaces.add(namespace);
                    }
                    if (!ObjectUtil.equals((Object)namespace, (Object)RepositoryExplorer.this.currentNamespace) || !RepositoryExplorer.this.isFiltered(name)) continue;
                    Version version = capability.getVersion();
                    if (version == null) {
                        version = Version.emptyVersion;
                    }
                    if ((map = (LinkedHashMap)versions.get(name)) == null) {
                        map = new LinkedHashMap();
                        versions.put(name, map);
                    }
                    CollectionUtil.add(map, (Object)version, (Object)filter);
                }
            }
            RepositoryExplorer.minimizeNamespaces(flavors, namespaces);
            if (!namespaces.contains(RepositoryExplorer.this.currentNamespace)) {
                String newCurrentNamespace = null;
                if (namespaces.contains(RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE)) {
                    newCurrentNamespace = RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE;
                } else if (!namespaces.isEmpty()) {
                    newCurrentNamespace = (String)namespaces.iterator().next();
                }
                if (newCurrentNamespace != null) {
                    RepositoryExplorer.this.currentNamespace = newCurrentNamespace;
                    this.analyzeInstallableUnits(monitor);
                    return;
                }
            }
            final CapabilityItem[] capabilityItems = new CapabilityItem[versions.size()];
            Iterator iterator = versions.keySet().iterator();
            int i = 0;
            while (i < capabilityItems.length) {
                String id = (String)iterator.next();
                CapabilityItem capabilityItem = new CapabilityItem();
                capabilityItem.setVersions((Map)versions.get(id));
                capabilityItem.setNamespace(RepositoryExplorer.this.currentNamespace);
                capabilityItem.setLabel(id);
                capabilityItems[i] = capabilityItem;
                ++i;
            }
            UIUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    if (!RepositoryExplorer.this.container.isDisposed()) {
                        if (capabilityItems.length == 0) {
                            RepositoryExplorer.this.setItems(new Item[]{new StatusItem((IStatus)new Status(2, P2UIPlugin.INSTANCE.getSymbolicName(), "No items " + (RepositoryExplorer.this.filter == null ? "" : "matching '" + RepositoryExplorer.this.filter + "'") + "."))});
                        } else {
                            RepositoryExplorer.this.setItems(capabilityItems);
                        }
                        CapabilitiesMode.this.namespaceViewer.setInput((Object)namespaces);
                        CapabilitiesMode.this.namespaceViewer.getCCombo().pack();
                        RepositoryExplorer.this.selectorComposite.getParent().layout();
                        UIUtil.asyncExec((Runnable)new Runnable(){

                            public void run() {
                                if (!RepositoryExplorer.this.container.isDisposed() && RepositoryExplorer.this.currentNamespace != null) {
                                    CapabilitiesMode.this.namespaceViewer.setSelection((ISelection)new StructuredSelection((Object)RepositoryExplorer.this.currentNamespace));
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private static final class CapabilityItem
    extends VersionedItem {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/capability");
        private static final Image FEATURE_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/artifactFeature");
        private static final Image PLUGIN_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/artifactPlugin");
        private static final Image PACKAGE_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("full/obj16/Requirement_Package");
        private static final Image PROJECT_IMAGE = P2UIPlugin.INSTANCE.getSWTImage("full/obj16/Requirement_Project");
        private String namespace;

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public Image getImage() {
            if (RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE.equals(this.namespace)) {
                String label = this.getLabel();
                if (label.endsWith(".feature.group")) {
                    return FEATURE_IMAGE;
                }
                if (label.endsWith(".plain.project")) {
                    return PROJECT_IMAGE;
                }
                return PLUGIN_IMAGE;
            }
            if ("java.package".equals(this.namespace)) {
                return PACKAGE_IMAGE;
            }
            return IMAGE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CategoriesMode
    extends Mode {
        private CategoriesMode() {
        }

        @Override
        public void fillSelector(Composite parent) {
            this.fillCategorySelector(parent);
        }

        @Override
        public void fillItems(Composite parent) {
            this.disposeChildren(parent);
            TreeViewer categoriesViewer = new TreeViewer(parent, 2050);
            categoriesViewer.setUseHashlookup(true);
            categoriesViewer.setContentProvider((IContentProvider)new ItemContentProvider());
            categoriesViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider(categoriesViewer.getControl().getFont()));
            RepositoryExplorer.this.addDragSupport((StructuredViewer)categoriesViewer);
            RepositoryExplorer.this.itemsViewer = (StructuredViewer)categoriesViewer;
        }

        @Override
        public void analyzeInstallableUnits(IProgressMonitor monitor) {
            HashMap<String, String> names = new HashMap<String, String>();
            HashMap<String, Set<IInstallableUnit>> ius = new HashMap<String, Set<IInstallableUnit>>();
            HashMap<String, Set<IRequirement>> categories = new HashMap<String, Set<IRequirement>>();
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)RepositoryExplorer.this.installableUnits)) {
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                Iterator id = iu.getId();
                names.put((String)((Object)id), P2Util.getName((IInstallableUnit)iu));
                CollectionUtil.add(ius, id, (Object)iu);
                if (!RepositoryExplorer.isCategory(iu)) continue;
                CollectionUtil.addAll(categories, id, (Collection)iu.getRequirements());
            }
            HashSet<String> rootIDs = new HashSet<String>();
            for (String categoryID : categories.keySet()) {
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                rootIDs.add(categoryID);
            }
            for (Set requirements : categories.values()) {
                for (IRequirement requirement : requirements) {
                    IRequiredCapability requiredCapability;
                    P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                    if (!P2Util.isSimpleRequiredCapability((IRequirement)requirement) || !RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE.equals((requiredCapability = (IRequiredCapability)requirement).getNamespace())) continue;
                    rootIDs.remove(requiredCapability.getName());
                }
            }
            HashSet<CategoryItem> rootCategories = new HashSet<CategoryItem>();
            for (String rootID : rootIDs) {
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                CategoryItem rootCategory = this.analyzeCategory(names, ius, categories, rootID, monitor);
                if (rootCategory == null) continue;
                rootCategories.add(rootCategory);
            }
            final CategoryItem[] roots = rootCategories.toArray(new CategoryItem[rootCategories.size()]);
            UIUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    if (roots.length == 0) {
                        RepositoryExplorer.this.setItems(new Item[]{new StatusItem((IStatus)new Status(2, P2UIPlugin.INSTANCE.getSymbolicName(), "No categorized items " + (RepositoryExplorer.this.filter == null ? "" : "matching '" + RepositoryExplorer.this.filter + "'") + ". Disable 'Group items by category' to see more."))});
                    } else {
                        RepositoryExplorer.this.setItems(roots);
                    }
                }
            });
        }

        private CategoryItem analyzeCategory(Map<String, String> names, Map<String, Set<IInstallableUnit>> ius, Map<String, Set<IRequirement>> categories, String categoryID, IProgressMonitor monitor) {
            HashMap<String, Item> children = new HashMap<String, Item>();
            HashMap versions = new HashMap();
            for (IRequirement iRequirement : categories.get(categoryID)) {
                IRequiredCapability requiredCapability;
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                if (!P2Util.isSimpleRequiredCapability((IRequirement)iRequirement) || !RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE.equals((requiredCapability = (IRequiredCapability)iRequirement).getNamespace())) continue;
                String requiredID = requiredCapability.getName();
                if (categories.containsKey(requiredID)) {
                    CategoryItem child = this.analyzeCategory(names, ius, categories, requiredID, monitor);
                    if (child == null) continue;
                    children.put(requiredID, child);
                    continue;
                }
                VersionRange range = requiredCapability.getRange();
                Item child = (Item)children.get(requiredID);
                Set<IInstallableUnit> set = ius.get(requiredID);
                if (set == null) continue;
                for (IInstallableUnit iu : set) {
                    String name;
                    P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                    Version version = iu.getVersion();
                    if (!range.isIncluded(version)) continue;
                    if (child == null && RepositoryExplorer.this.isFiltered(name = names.get(requiredID))) {
                        String mainID;
                        String mainName;
                        if (RepositoryExplorer.isFeature(iu)) {
                            if (requiredID.endsWith(RepositoryExplorer.SOURCE_FEATURE_SUFFIX) && ObjectUtil.equals((Object)name, (Object)(mainName = names.get(mainID = String.valueOf(requiredID.substring(0, requiredID.length() - RepositoryExplorer.SOURCE_FEATURE_SUFFIX.length())) + ".feature.group")))) {
                                name = String.valueOf(name) + " (Source)";
                            }
                            child = new FeatureItem(requiredID);
                        } else {
                            if (requiredID.endsWith(RepositoryExplorer.SOURCE_SUFFIX) && ObjectUtil.equals((Object)name, (Object)(mainName = names.get(mainID = requiredID.substring(0, requiredID.length() - RepositoryExplorer.SOURCE_SUFFIX.length()))))) {
                                name = String.valueOf(name) + " (Source)";
                            }
                            child = new PluginItem(requiredID);
                        }
                        child.setLabel(name);
                        children.put(requiredID, child);
                    }
                    if (child == null) continue;
                    IMatchExpression matchExpression = iu.getFilter();
                    HashMap map = (HashMap)versions.get(child);
                    if (map == null) {
                        map = new HashMap();
                        versions.put(child, map);
                    }
                    CollectionUtil.add(map, (Object)version, (Object)matchExpression);
                }
            }
            for (Map.Entry entry : versions.entrySet()) {
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                Item child = (Item)entry.getKey();
                if (!(child instanceof VersionedItem)) continue;
                VersionedItem versionedItem = (VersionedItem)child;
                versionedItem.setVersions((Map)entry.getValue());
            }
            if (children.isEmpty()) {
                return null;
            }
            CategoryItem categoryItem = new CategoryItem(categoryID);
            LinkedHashMap<Version, Set<IMatchExpression<IInstallableUnit>>> map = new LinkedHashMap<Version, Set<IMatchExpression<IInstallableUnit>>>();
            for (IInstallableUnit categoryIU : ius.get(categoryID)) {
                CollectionUtil.add(map, (Object)categoryIU.getVersion(), (Object)categoryIU.getFilter());
            }
            categoryItem.setLabel(names.get(categoryID));
            categoryItem.setChildren(children.values().toArray(new Item[children.size()]));
            categoryItem.setVersions(map);
            return categoryItem;
        }
    }

    private static final class CategoryItem
    extends VersionedItem {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/category");
        private Item[] children;
        private String name;

        public CategoryItem() {
        }

        public CategoryItem(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Image getImage() {
            return IMAGE;
        }

        public boolean hasChildren() {
            return this.children != null && this.children.length != 0;
        }

        public Item[] getChildren() {
            return this.children;
        }

        public void setChildren(Item[] children) {
            Arrays.sort(children);
            this.children = children;
        }

        protected Integer getCategoryOrder() {
            return CATEGORY_ORDER;
        }
    }

    private final class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            super("Collapse All", P2UIPlugin.INSTANCE.getImageDescriptor("collapse-all"));
            this.setToolTipText("Collapse all tree items");
            this.updateEnablement();
        }

        public void updateEnablement() {
            this.setEnabled(RepositoryExplorer.this.itemsViewer instanceof TreeViewer);
        }

        public void run() {
            if (RepositoryExplorer.this.itemsViewer instanceof TreeViewer) {
                TreeViewer treeViewer = (TreeViewer)RepositoryExplorer.this.itemsViewer;
                treeViewer.collapseAll();
            }
        }
    }

    private static final class FeatureItem
    extends VersionedItem {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/artifactFeature");
        private final String id;

        public FeatureItem(String id) {
            this.id = id;
        }

        public Image getImage() {
            return IMAGE;
        }

        public String getName() {
            return this.id;
        }
    }

    private final class FeaturesMode
    extends Mode {
        private FeaturesMode() {
        }

        public void fillSelector(Composite parent) {
            this.fillCategorySelector(parent);
        }

        public void fillItems(Composite parent) {
            this.disposeChildren(parent);
            TableViewer featuresViewer = new TableViewer(parent, 268437506);
            featuresViewer.setUseHashlookup(true);
            featuresViewer.setContentProvider((IContentProvider)new ItemContentProvider());
            featuresViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider(featuresViewer.getControl().getFont()));
            RepositoryExplorer.this.addDragSupport((StructuredViewer)featuresViewer);
            RepositoryExplorer.this.itemsViewer = (StructuredViewer)featuresViewer;
        }

        public void analyzeInstallableUnits(IProgressMonitor monitor) {
            HashMap<String, String> names = new HashMap<String, String>();
            HashMap versions = new HashMap();
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)RepositoryExplorer.this.installableUnits)) {
                String name;
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                String id = iu.getId();
                if (!id.endsWith(".feature.group") || id.endsWith(RepositoryExplorer.SOURCE_FEATURE_SUFFIX) || !RepositoryExplorer.this.isFiltered(name = P2Util.getName((IInstallableUnit)iu))) continue;
                names.put(id, name);
                Version version = iu.getVersion();
                IMatchExpression filter = iu.getFilter();
                HashMap map = (HashMap)versions.get(id);
                if (map == null) {
                    map = new HashMap();
                    versions.put(id, map);
                }
                CollectionUtil.add(map, (Object)version, (Object)filter);
            }
            final FeatureItem[] featureItems = new FeatureItem[versions.size()];
            Iterator iterator = versions.keySet().iterator();
            int i = 0;
            while (i < featureItems.length) {
                P2UIPlugin.checkCancelation((IProgressMonitor)monitor);
                String id = (String)iterator.next();
                Map map = (Map)versions.get(id);
                FeatureItem featureItem = new FeatureItem(id);
                featureItem.setVersions(map);
                featureItem.setLabel((String)names.get(id));
                featureItems[i] = featureItem;
                ++i;
            }
            UIUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    if (featureItems.length == 0) {
                        RepositoryExplorer.this.setItems(new Item[]{new StatusItem((IStatus)new Status(2, P2UIPlugin.INSTANCE.getSymbolicName(), "No feature items " + (RepositoryExplorer.this.filter == null ? "" : "matching '" + RepositoryExplorer.this.filter + "'") + ". Enable 'Expert mode' to see more."))});
                    } else {
                        RepositoryExplorer.this.setItems(featureItems);
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IUDialog
    extends OomphDialog {
        public static final String TITLE = "Installable Unit Details";
        private final String xml;
        private Pattern pattern;

        public IUDialog(Shell parentShell, String xml, String namespace, String id, List<Version> versions) {
            super(parentShell, TITLE, 900, 750, (OomphUIPlugin)P2UIPlugin.INSTANCE, false);
            this.setShellStyle(68656);
            this.xml = xml;
            StringBuilder expression = new StringBuilder();
            if (namespace == null) {
                expression.append("<unit[^>]+'>");
            } else {
                expression.append("<provided namespace='").append(namespace).append("' name='").append(id).append("' version='(");
                int i = 0;
                int size = versions.size();
                while (i < size) {
                    if (i != 0) {
                        expression.append('|');
                    }
                    expression.append(versions.get(i));
                    ++i;
                }
                expression.append(")'/>");
            }
            this.pattern = Pattern.compile(expression.toString());
        }

        protected String getShellText() {
            return TITLE;
        }

        protected String getDefaultMessage() {
            return "Browse the XML representation of the selected installable units.";
        }

        protected String getImagePath() {
            return "wizban/ProfileDetails.png";
        }

        protected void createUI(Composite parent) {
            StyledText text = new StyledText(parent, 832);
            text.setBackground(text.getDisplay().getSystemColor(22));
            text.setLayoutData((Object)new GridData(1808));
            text.setText(this.xml);
            text.setEditable(false);
            ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
            Matcher matcher = this.pattern.matcher(this.xml);
            while (matcher.find()) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = matcher.start();
                styleRange.length = matcher.end() - styleRange.start;
                styleRange.fontStyle = 1;
                styleRanges.add(styleRange);
            }
            text.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        }
    }

    private static final class IUWriter
    extends MetadataWriter {
        private ByteArrayOutputStream output;

        public IUWriter(ByteArrayOutputStream output) throws UnsupportedEncodingException {
            super((OutputStream)output, null);
            this.output = output;
            this.flush();
            output.reset();
        }

        public void writeInstallableUnit(IInstallableUnit resolvedIU) {
            super.writeInstallableUnit(resolvedIU);
        }

        public void flush() {
            super.flush();
        }

        public void newLine() {
            this.writeString(StringUtil.NL);
        }

        public void writeString(String string) {
            try {
                byte[] bytes = string.getBytes("UTF-8");
                this.output.write(bytes, 0, bytes.length);
            }
            catch (Exception ex) {
                P2UIPlugin.INSTANCE.log(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Item
    implements Comparable<Item> {
        private static final Comparator<String> COMPARATOR = CommonPlugin.INSTANCE.getComparator();
        protected static final Integer CATEGORY_ORDER = 0;
        protected static final Integer NON_CATEGORY_ORDER = 1;
        private String label;

        public abstract Image getImage();

        public String getNamespace() {
            return RepositoryExplorer.DEFAULT_CAPABILITY_NAMESPACE;
        }

        public String getName() {
            return this.getLabel();
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = StringUtil.safe((String)label);
        }

        public Item[] getChildren() {
            return null;
        }

        public boolean hasChildren() {
            return false;
        }

        public String toString() {
            return this.label;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public int compareTo(Item o) {
            Integer category2;
            Integer category1 = this.getCategoryOrder();
            int result = category1.compareTo(category2 = o.getCategoryOrder());
            if (result == 0) {
                String label1 = this.label.toLowerCase();
                String label2 = o.label.toLowerCase();
                result = COMPARATOR.compare(label1, label2);
            }
            return result;
        }

        protected Integer getCategoryOrder() {
            return NON_CATEGORY_ORDER;
        }
    }

    private final class ItemContentProvider
    implements ITreeContentProvider {
        private ItemContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object[] getChildren(Object element) {
            Object[] children = ((Item)element).getChildren();
            if (children != null) {
                return children;
            }
            return NO_ELEMENTS;
        }

        public boolean hasChildren(Object element) {
            return ((Item)element).hasChildren();
        }
    }

    private final class ItemLabelProvider
    extends DelegatingStyledCellLabelProvider {
        public ItemLabelProvider(Font font) {
            super(new DelegatingStyledCellLabelProvider.IStyledLabelProvider(font){
                private final StyledString.Styler bold;
                {
                    this.bold = new StyledString.Styler(font){
                        private final Font boldFont;
                        {
                            this.boldFont = ExtendedFontRegistry.INSTANCE.getFont(font, (Object)IItemFontProvider.BOLD_FONT);
                        }

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.font = this.boldFont;
                        }
                    };
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return true;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public StyledString getStyledText(Object element) {
                    Matcher matcher;
                    Item item = (Item)element;
                    String text = item.getLabel();
                    if (RepositoryExplorer.this.filterPattern != null && (matcher = RepositoryExplorer.this.filterPattern.matcher(text)).find()) {
                        StyledString styledString = new StyledString();
                        int tail = matcher.start();
                        styledString.append(text.substring(0, tail));
                        int groupCount = matcher.groupCount();
                        int i = 1;
                        while (i <= groupCount) {
                            int start = matcher.start(i);
                            int end = matcher.end(i);
                            styledString.append(text.substring(tail, start));
                            styledString.append(text.substring(start, end), this.bold);
                            tail = end;
                            ++i;
                        }
                        styledString.append(text.substring(tail, matcher.end()));
                        styledString.append(text.substring(matcher.end()));
                        return styledString;
                    }
                    return new StyledString(text);
                }

                public Image getImage(Object element) {
                    Item item = (Item)element;
                    return item.getImage();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LoadJob
    extends SafeJob {
        private java.net.URI location;

        public LoadJob() {
            super("Loading repository");
        }

        public void reschedule(java.net.URI location) {
            this.location = location;
            RepositoryExplorer.this.setItems(new Item[]{new LoadingItem(location)});
            this.cancel();
            this.schedule();
        }

        @Override
        protected void doSafe(IProgressMonitor monitor) throws Throwable {
            RepositoryExplorer.this.analyzeJob.cancel();
            RepositoryExplorer.this.installableUnits = null;
            Agent agent = P2Util.getAgentManager().getCurrentAgent();
            agent.flushRepositoryCaches();
            IMetadataRepositoryManager repositoryManager = agent.getMetadataRepositoryManager();
            if (RepositoryExplorer.this.repositoryProvider == null || !RepositoryExplorer.this.repositoryProvider.getLocation().equals(this.location)) {
                RepositoryExplorer.this.disposeRepositoryProvider();
                RepositoryExplorer.this.repositoryProvider = new RepositoryProvider.Metadata(repositoryManager, this.location);
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
            IMetadataRepository repository = null;
            try {
                repository = (IMetadataRepository)RepositoryExplorer.this.repositoryProvider.getRepository((IProgressMonitor)progress.newChild(100));
            }
            catch (Exception ex) {
                List<IInstallableUnit> ius = null;
                if ("file".equals(this.location.getScheme())) {
                    try {
                        String path = new File(this.location).getAbsolutePath();
                        ius = this.analyzeIUs(path);
                    }
                    catch (Exception exception) {}
                } else if ("platform".equals(this.location.getScheme()) && this.location.getPath() != null && this.location.getPath().startsWith("/resource/")) {
                    ius = this.analyzeIUs(this.location.toString());
                }
                if (ius != null) {
                    RepositoryExplorer.this.installableUnits = (IQueryResult)new CollectionResult(ius);
                    RepositoryExplorer.this.analyzeJob.reschedule();
                    return;
                }
                throw ex;
            }
            if (repository instanceof CompositeMetadataRepository) {
                CompositeMetadataRepository compositeRepository = (CompositeMetadataRepository)repository;
                CompositeRepositoryState state = compositeRepository.toState();
                java.net.URI[] children = state.getChildren();
                final ArrayList<StatusItem> errors = new ArrayList<StatusItem>();
                HashSet<String> messages = new HashSet<String>();
                java.net.URI[] uRIArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    block15: {
                        java.net.URI child = uRIArray[n2];
                        try {
                            java.net.URI absolute = URIUtil.makeAbsolute((java.net.URI)child, (java.net.URI)this.location);
                            if (repositoryManager.loadRepository(absolute, null) == null) {
                                throw new ProvisionException("No repository found at " + absolute + ".");
                            }
                        }
                        catch (Exception ex) {
                            IStatus status = P2UIPlugin.INSTANCE.getStatus(ex);
                            if (!messages.add(status.getMessage())) break block15;
                            errors.add(new StatusItem(status));
                        }
                    }
                    ++n2;
                }
                if (!errors.isEmpty()) {
                    UIUtil.asyncExec((Runnable)new Runnable(){

                        public void run() {
                            RepositoryExplorer.this.setItems(errors.toArray(new Item[errors.size()]));
                        }
                    });
                    return;
                }
            }
            RepositoryExplorer.this.installableUnits = repository.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)progress.newChild(1));
            RepositoryExplorer.this.analyzeJob.reschedule();
        }

        private List<IInstallableUnit> analyzeIUs(String path) throws Exception {
            EFactory eFactory = (EFactory)ReflectUtil.getValue((String)"eINSTANCE", (Object)CommonPlugin.loadClass((String)"org.eclipse.oomph.resources", (String)"org.eclipse.oomph.resources.ResourcesFactory"));
            Method createSourceLocatorMethod = ReflectUtil.getMethod((Object)eFactory, (String)"createSourceLocator", (Class[])new Class[]{String.class, Boolean.TYPE});
            Object sourceLocator = ReflectUtil.invokeMethod((Method)createSourceLocatorMethod, (Object)eFactory, (Object[])new Object[]{path, true});
            Object workspaceIUAnalyzer = CommonPlugin.loadClass((String)"org.eclipse.oomph.targlets.core", (String)"org.eclipse.oomph.targlets.internal.core.WorkspaceIUAnalyzer").newInstance();
            EList iuGeneratorDefaults = (EList)ReflectUtil.getValue((String)"DEFAULTS", (Object)CommonPlugin.loadClass((String)"org.eclipse.oomph.targlets", (String)"org.eclipse.oomph.targlets.IUGenerator"));
            EList result = (EList)ReflectUtil.invokeMethod((Method)ReflectUtil.getMethod(workspaceIUAnalyzer, (String)"analyze", (Class[])new Class[]{createSourceLocatorMethod.getReturnType(), EList.class, IProgressMonitor.class}), workspaceIUAnalyzer, (Object[])new Object[]{sourceLocator, iuGeneratorDefaults, new NullProgressMonitor()});
            return result;
        }
    }

    private static final class LoadingItem
    extends Item {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/repository");
        private final java.net.URI location;

        public LoadingItem(java.net.URI location) {
            this.location = location;
        }

        public Image getImage() {
            return IMAGE;
        }

        public String getLabel() {
            return "Loading " + this.location;
        }
    }

    private abstract class Mode {
        private Mode() {
        }

        protected final void disposeChildren(Composite parent) {
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }

        protected final void fillCategorySelector(Composite parent) {
            Control[] children = parent.getChildren();
            if (children.length == 1 && children[0] instanceof Button) {
                ((Button)children[0]).setSelection(RepositoryExplorer.this.categorizeItems);
                return;
            }
            this.disposeChildren(parent);
            final Button button = new Button(parent, 32);
            button.setText("Group items by category");
            button.setToolTipText("Whether to show items in categories or in a complete list");
            button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            button.setSelection(RepositoryExplorer.this.categorizeItems);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RepositoryExplorer.this.categorizeItems = button.getSelection();
                    SETTINGS.put(RepositoryExplorer.CATEGORIZE_ITEMS_KEY, RepositoryExplorer.this.categorizeItems);
                    RepositoryExplorer.this.updateMode();
                }
            });
        }

        public abstract void fillSelector(Composite var1);

        public abstract void fillItems(Composite var1);

        public abstract void analyzeInstallableUnits(IProgressMonitor var1);
    }

    private static final class PluginItem
    extends VersionedItem {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/artifactPlugin");
        private final String id;

        public PluginItem(String id) {
            this.id = id;
        }

        public Image getImage() {
            return IMAGE;
        }

        public String getName() {
            return this.id;
        }
    }

    private final class RepositoryComboHandler
    implements FocusListener {
        private static final String INITIAL_REPOSITORY_TEXT = "type repository url, drag and drop, or pick from list";
        private Color initialTextForegroundColor;
        private Color originalForeground;

        private RepositoryComboHandler() {
        }

        public void setActiveRepository(String activeRepository) {
            RepositoryExplorer.this.repositoryCombo.setForeground(this.getForegroundColor(activeRepository));
            RepositoryExplorer.this.repositoryCombo.setText(activeRepository == null ? (RepositoryExplorer.this.repositoryCombo.isFocusControl() ? "" : INITIAL_REPOSITORY_TEXT) : activeRepository);
        }

        private Color getForegroundColor(String activeRepository) {
            if (this.originalForeground == null) {
                this.originalForeground = RepositoryExplorer.this.repositoryCombo.getForeground();
            }
            if (this.initialTextForegroundColor == null) {
                this.initialTextForegroundColor = RepositoryExplorer.this.formToolkit.getColors().getColor("initial_repository");
            }
            return activeRepository == null && !RepositoryExplorer.this.repositoryCombo.isFocusControl() ? this.initialTextForegroundColor : this.originalForeground;
        }

        public void focusGained(FocusEvent e) {
            if (RepositoryExplorer.this.repositoryCombo.getText().equals(INITIAL_REPOSITORY_TEXT)) {
                this.setActiveRepository("");
            }
        }

        public void focusLost(FocusEvent e) {
            if (StringUtil.isEmpty((String)RepositoryExplorer.this.repositoryCombo.getText().trim())) {
                this.setActiveRepository(null);
            }
        }
    }

    private final class RepositoryContentProvider
    implements IStructuredContentProvider,
    RepositoryManager.RepositoryManagerListener {
        public RepositoryContentProvider() {
            RepositoryManager.INSTANCE.addListener(this);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
            RepositoryManager.INSTANCE.removeListener(this);
        }

        public Object[] getElements(Object element) {
            return RepositoryManager.INSTANCE.getRepositories();
        }

        public void repositoriesChanged(RepositoryManager repositoryManager) {
            UIUtil.asyncExec((Control)RepositoryExplorer.this.container, (Runnable)new Runnable(){

                public void run() {
                    RepositoryExplorer.this.repositoryViewer.refresh();
                    UIUtil.asyncExec((Control)RepositoryExplorer.this.container, (Runnable)new Runnable(){

                        public void run() {
                            String activeRepository = RepositoryManager.INSTANCE.getActiveRepository();
                            if (activeRepository == null) {
                                RepositoryExplorer.this.repositoryViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                                RepositoryExplorer.this.repositoryComboHandler.setActiveRepository(activeRepository);
                            } else {
                                StructuredSelection selection = new StructuredSelection((Object)activeRepository);
                                RepositoryExplorer.this.repositoryViewer.setSelection((ISelection)selection);
                                RepositoryExplorer.this.repositoryComboHandler.setActiveRepository(activeRepository);
                                RepositoryExplorer.this.repositoryCombo.setSelection(new Point(0, activeRepository.length()));
                            }
                        }
                    });
                }
            });
        }

        public void activeRepositoryChanged(RepositoryManager repositoryManager, String repository) {
            RepositoryExplorer.this.repositoryComboHandler.setActiveRepository(repository);
        }
    }

    private final class RepositoryHistoryListener
    extends KeyAdapter
    implements ISelectionChangedListener {
        private boolean listVisible;
        private String listRepository;

        private RepositoryHistoryListener() {
        }

        public void keyReleased(KeyEvent e) {
            String repository;
            boolean currentListVisible = RepositoryExplorer.this.repositoryCombo.getListVisible();
            if (currentListVisible && !StringUtil.isEmpty((String)(repository = this.getSelectedRepository()))) {
                this.listRepository = repository;
            }
            if (currentListVisible && (e.keyCode == 127 || e.keyCode == 8)) {
                RepositoryManager.INSTANCE.removeRepository(this.listRepository);
            } else if (e.keyCode == 13 && this.listVisible && !currentListVisible) {
                this.selectRepository();
            }
            this.listVisible = currentListVisible;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.listVisible = RepositoryExplorer.this.repositoryCombo.getListVisible();
            if (!this.listVisible) {
                this.selectRepository();
            }
        }

        private void selectRepository() {
            String newRepository = this.getSelectedRepository();
            if (!StringUtil.isEmpty((String)newRepository)) {
                try {
                    URI uri = URI.createURI((String)newRepository);
                    if (uri.scheme() == null || uri.scheme().length() < 2) {
                        newRepository = URI.createFileURI((String)new File(newRepository).getAbsolutePath()).toString();
                        RepositoryExplorer.this.repositoryCombo.setText(newRepository);
                    }
                }
                catch (Exception exception) {}
            }
            RepositoryExplorer.this.activateAndLoadRepository(newRepository);
        }

        private String getSelectedRepository() {
            IStructuredSelection selection = (IStructuredSelection)RepositoryExplorer.this.repositoryViewer.getSelection();
            return selection.isEmpty() ? RepositoryExplorer.this.repositoryCombo.getText() : (String)selection.getFirstElement();
        }
    }

    private abstract class SafeJob
    extends Job {
        public SafeJob(String name) {
            super(name);
        }

        protected final IStatus run(IProgressMonitor monitor) {
            try {
                this.doSafe(monitor);
                return Status.OK_STATUS;
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            catch (Exception ex2) {
                CoreException ex2;
                Throwable cause;
                if (ex2 instanceof P2Exception && (cause = ex2.getCause()) instanceof CoreException) {
                    ex2 = (CoreException)cause;
                }
                final IStatus status = P2UIPlugin.INSTANCE.getStatus(ex2);
                UIUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        RepositoryExplorer.this.setItems(new Item[]{new StatusItem(status)});
                    }
                });
                return Status.OK_STATUS;
            }
            catch (Throwable t) {
                return P2UIPlugin.INSTANCE.getStatus(t);
            }
        }

        protected abstract void doSafe(IProgressMonitor var1) throws Throwable;
    }

    private final class SearchRepositoriesAction
    extends Action {
        public SearchRepositoriesAction() {
            super("Search", 2);
            this.setImageDescriptor(P2UIPlugin.INSTANCE.getImageDescriptor("tool16/search_repository.png"));
            this.setToolTipText("Search Eclipse repositories by provided capabilities");
        }

        public void update() {
            this.setChecked(SearchEclipseDialog.Repositories.getFor(RepositoryExplorer.this.getSite().getWorkbenchWindow()) != null);
        }

        public void run() {
            if (this.isChecked()) {
                final SearchEclipseDialog.Repositories searchEclipseRepositoryDialog = SearchEclipseDialog.Repositories.openFor(RepositoryExplorer.this.getSite().getWorkbenchWindow());
                searchEclipseRepositoryDialog.getDockable().associate((IAction)this);
                searchEclipseRepositoryDialog.getShell().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (searchEclipseRepositoryDialog.getReturnCode() == 0) {
                            try {
                                RepositoryExplorer.this.getViewSite().getWorkbenchWindow().getActivePage().showView(RepositoryExplorer.ID);
                                RepositoryExplorer.this.activateAndLoadRepository(searchEclipseRepositoryDialog.getSelectedRepository());
                            }
                            catch (PartInitException partInitException) {}
                        }
                    }
                });
            } else {
                SearchEclipseDialog.Repositories.closeFor(RepositoryExplorer.this.getSite().getWorkbenchWindow());
            }
        }
    }

    private final class SearchRequirementsAction
    extends Action {
        public SearchRequirementsAction() {
            super("Search", 2);
            this.setImageDescriptor(P2UIPlugin.INSTANCE.getImageDescriptor("tool16/search_requirement.png"));
            this.setToolTipText("Search Eclipse requirements by provided capabilities");
        }

        public void update() {
            this.setChecked(SearchEclipseDialog.Requirements.getFor(RepositoryExplorer.this.getSite().getWorkbenchWindow()) != null);
        }

        public void run() {
            if (this.isChecked()) {
                SearchEclipseDialog.Requirements searchEclipseRepositoryDialog = SearchEclipseDialog.Requirements.openFor(RepositoryExplorer.this.getSite().getWorkbenchWindow());
                searchEclipseRepositoryDialog.getDockable().associate((IAction)this);
            } else {
                SearchEclipseDialog.Requirements.closeFor(RepositoryExplorer.this.getSite().getWorkbenchWindow());
            }
        }
    }

    private static final class StatusItem
    extends Item {
        private final IStatus status;

        public StatusItem(IStatus status) {
            this.status = status;
        }

        public Image getImage() {
            return UIUtil.getStatusImage((int)this.status.getSeverity());
        }

        public String getLabel() {
            return this.status.getMessage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class VersionProvider
    extends LabelProvider
    implements IStructuredContentProvider {
        private static final Image IMAGE = P2UIPlugin.INSTANCE.getSWTImage("obj16/version");
        private TableViewer versionsViewer;
        private VersionSegment versionSegment;

        public VersionProvider() {
            try {
                this.versionSegment = VersionSegment.get((String)SETTINGS.get(RepositoryExplorer.VERSION_SEGMENT_KEY));
            }
            catch (Exception exception) {}
            if (this.versionSegment == null) {
                this.versionSegment = VersionSegment.QUALIFIER;
            }
        }

        public VersionSegment getVersionSegment() {
            return this.versionSegment;
        }

        public void setVersionSegment(VersionSegment versionSegment) {
            if (this.versionSegment != versionSegment) {
                this.versionSegment = versionSegment;
                SETTINGS.put(RepositoryExplorer.VERSION_SEGMENT_KEY, versionSegment.getLiteral());
                if (this.versionsViewer != null) {
                    this.versionsViewer.refresh();
                }
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.versionsViewer = (TableViewer)viewer;
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            VersionedItem versionedItem;
            Map<Version, Set<IMatchExpression<IInstallableUnit>>> versions;
            if (inputElement instanceof VersionedItem && (versions = (versionedItem = (VersionedItem)inputElement).getVersions()) != null) {
                HashSet<ItemVersion> itemVersions = new HashSet<ItemVersion>();
                for (Map.Entry<Version, Set<IMatchExpression<IInstallableUnit>>> entry : versions.entrySet()) {
                    ItemVersion itemVersion = this.getItemVersion(versionedItem, entry.getKey(), entry.getValue());
                    itemVersions.add(itemVersion);
                }
                Object[] array = itemVersions.toArray(new ItemVersion[itemVersions.size()]);
                Arrays.sort(array);
                return array;
            }
            return NO_ELEMENTS;
        }

        public Image getImage(Object element) {
            return IMAGE;
        }

        private ItemVersion getItemVersion(VersionedItem item, Version version, Set<IMatchExpression<IInstallableUnit>> filters) {
            int segments = version.getSegmentCount();
            if (segments == 0) {
                return new ItemVersion(item, version, "0.0.0", filters);
            }
            segments = Math.min(segments, this.versionSegment.ordinal() + 1);
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < segments) {
                String segment = version.getSegment(i).toString();
                if (StringUtil.isEmpty((String)segment)) break;
                if (builder.length() != 0) {
                    builder.append('.');
                }
                builder.append(segment);
                ++i;
            }
            version = Version.create((String)builder.toString());
            if (segments < 3) {
                builder.append(".x");
            }
            return new ItemVersion(item, version, builder.toString(), filters);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class ItemVersion
        implements Comparable<ItemVersion> {
            private final VersionedItem item;
            private final Version version;
            private final String label;
            private final Set<IMatchExpression<IInstallableUnit>> filters;

            public ItemVersion(VersionedItem item, Version version, String label, Set<IMatchExpression<IInstallableUnit>> filters) {
                this.item = item;
                this.version = version;
                this.label = label;
                this.filters = filters;
            }

            public VersionedItem getItem() {
                return this.item;
            }

            public Version getVersion() {
                return this.version;
            }

            public Set<IMatchExpression<IInstallableUnit>> getFilters() {
                return this.filters;
            }

            @Override
            public int compareTo(ItemVersion o) {
                return -this.version.compareTo((Object)o.version);
            }

            public int hashCode() {
                return this.version.hashCode();
            }

            public boolean equals(Object obj) {
                return this.version.equals(((ItemVersion)obj).version);
            }

            public String toString() {
                return this.label;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class VersionedItem
    extends Item {
        private Map<Version, Set<IMatchExpression<IInstallableUnit>>> versions;

        public Map<Version, Set<IMatchExpression<IInstallableUnit>>> getVersions() {
            return this.versions;
        }

        public void setVersions(Map<Version, Set<IMatchExpression<IInstallableUnit>>> map) {
            this.versions = map;
        }
    }
}

