/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination.collections;

import java.util.List;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.nebula.widgets.pagination.collections.DefaultSortProcessor;
import org.eclipse.nebula.widgets.pagination.collections.PageResult;
import org.eclipse.nebula.widgets.pagination.collections.SortProcessor;

public class PageListHelper {
    public static <T> PageResult<T> createPage(List<T> list, PageableController controller) {
        return PageListHelper.createPage(list, controller, DefaultSortProcessor.getInstance());
    }

    public static <T> PageResult<T> createPage(List<T> list, PageableController controller, SortProcessor processor) {
        int pageIndex;
        int sortDirection = controller.getSortDirection();
        if (sortDirection != 0) {
            processor.sort(list, controller.getSortPropertyName(), sortDirection);
        }
        int totalSize = list.size();
        int pageSize = controller.getPageSize();
        int fromIndex = pageIndex = controller.getPageOffset();
        int toIndex = pageIndex + pageSize;
        if (toIndex > totalSize) {
            toIndex = totalSize;
        }
        if (fromIndex > totalSize) {
            fromIndex = totalSize - totalSize % pageSize;
        }
        List<T> content = list.subList(fromIndex, toIndex);
        return new PageResult<T>(content, totalSize);
    }
}

