/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.page;

import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.util.ResourcePool;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberIterator;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class PageNumberPiece
implements PrintPiece {
    private final Device device;
    private final Point size;
    private final PageNumber pageNumber;
    private final TextStyle textStyle;
    private final PageNumberFormat format;

    PageNumberPiece(PageNumberIterator iter, Device device, Point size) {
        this.device = device;
        this.size = size;
        this.pageNumber = iter.pageNumber;
        this.textStyle = iter.textStyle;
        this.format = iter.format;
    }

    @Override
    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    @Override
    public void paint(GC gc, int x, int y) {
        Font oldFont = gc.getFont();
        Color oldForeground = gc.getForeground();
        Point size = this.getSize();
        try {
            ResourcePool resources = ResourcePool.forDevice(this.device);
            gc.setFont(resources.getFont(this.textStyle.getFontData()));
            gc.setForeground(resources.getColor(this.textStyle.getForeground()));
            String text = this.format.format(this.pageNumber);
            gc.drawText(text, x + this.getHorzAlignmentOffset(gc.textExtent((String)text).x, size.x), y, true);
        }
        finally {
            gc.setFont(oldFont);
            gc.setForeground(oldForeground);
        }
    }

    private int getHorzAlignmentOffset(int textWidth, int totalWidth) {
        int offset = 0;
        switch (this.textStyle.getAlignment()) {
            case 0x1000000: {
                offset = (totalWidth - textWidth) / 2;
                break;
            }
            case 131072: {
                offset = totalWidth - textWidth;
            }
        }
        return offset;
    }

    @Override
    public void dispose() {
    }
}

