/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.calculator;

import org.eclipse.nebula.widgets.opal.calculator.CalculatorButtonsComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class Calculator
extends Composite {
    private final Label displayArea;
    private final CalculatorButtonsComposite panel;

    public Calculator(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.displayArea = this.createTextArea();
        this.panel = new CalculatorButtonsComposite(this, 0);
        this.panel.setLayoutData(new GridData(4, 4, true, true));
        this.panel.setDisplayArea(this.displayArea);
        this.displayArea.addListener(1, this.panel.getKeyListener());
    }

    private Label createTextArea() {
        Label text = new Label((Composite)this, 133120);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 150;
        text.setLayoutData((Object)gd);
        text.setText("0");
        text.setBackground(this.getDisplay().getSystemColor(1));
        return text;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        this.panel.addModifyListener(listener);
    }

    public String getValue() {
        this.checkWidget();
        return this.displayArea.getText();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        this.panel.removeModifyListener(listener);
    }

    public void setValue(String value) {
        this.checkWidget();
        new Double(value);
        this.displayArea.setText(value);
    }
}

