/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.effects.stw;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ImageCapture {
    public static void drawOnImage(Image myImage, Control control, int maxWidth, int maxHeight, boolean includeChildren) {
        if (myImage != null && includeChildren && control instanceof Composite) {
            Display display = control.getDisplay();
            Rectangle parentBounds = control.getParent() == null ? control.getBounds() : display.map((Control)control.getParent(), null, control.getBounds());
            Rectangle imgBounds = myImage.getBounds();
            parentBounds.width = imgBounds.width;
            parentBounds.height = imgBounds.height;
            int parentRight = parentBounds.width + parentBounds.x;
            int parentBottom = parentBounds.height + parentBounds.y;
            Control[] children = ((Composite)control).getChildren();
            GC myImageGC = new GC((Drawable)myImage);
            try {
                int i = children.length;
                while (--i >= 0) {
                    Image childImage;
                    Rectangle childBounds;
                    Control child = children[i];
                    if (!child.isVisible() || !parentBounds.intersects(childBounds = display.map(control, null, child.getBounds())) || (childImage = ImageCapture.getImage(child, parentRight - childBounds.x, parentBottom - childBounds.y, true)) == null) continue;
                    try {
                        myImageGC.drawImage(childImage, childBounds.x - parentBounds.x, childBounds.y - parentBounds.y);
                    }
                    finally {
                        childImage.dispose();
                    }
                }
            }
            finally {
                myImageGC.dispose();
            }
        }
    }

    public static Image getImage(Control control, int maxWidth, int maxHeight, boolean includeChildren) {
        Image myImage = ImageCapture.getImage(control, maxWidth, maxHeight);
        ImageCapture.drawOnImage(myImage, control, maxWidth, maxHeight, includeChildren);
        return myImage;
    }

    public static Image getImage(Control aControl, int maxWidth, int maxHeight) {
        Rectangle rect = aControl.getBounds();
        if (rect.width <= 0 || rect.height <= 0) {
            return null;
        }
        Image image = new Image((Device)aControl.getDisplay(), Math.min(rect.width, maxWidth), Math.min(rect.height, maxHeight));
        GC gc = new GC((Drawable)image);
        Font f = aControl.getFont();
        if (f != null) {
            gc.setFont(f);
        }
        aControl.print(gc);
        gc.dispose();
        return image;
    }
}

