/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.ui;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.gitlab.core.GitlabCoreActivator;
import org.eclipse.mylyn.gitlab.ui.GitlabUiActivator;
import org.eclipse.mylyn.internal.gitlab.core.GitlabActivityStyle;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TaskEditorActivityPart
extends AbstractTaskEditorPart {
    private @NonNull List<TaskAttribute> activityAttributes;
    private boolean hasIncoming = false;
    private Section section;
    private Composite activityComposite;
    private final Type listOfMyClassObject = new TypeToken<ArrayList<GitlabActivityStyle>>(){}.getType();
    private final Gson gson = new Gson();

    public TaskEditorActivityPart() {
        this.setPartName("Activity Events");
    }

    public void createControl(Composite parent, final FormToolkit toolkit) {
        this.initialize();
        this.section = this.createSection(parent, toolkit, this.hasIncoming);
        this.section.setText(this.section.getText() + " (" + this.activityAttributes.size() + ")");
        if (this.hasIncoming) {
            this.expandSection(toolkit, this.section);
        } else {
            this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    if (TaskEditorActivityPart.this.activityComposite == null) {
                        TaskEditorActivityPart.this.expandSection(toolkit, TaskEditorActivityPart.this.section);
                        TaskEditorActivityPart.this.getTaskEditorPage().reflow();
                    }
                }
            });
        }
        this.setSection(toolkit, this.section);
    }

    private void initialize() {
        this.activityAttributes = this.getTaskData().getAttributeMapper().getAttributesByType(this.getTaskData(), "activity");
        Collections.sort(this.activityAttributes, Comparator.comparing(TaskAttribute::getId));
        for (TaskAttribute attribute : this.activityAttributes) {
            if (!this.getModel().hasIncomingChanges(attribute)) continue;
            this.hasIncoming = true;
        }
    }

    private void expandSection(FormToolkit toolkit, Section section) {
        this.activityComposite = toolkit.createComposite((Composite)section);
        GridLayout la = EditorUtil.createSectionClientLayout();
        la.numColumns = 4;
        this.activityComposite.setLayout((Layout)la);
        GridData gd = new GridData(1, 2, true, false, 1, 1);
        this.activityComposite.setLayoutData((Object)gd);
        this.getTaskEditorPage().registerDefaultDropListener((Control)section);
        if (this.activityAttributes.size() > 0) {
            this.createActivityList(toolkit);
        } else {
            toolkit.createLabel(this.activityComposite, "No Activity Events");
        }
        toolkit.paintBordersFor(this.activityComposite);
        section.setClient((Control)this.activityComposite);
    }

    private void createActivityList(FormToolkit toolkit) {
        for (TaskAttribute taskAttribute : this.activityAttributes) {
            TaskAttribute commentDate;
            String activityText = taskAttribute.getAttribute("task.common.comment.text").getValue();
            String activityType = taskAttribute.getAttribute("activity").getValue();
            Label labelIcon = toolkit.createLabel(this.activityComposite, "");
            ImageRegistry imageRegistry = GitlabUiActivator.getDefault().getImageRegistry();
            labelIcon.setImage(imageRegistry.get(switch (GitlabCoreActivator.ActivityType.valueOf((String)activityType)) {
                case GitlabCoreActivator.ActivityType.CALENDAR -> "icons/obj12/calendar.png";
                case GitlabCoreActivator.ActivityType.PERSON -> "icons/obj12/person.png";
                case GitlabCoreActivator.ActivityType.PENCIL -> "icons/obj12/pencil.png";
                case GitlabCoreActivator.ActivityType.UNLOCK -> "icons/obj12/lock-open.png";
                case GitlabCoreActivator.ActivityType.LOCK -> "icons/obj12/lock.png";
                case GitlabCoreActivator.ActivityType.CLOSED -> "icons/obj12/closed.png";
                case GitlabCoreActivator.ActivityType.REOPEN -> "icons/obj12/reopen.png";
                case GitlabCoreActivator.ActivityType.LABEL -> "icons/obj12/label.png";
                case GitlabCoreActivator.ActivityType.DESIGN -> "icons/obj12/design.png";
                default -> "icons/obj20/gitlab.png";
            }));
            TaskAttribute author = taskAttribute.getMappedAttribute("task.common.comment.author");
            if (author != null) {
                toolkit.createLabel(this.activityComposite, author.getValue());
            }
            if ((commentDate = taskAttribute.getMappedAttribute("task.common.comment.date")) != null) {
                toolkit.createLabel(this.activityComposite, commentDate.getValue());
            }
            final StyledText text = new StyledText(this.activityComposite, toolkit.getBorderStyle() | toolkit.getOrientation());
            text.setText(activityText);
            text.setForeground(toolkit.getColors().getForeground());
            text.setBackground(toolkit.getColors().getBackground());
            TaskAttribute styleAttribute = taskAttribute.getMappedAttribute("activity.style");
            text.setText(activityText);
            if (styleAttribute == null || styleAttribute.getValue() == null || styleAttribute.getValue().isEmpty()) continue;
            ArrayList stylesFromJson = (ArrayList)this.gson.fromJson(styleAttribute.getValue(), this.listOfMyClassObject);
            this.setStyles(text, stylesFromJson);
            text.addListener(3, event -> {
                int offset;
                if ((event.stateMask & SWT.MOD1) != 0 && (offset = text.getOffsetAtPoint(new Point(event.x, event.y))) != -1) {
                    StyleRange style1 = null;
                    try {
                        style1 = text.getStyleRangeAtOffset(offset);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (style1 != null && style1.underline && style1.underlineStyle == 4) {
                        System.out.println("Click on a Link " + String.valueOf(style1.data));
                        BrowserUtil.openUrl((String)((String)style1.data), (int)131072);
                    }
                }
            });
            text.addListener(32, event -> {
                int offset = text.getOffsetAtPoint(new Point(event.x, event.y));
                if (offset != -1) {
                    StyleRange style1 = null;
                    try {
                        style1 = text.getStyleRangeAtOffset(offset);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (style1 != null && style1.underline && style1.underlineStyle == 4) {
                        final String oldTooltip = text.getToolTipText();
                        text.setToolTipText(String.valueOf(style1.data));
                        Job job = new Job("Deactivate Tooltip"){

                            protected IStatus run(IProgressMonitor monitor) {
                                Display.getDefault().asyncExec(() -> text.setToolTipText(oldTooltip));
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule(8000L);
                    }
                }
            });
        }
    }

    private void setStyles(StyledText textControl, ArrayList<GitlabActivityStyle> stylesFromJson) {
        StyleRange[] ranges = new StyleRange[stylesFromJson.size()];
        int i = 0;
        while (i < stylesFromJson.size()) {
            StyleRange styleRange;
            GitlabActivityStyle gitlabActivityStyle = stylesFromJson.get(i);
            ranges[i] = styleRange = new StyleRange();
            styleRange.start = gitlabActivityStyle.getStart();
            styleRange.length = gitlabActivityStyle.getLength();
            if (gitlabActivityStyle.getColor() != 1) {
                styleRange.background = textControl.getDisplay().getSystemColor(gitlabActivityStyle.getColor());
            }
            if (gitlabActivityStyle.getFontStyle() == 4) {
                styleRange.fontStyle = 0;
                styleRange.underline = true;
                styleRange.underlineStyle = 4;
                styleRange.data = gitlabActivityStyle.getUrl();
            } else {
                styleRange.fontStyle = gitlabActivityStyle.getFontStyle();
            }
            ++i;
        }
        textControl.setStyleRanges(ranges);
    }
}

