/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContextBuilder;
import org.eclipse.mylyn.wikitext.commonmark.internal.SimpleLocator;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlinesSubstitution;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.mylyn.wikitext.util.Preconditions;
import org.eclipse.mylyn.wikitext.util.WikiToStringStyle;

public abstract class Inline {
    private final Line line;
    private final int offset;
    private final int length;

    public Inline(Line line, int offset, int length) {
        this.line = Objects.requireNonNull(line);
        this.offset = offset;
        this.length = length;
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String[])new String[0]);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (String[])new String[0]);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Line getLine() {
        return this.line;
    }

    public Locator getLocator() {
        int lineCharacterOffset = this.getOffset() - this.line.getOffset();
        return new SimpleLocator(this.line, lineCharacterOffset, lineCharacterOffset + this.length);
    }

    public abstract void emit(DocumentBuilder var1);

    public void apply(ProcessingContext context, List<Inline> inlines, Cursor cursor) {
        cursor.advance(this.getLength());
        inlines.add(this);
    }

    Optional<InlinesSubstitution> secondPass(List<Inline> inlines) {
        return Optional.empty();
    }

    public void createContext(ProcessingContextBuilder contextBuilder) {
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Inline other = (Inline)obj;
        return other.offset == this.offset && other.length == this.length;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)WikiToStringStyle.WIKI_TO_STRING_STYLE).append("offset", this.getOffset()).append("length", this.getLength()).toString();
    }
}

