/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.core;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.gitlab.core.GitlabConfiguration;
import org.eclipse.mylyn.gitlab.core.GitlabException;
import org.eclipse.mylyn.internal.gitlab.core.GitlabNewTaskSchema;
import org.eclipse.mylyn.internal.gitlab.core.GitlabRepositoryConnector;
import org.eclipse.mylyn.internal.gitlab.core.GitlabRestClient;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskAttributeMapper;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskSchema;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;

public class GitlabTaskDataHandler
extends AbstractTaskDataHandler {
    protected final GitlabRepositoryConnector connector;

    public GitlabTaskDataHandler(GitlabRepositoryConnector connector) {
        this.connector = connector;
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("Submitting_task", -1);
            GitlabRestClient client = this.connector.getClient(repository);
            IOperationMonitor progress = OperationUtil.convert((IProgressMonitor)monitor, (String)"post taskdata", (int)3);
            try {
                RepositoryResponse repositoryResponse = client.postTaskData(taskData, oldAttributes, progress);
                return repositoryResponse;
            }
            catch (GitlabException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", 2, "Error post taskdata.\n\n" + e.getMessage(), (Throwable)((Object)e)));
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        GitlabConfiguration config;
        data.setVersion("0");
        if (data.isNew()) {
            GitlabNewTaskSchema.getDefault().initialize(data);
        } else {
            GitlabTaskSchema.getDefault().initialize(data);
        }
        if (initializationData != null) {
            this.connector.getTaskMapping(data).merge(initializationData);
        }
        if ((config = this.connector.getRepositoryConfiguration(repository)) != null) {
            config.updateProductOptions(data);
        }
        return true;
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository repository) {
        return new GitlabTaskAttributeMapper(repository);
    }

    public void getMultiTaskData(TaskRepository repository, Set<String> taskIds, TaskDataCollector collector, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("retrive_task", -1);
            GitlabRestClient client = this.connector.getClient(repository);
            try {
                IOperationMonitor progress = OperationUtil.convert((IProgressMonitor)monitor, (String)"post taskdata", (int)3);
                progress.addFlag(IOperationMonitor.OperationFlag.BACKGROUND);
                client.getTaskData(taskIds, repository, collector, progress);
            }
            catch (GitlabException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", 2, "Error get taskdata.\n\n" + e.getMessage(), (Throwable)((Object)e)));
            }
        }
        finally {
            monitor.done();
        }
    }
}

