/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.auth.openid.OpenIdProviderPattern;
import com.google.gerrit.common.data.ApprovalTypes;
import com.google.gerrit.common.data.GitwebLink;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.AuthType;
import com.google.gerrit.reviewdb.Project;
import com.google.gwtexpui.safehtml.client.RegexFindReplace;
import java.util.List;
import java.util.Set;

public class GerritConfig
implements Cloneable {
    protected String registerUrl;
    protected List<OpenIdProviderPattern> allowedOpenIDs;
    protected GitwebLink gitweb;
    protected boolean useContributorAgreements;
    protected boolean useContactInfo;
    protected boolean allowRegisterNewEmail;
    protected AuthType authType;
    protected Set<AccountGeneralPreferences.DownloadScheme> downloadSchemes;
    protected String gitDaemonUrl;
    protected String sshdAddress;
    protected Project.NameKey wildProject;
    protected ApprovalTypes approvalTypes;
    protected Set<Account.FieldName> editableAccountFields;
    protected List<RegexFindReplace> commentLinks;
    protected boolean documentationAvailable;
    protected String backgroundColor;
    protected String topMenuColor;
    protected String textColor;
    protected String trimColor;
    protected String selectionColor;

    public String getRegisterUrl() {
        return this.registerUrl;
    }

    public void setRegisterUrl(String u) {
        this.registerUrl = u;
    }

    public List<OpenIdProviderPattern> getAllowedOpenIDs() {
        return this.allowedOpenIDs;
    }

    public void setAllowedOpenIDs(List<OpenIdProviderPattern> l) {
        this.allowedOpenIDs = l;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthType t) {
        this.authType = t;
    }

    public Set<AccountGeneralPreferences.DownloadScheme> getDownloadSchemes() {
        return this.downloadSchemes;
    }

    public void setDownloadSchemes(Set<AccountGeneralPreferences.DownloadScheme> s) {
        this.downloadSchemes = s;
    }

    public GitwebLink getGitwebLink() {
        return this.gitweb;
    }

    public void setGitwebLink(GitwebLink w) {
        this.gitweb = w;
    }

    public boolean isUseContributorAgreements() {
        return this.useContributorAgreements;
    }

    public void setUseContributorAgreements(boolean r) {
        this.useContributorAgreements = r;
    }

    public boolean isUseContactInfo() {
        return this.useContactInfo;
    }

    public void setUseContactInfo(boolean r) {
        this.useContactInfo = r;
    }

    public String getGitDaemonUrl() {
        return this.gitDaemonUrl;
    }

    public void setGitDaemonUrl(String url) {
        if (url != null && !url.endsWith("/")) {
            url = url + "/";
        }
        this.gitDaemonUrl = url;
    }

    public String getSshdAddress() {
        return this.sshdAddress;
    }

    public void setSshdAddress(String addr) {
        this.sshdAddress = addr;
    }

    public Project.NameKey getWildProject() {
        return this.wildProject;
    }

    public void setWildProject(Project.NameKey wp) {
        this.wildProject = wp;
    }

    public ApprovalTypes getApprovalTypes() {
        return this.approvalTypes;
    }

    public void setApprovalTypes(ApprovalTypes at) {
        this.approvalTypes = at;
    }

    public boolean canEdit(Account.FieldName f) {
        return this.editableAccountFields.contains(f);
    }

    public Set<Account.FieldName> getEditableAccountFields() {
        return this.editableAccountFields;
    }

    public void setEditableAccountFields(Set<Account.FieldName> af) {
        this.editableAccountFields = af;
    }

    public List<RegexFindReplace> getCommentLinks() {
        return this.commentLinks;
    }

    public void setCommentLinks(List<RegexFindReplace> cl) {
        this.commentLinks = cl;
    }

    public boolean isDocumentationAvailable() {
        return this.documentationAvailable;
    }

    public void setDocumentationAvailable(boolean available) {
        this.documentationAvailable = available;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String color) {
        this.backgroundColor = color;
    }

    public String getTopMenuColor() {
        return this.topMenuColor;
    }

    public void setTopMenuColor(String color) {
        this.topMenuColor = color;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String color) {
        this.textColor = color;
    }

    public String getTrimColor() {
        return this.trimColor;
    }

    public void setTrimColor(String color) {
        this.trimColor = color;
    }

    public String getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(String color) {
        this.selectionColor = color;
    }
}

