/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.internal;

import com.google.common.io.Files;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import org.junit.rules.ExternalResource;

@Singleton
public class TemporaryFolder
extends ExternalResource {
    private File folder;
    private boolean initialized = false;

    protected void before() throws Throwable {
        this.initialized = true;
    }

    protected void after() {
        if (this.folder != null) {
            this.delete();
            this.folder = null;
            this.initialized = false;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void create() throws IOException {
        this.folder = Files.createTempDir();
    }

    public File newFile(String fileName) throws IOException {
        File file = new File(this.getRoot(), fileName);
        file.createNewFile();
        return file;
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, prefix, this.getRoot());
    }

    public File newFile() throws IOException {
        return File.createTempFile("junit", null, this.getRoot());
    }

    public File newFolder(String ... folderNames) {
        File file = this.getRoot();
        String[] stringArray = folderNames;
        int n = folderNames.length;
        int n2 = 0;
        while (n2 < n) {
            String folderName = stringArray[n2];
            file = new File(file, folderName);
            file.mkdir();
            ++n2;
        }
        return file;
    }

    public File newFolder() throws IOException {
        try {
            return this.createTempDir(this.getRoot());
        }
        catch (IllegalStateException e) {
            throw new IOException(e.getMessage());
        }
    }

    private File createTempDir(File baseDir) {
        String baseName = String.valueOf(System.currentTimeMillis()) + "-";
        int counter = 0;
        while (counter < 10000) {
            File tempDir = new File(baseDir, String.valueOf(baseName) + counter);
            if (tempDir.mkdir()) {
                return tempDir;
            }
            ++counter;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    public File getRoot() {
        if (this.folder == null) {
            try {
                this.create();
            }
            catch (IOException e) {
                throw new IllegalStateException("the temporary folder could not be created", e);
            }
        }
        return this.folder;
    }

    public void delete() {
        this.recursiveDelete(this.folder);
    }

    private void recursiveDelete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File each = fileArray[n2];
                this.recursiveDelete(each);
                ++n2;
            }
        }
        file.delete();
    }
}

