/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorDescription;
import org.eclipse.xtext.xbase.scoping.batch.SimpleIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorTypeScopeWrapper
implements IScope {
    private final EObject context;
    private final IVisibilityHelper visibilityHelper;
    private final IScope typeScope;
    private final boolean strict;

    public ConstructorTypeScopeWrapper(EObject context, IVisibilityHelper visibilityHelper, IScope typeScope) {
        this(context, visibilityHelper, typeScope, false);
    }

    public ConstructorTypeScopeWrapper(EObject context, IVisibilityHelper visibilityHelper, IScope typeScope, boolean strict) {
        this.context = context;
        this.visibilityHelper = visibilityHelper;
        this.typeScope = typeScope;
        this.strict = strict;
    }

    public Iterable<IEObjectDescription> getAllElements() {
        throw new UnsupportedOperationException();
    }

    protected Iterable<IEObjectDescription> createFeatureDescriptions(Iterable<IEObjectDescription> original) {
        ArrayList result = Lists.newArrayListWithCapacity((int)3);
        for (IEObjectDescription description : original) {
            this.addFeatureDescriptions(description, result);
        }
        return result;
    }

    protected void addFeatureDescriptions(IEObjectDescription typeDescription, List<IEObjectDescription> result) {
        EObject proxy = this.getResolvedProxy(typeDescription);
        if (!proxy.eIsProxy() && proxy instanceof JvmGenericType) {
            JvmGenericType type = (JvmGenericType)proxy;
            if (!type.isInterface()) {
                for (JvmConstructor constructor : type.getDeclaredConstructors()) {
                    boolean visible = this.visibilityHelper.isVisible((JvmMember)constructor);
                    ConstructorDescription constructorDescription = this.createConstructorDescription(typeDescription, constructor, visible);
                    result.add(constructorDescription);
                }
            } else if (!this.strict) {
                result.add(new SimpleIdentifiableElementDescription(typeDescription));
            }
        } else if (proxy instanceof JvmType && !this.strict) {
            result.add(new SimpleIdentifiableElementDescription(typeDescription));
        }
    }

    protected EObject getResolvedProxy(IEObjectDescription description) {
        EObject proxy = description.getEObjectOrProxy();
        if (proxy.eIsProxy()) {
            proxy = EcoreUtil.resolve((EObject)proxy, (EObject)this.context);
        }
        return proxy;
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        if (!(object instanceof JvmConstructor)) {
            return Collections.emptyList();
        }
        JvmConstructor constructor = (JvmConstructor)object;
        Iterable typeDescriptions = this.typeScope.getElements((EObject)constructor.getDeclaringType());
        ArrayList result = Lists.newArrayListWithCapacity((int)3);
        boolean visible = this.visibilityHelper.isVisible((JvmMember)constructor);
        for (IEObjectDescription typeDescription : typeDescriptions) {
            ConstructorDescription constructorDescription = this.createConstructorDescription(typeDescription, constructor, visible);
            result.add(constructorDescription);
        }
        return result;
    }

    protected ConstructorDescription createConstructorDescription(IEObjectDescription typeDescription, JvmConstructor constructor, boolean visible) {
        ConstructorDescription constructorDescription = new ConstructorDescription(typeDescription.getName(), constructor, 1, visible);
        return constructorDescription;
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        Iterable original = this.typeScope.getElements(name);
        return this.createFeatureDescriptions(original);
    }

    public IEObjectDescription getSingleElement(EObject object) {
        throw new UnsupportedOperationException();
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        throw new UnsupportedOperationException();
    }
}

