/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.xtext.ui.JdtTypeRelevance;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.ISimilarityMatcher;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.ReplaceModification;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.typesystem.legacy.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.ui.contentassist.ReplacingAppendable;
import org.eclipse.xtext.xbase.ui.document.DocumentRewriter;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;
import org.eclipse.xtext.xbase.ui.quickfix.ILinkingIssueQuickfixProvider;
import org.eclipse.xtext.xbase.ui.quickfix.TypeNameGuesser;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeQuickfixes
implements ILinkingIssueQuickfixProvider {
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IImportsConfiguration importsConfiguration;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private ISimilarityMatcher similarityMatcher;
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private JdtTypeRelevance jdtTypeRelevance;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;
    @Inject
    private TypeNameGuesser typeNameGuesser;
    @Inject
    private DocumentRewriter.Factory rewriterFactory;
    @Inject
    private ReplaceConverter replaceConverter;

    @Override
    @NonNullByDefault
    public void addQuickfixes(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IXtextDocument xtextDocument, XtextResource resource, EObject referenceOwner, EReference unresolvedReference) throws Exception {
        String issueString = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
        IScope scope = this.scopeProvider.getScope(referenceOwner, unresolvedReference);
        boolean useJavaSearch = this.isUseJavaSearch(unresolvedReference, issue);
        if (useJavaSearch) {
            JvmDeclaredType jvmType = this.importsConfiguration.getContextJvmDeclaredType(referenceOwner);
            IJavaSearchScope javaSearchScope = this.getJavaSearchScope(referenceOwner);
            boolean proposeImports = true;
            if (this.isConstructorReference(unresolvedReference)) {
                boolean bl = proposeImports = !this.createConstructorProposals(jvmType, issue, issueString, javaSearchScope, issueResolutionAcceptor);
            }
            if (proposeImports) {
                this.createImportProposals(jvmType, issue, issueString, javaSearchScope, issueResolutionAcceptor);
            }
            scope = this.getImportedTypesScope(referenceOwner, issueString, scope, javaSearchScope);
        }
        ArrayList discardedDescriptions = Lists.newArrayList();
        HashSet proposedSolutions = Sets.newHashSet();
        int addedDescriptions = 0;
        int checkedDescriptions = 0;
        for (IEObjectDescription referableElement : scope.getAllElements()) {
            String solution = this.qualifiedNameConverter.toString(referableElement.getName());
            if (!Strings.equal((String)issueString, (String)solution) && proposedSolutions.add(solution)) {
                if (useJavaSearch || this.similarityMatcher.isSimilar(issueString, solution)) {
                    ++addedDescriptions;
                    this.createResolution(issue, issueResolutionAcceptor, issueString, referableElement);
                    proposedSolutions.add(solution);
                } else {
                    discardedDescriptions.add(referableElement);
                }
            }
            if (++checkedDescriptions > 100) break;
        }
        if (discardedDescriptions.size() + addedDescriptions <= 5) {
            for (IEObjectDescription referableElement : discardedDescriptions) {
                this.createResolution(issue, issueResolutionAcceptor, issueString, referableElement);
            }
        }
    }

    protected boolean isUseJavaSearch(EReference unresolvedReference, Issue issue) {
        if (this.isConstructorReference(unresolvedReference)) {
            return true;
        }
        return this.isTypeReference(unresolvedReference);
    }

    protected boolean isTypeReference(EReference unresolvedReference) {
        return TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(unresolvedReference.getEReferenceType());
    }

    protected boolean isConstructorReference(EReference unresolvedReference) {
        return TypesPackage.Literals.JVM_CONSTRUCTOR.isSuperTypeOf(unresolvedReference.getEReferenceType());
    }

    protected void createResolution(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, String issueString, IEObjectDescription solution) {
        String replacement = this.qualifiedNameConverter.toString(solution.getName());
        String replaceLabel = "Change to '" + replacement + "'";
        issueResolutionAcceptor.accept(issue, replaceLabel, replaceLabel, null, (IModification)new ReplaceModification(issue, replacement));
    }

    protected IJavaSearchScope getJavaSearchScope(EObject model) {
        if (model == null || model.eResource() == null || model.eResource().getResourceSet() == null) {
            return null;
        }
        IJavaProject javaProject = this.projectProvider.getJavaProject(model.eResource().getResourceSet());
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        return searchScope;
    }

    protected IScope getImportedTypesScope(EObject model, final String misspelled, final IScope actualScope, IJavaSearchScope scope) {
        if (scope == null) {
            return IScope.NULLSCOPE;
        }
        try {
            final Set visiblePackages = this.importsConfiguration.getImplicitlyImportedPackages((XtextResource)model.eResource());
            final HashSet importedTypes = Sets.newHashSet();
            final HashSet seen = Sets.newHashSet();
            XImportSection importSection = this.importsConfiguration.getImportSection((XtextResource)model.eResource());
            if (importSection != null) {
                this.parseImportSection(importSection, new IAcceptor<String>(){

                    public void accept(String t) {
                        visiblePackages.add(t);
                    }
                }, new IAcceptor<String>(){

                    public void accept(String t) {
                        importedTypes.add(t);
                    }
                });
            }
            SearchEngine searchEngine = new SearchEngine();
            final ArrayList validProposals = Lists.newArrayList();
            for (String importedType : importedTypes) {
                QualifiedName qualifiedName;
                Iterator iterator;
                if (validProposals.size() > 5 || !seen.add(importedType)) continue;
                int dot = importedType.lastIndexOf(46);
                if (dot != -1) {
                    importedType = importedType.substring(dot + 1);
                }
                if (!this.isSimilarTypeName(misspelled, importedType) || !(iterator = actualScope.getElements(qualifiedName = this.qualifiedNameConverter.toQualifiedName(importedType)).iterator()).hasNext()) continue;
                IEObjectDescription element = (IEObjectDescription)iterator.next();
                validProposals.add(new AliasedEObjectDescription(qualifiedName, element));
            }
            try {
                for (String visiblePackage : visiblePackages) {
                    if (validProposals.size() > 5) continue;
                    searchEngine.searchAllTypeNames(visiblePackage.toCharArray(), 0, null, 0, 0, scope, new TypeNameRequestor(){

                        public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                            QualifiedName qualifiedName;
                            Iterator iterator;
                            String fqNameAsString;
                            StringBuilder typeNameBuilder = new StringBuilder(simpleTypeName.length);
                            char[][] cArray = enclosingTypeNames;
                            int n = enclosingTypeNames.length;
                            int n2 = 0;
                            while (n2 < n) {
                                char[] enclosingType = cArray[n2];
                                typeNameBuilder.append(enclosingType);
                                typeNameBuilder.append('.');
                                ++n2;
                            }
                            typeNameBuilder.append(simpleTypeName);
                            String typeName = typeNameBuilder.toString();
                            if (JavaTypeQuickfixes.this.isSimilarTypeName(misspelled, typeName) && seen.add(fqNameAsString = JavaTypeQuickfixes.this.getQualifiedTypeName(packageName, enclosingTypeNames, simpleTypeName)) && (iterator = actualScope.getElements(qualifiedName = JavaTypeQuickfixes.this.qualifiedNameConverter.toQualifiedName(typeName)).iterator()).hasNext()) {
                                IEObjectDescription element = (IEObjectDescription)iterator.next();
                                validProposals.add(new AliasedEObjectDescription(qualifiedName, element));
                            }
                        }
                    }, 3, (IProgressMonitor)new NullProgressMonitor(){

                        public boolean isCanceled() {
                            return validProposals.size() > 5;
                        }
                    });
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
            return new SimpleScope((Iterable)validProposals);
        }
        catch (JavaModelException jme) {
            return IScope.NULLSCOPE;
        }
    }

    protected void parseImportSection(XImportSection importSection, IAcceptor<String> visiblePackages, IAcceptor<String> importedTypes) {
        for (XImportDeclaration importDeclaration : importSection.getImportDeclarations()) {
            if (importDeclaration.isStatic()) continue;
            if (importDeclaration.getImportedNamespace() != null) {
                String importedAsString = importDeclaration.getImportedNamespace();
                if (importDeclaration.isWildcard()) {
                    importedAsString = importedAsString.substring(0, importedAsString.length() - 2);
                    visiblePackages.accept((Object)importedAsString);
                    continue;
                }
                importedTypes.accept((Object)importedAsString);
                continue;
            }
            importedTypes.accept((Object)importDeclaration.getImportedTypeName());
        }
    }

    protected boolean isSimilarTypeName(String s0, String s1) {
        double levenshteinDistance = StringUtils.getLevenshteinDistance((String)s0, (String)s1);
        return levenshteinDistance <= 3.0;
    }

    protected String getQualifiedTypeName(char[] packageName, char[][] enclosingTypeNames, char[] simpleTypeName) {
        StringBuilder fqName = new StringBuilder(packageName.length + simpleTypeName.length + 1);
        if (packageName.length != 0) {
            fqName.append(packageName);
            fqName.append('.');
        }
        char[][] cArray = enclosingTypeNames;
        int n = enclosingTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            char[] enclosingType = cArray[n2];
            fqName.append(enclosingType);
            fqName.append('.');
            ++n2;
        }
        fqName.append(simpleTypeName);
        String fqNameAsString = fqName.toString();
        return fqNameAsString;
    }

    protected void createImportProposals(final JvmDeclaredType contextType, Issue issue, String typeName, IJavaSearchScope searchScope, IssueResolutionAcceptor acceptor) throws JavaModelException {
        if (contextType != null) {
            ContextualVisibilityHelper visibilityHelper = this.getVisibilityHelper(contextType);
            Pair<String, String> packageAndType = this.typeNameGuesser.guessPackageAndTypeName((EObject)contextType, typeName);
            String wantedPackageName = (String)packageAndType.getFirst();
            BasicSearchEngine searchEngine = new BasicSearchEngine();
            char[] wantedPackageChars = Strings.isEmpty((String)wantedPackageName) ? null : wantedPackageName.toCharArray();
            String wantedTypeName = (String)packageAndType.getSecond();
            searchEngine.searchAllTypeNames(wantedPackageChars, 0, wantedTypeName.toCharArray(), 0, 0, searchScope, new IRestrictedAccessTypeRequestor((IVisibilityHelper)visibilityHelper, acceptor, issue, wantedTypeName){
                private final /* synthetic */ IVisibilityHelper val$visibilityHelper;
                private final /* synthetic */ IssueResolutionAcceptor val$acceptor;
                private final /* synthetic */ Issue val$issue;
                private final /* synthetic */ String val$wantedTypeName;
                {
                    this.val$visibilityHelper = iVisibilityHelper;
                    this.val$acceptor = issueResolutionAcceptor;
                    this.val$issue = issue;
                    this.val$wantedTypeName = string;
                }

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                    JvmType importType;
                    final String qualifiedTypeName = JavaTypeQuickfixes.this.getQualifiedTypeName(packageName, enclosingTypeNames, simpleTypeName);
                    if ((access == null || access.getProblemId() != 0x1000133 && !access.ignoreIfBetter()) && (importType = JavaTypeQuickfixes.this.services.getTypeReferences().findDeclaredType(qualifiedTypeName, (Notifier)contextType)) instanceof JvmDeclaredType && this.val$visibilityHelper.isVisible((JvmMember)((JvmDeclaredType)importType))) {
                        StringBuilder label = new StringBuilder("Import '");
                        label.append(simpleTypeName);
                        label.append("' (");
                        label.append(packageName);
                        if (enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                            char[][] cArray = enclosingTypeNames;
                            int n = enclosingTypeNames.length;
                            int n2 = 0;
                            while (n2 < n) {
                                char[] enclosingTypeName = cArray[n2];
                                label.append(".");
                                label.append(enclosingTypeName);
                                ++n2;
                            }
                        }
                        label.append(")");
                        this.val$acceptor.accept(this.val$issue, label.toString(), label.toString(), "impc_obj.gif", new ISemanticModification(){

                            public void apply(EObject element, IModificationContext context) throws Exception {
                                ReplacingAppendable appendable = (ReplacingAppendable)JavaTypeQuickfixes.this.appendableFactory.create(context.getXtextDocument(), (XtextResource)element.eResource(), 0, 0);
                                appendable.append(JavaTypeQuickfixes.this.services.getTypeReferences().findDeclaredType(qualifiedTypeName, (Notifier)element));
                                appendable.insertNewImports();
                            }
                        }, JavaTypeQuickfixes.this.jdtTypeRelevance.getRelevance(qualifiedTypeName, this.val$wantedTypeName) + 100);
                    }
                }
            }, 3, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected ContextualVisibilityHelper getVisibilityHelper(JvmDeclaredType contextType) {
        ParameterizedTypeReference contextTypeRef = new ParameterizedTypeReference((ITypeReferenceOwner)new StandardTypeReferenceOwner(this.services, (EObject)contextType), (JvmType)contextType);
        ContextualVisibilityHelper visibilityHelper = new ContextualVisibilityHelper((LightweightTypeReference)contextTypeRef);
        return visibilityHelper;
    }

    protected boolean createConstructorProposals(final JvmDeclaredType contextType, Issue issue, String typeName, IJavaSearchScope searchScope, IssueResolutionAcceptor acceptor) throws JavaModelException {
        boolean[] result = new boolean[1];
        if (contextType != null) {
            ContextualVisibilityHelper visibilityHelper = this.getVisibilityHelper(contextType);
            Pair<String, String> packageAndType = this.typeNameGuesser.guessPackageAndTypeName((EObject)contextType, typeName);
            String wantedPackageName = (String)packageAndType.getFirst();
            String wantedTypeName = (String)packageAndType.getSecond();
            BasicSearchEngine searchEngine = new BasicSearchEngine();
            char[] wantedPackageChars = Strings.isEmpty((String)wantedPackageName) ? null : wantedPackageName.toCharArray();
            searchEngine.searchAllTypeNames(wantedPackageChars, 0, wantedTypeName.toCharArray(), 0, 0, searchScope, new IRestrictedAccessTypeRequestor((IVisibilityHelper)visibilityHelper, result, wantedPackageName, acceptor, issue, wantedTypeName){
                private final /* synthetic */ IVisibilityHelper val$visibilityHelper;
                private final /* synthetic */ boolean[] val$result;
                private final /* synthetic */ String val$wantedPackageName;
                private final /* synthetic */ IssueResolutionAcceptor val$acceptor;
                private final /* synthetic */ Issue val$issue;
                private final /* synthetic */ String val$wantedTypeName;
                {
                    this.val$visibilityHelper = iVisibilityHelper;
                    this.val$result = blArray;
                    this.val$wantedPackageName = string;
                    this.val$acceptor = issueResolutionAcceptor;
                    this.val$issue = issue;
                    this.val$wantedTypeName = string2;
                }

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                    JvmType importType;
                    final String qualifiedTypeName = JavaTypeQuickfixes.this.getQualifiedTypeName(packageName, enclosingTypeNames, simpleTypeName);
                    if ((access == null || access.getProblemId() != 0x1000133 && !access.ignoreIfBetter()) && (importType = JavaTypeQuickfixes.this.services.getTypeReferences().findDeclaredType(qualifiedTypeName, (Notifier)contextType)) instanceof JvmDeclaredType && this.val$visibilityHelper.isVisible((JvmMember)((JvmDeclaredType)importType))) {
                        this.val$result[0] = true;
                        StringBuilder label = new StringBuilder("Change to constructor call 'new ");
                        label.append(simpleTypeName);
                        label.append("()'");
                        if (!Strings.equal((String)this.val$wantedPackageName, (String)new String(packageName))) {
                            label.append(" (");
                            label.append(packageName);
                            if (enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                                char[][] cArray = enclosingTypeNames;
                                int n = enclosingTypeNames.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    char[] enclosingTypeName = cArray[n2];
                                    label.append(".");
                                    label.append(enclosingTypeName);
                                    ++n2;
                                }
                            }
                            label.append(")");
                        }
                        this.val$acceptor.accept(this.val$issue, label.toString(), label.toString(), "impc_obj.gif", new ISemanticModification(){

                            public void apply(EObject element, IModificationContext context) throws Exception {
                                IXtextDocument document = context.getXtextDocument();
                                DocumentRewriter rewriter = JavaTypeQuickfixes.this.rewriterFactory.create(document, (XtextResource)element.eResource());
                                int typeEndOffset = document.get().indexOf(val$wantedTypeName, val$issue.getOffset() + val$wantedPackageName.length()) + val$wantedTypeName.length();
                                DocumentRewriter.Section section = rewriter.newSection(val$issue.getOffset(), typeEndOffset - val$issue.getOffset());
                                section.append(JavaTypeQuickfixes.this.services.getTypeReferences().findDeclaredType(qualifiedTypeName, (Notifier)element));
                                section.append("()");
                                TextEdit textEdit = JavaTypeQuickfixes.this.replaceConverter.convertToTextEdit(rewriter.getChanges());
                                textEdit.apply((IDocument)document);
                            }
                        }, JavaTypeQuickfixes.this.jdtTypeRelevance.getRelevance(qualifiedTypeName, this.val$wantedTypeName) + 100);
                    }
                }
            }, 3, (IProgressMonitor)new NullProgressMonitor());
        }
        return result[0];
    }
}

