/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.compiler.OnTheFlyJavaCompiler;
import org.eclipse.xtext.xbase.file.ProjectConfig;
import org.eclipse.xtext.xbase.file.RuntimeWorkspaceConfigProvider;
import org.eclipse.xtext.xbase.file.WorkspaceConfig;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationTestHelper {
    private static final Logger log = Logger.getLogger(CompilationTestHelper.class);
    @Inject
    private OnTheFlyJavaCompiler javaCompiler;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private FileExtensionProvider extensionProvider;
    @Inject
    private Provider<InMemoryFileSystemAccess> fileSystemAccessProvider;
    @Inject
    private RuntimeWorkspaceConfigProvider configProvider;

    public void setJavaCompilerClassPath(Class<?> ... classes) {
        this.javaCompiler.clearClassPath();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            this.javaCompiler.addClassPathOfClass(clazz);
            ++n2;
        }
    }

    public void configureFreshWorkspace() {
        File tempDir = this.createFreshTempDir();
        WorkspaceConfig config = new WorkspaceConfig(tempDir.getAbsolutePath());
        ProjectConfig projectConfig = new ProjectConfig("myProject");
        projectConfig.addSourceFolderMapping("src", "xtend-gen");
        config.addProjectConfig(projectConfig);
        this.configProvider.setWorkspaceConfig(config);
    }

    protected File createFreshTempDir() {
        try {
            File tempDir = File.createTempFile("temp", Long.toString(System.nanoTime()));
            if (!tempDir.delete()) {
                throw new IllegalStateException("couldn't delete temp file.");
            }
            if (!tempDir.mkdir()) {
                throw new IllegalStateException("couldn't create temp dir.");
            }
            return tempDir;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void assertCompilesTo(CharSequence source, final CharSequence expected) throws IOException {
        final boolean[] called = new boolean[1];
        this.compile(source, new IAcceptor<Result>(){

            public void accept(Result r) {
                Assert.assertEquals((Object)expected.toString(), (Object)r.getSingleGeneratedCode());
                called[0] = true;
            }
        });
        Assert.assertTrue((String)("Nothing was generated but the expectation was :\n" + expected), (boolean)called[0]);
    }

    public void compile(CharSequence source, IAcceptor<Result> acceptor) throws IOException {
        String fileName = String.valueOf(this.getSourceFolderPath()) + "MyFile." + this.extensionProvider.getPrimaryFileExtension();
        this.compile(this.resourceSet(new Pair((Object)fileName, (Object)source)), acceptor);
    }

    protected String getSourceFolderPath() {
        ProjectConfig next;
        Map projects = this.configProvider.get().getProjects();
        if (!projects.isEmpty() && !(next = (ProjectConfig)projects.values().iterator().next()).getSourceFolderMappings().isEmpty()) {
            return String.valueOf(((Path)next.getSourceFolderMappings().keySet().iterator().next()).toString()) + "/";
        }
        return "/";
    }

    public void compile(final ResourceSet resourceSet, IAcceptor<Result> acceptor) {
        try {
            boolean hasErrors = false;
            ArrayList allErrors = Lists.newArrayList();
            ArrayList resourcesToCheck = Lists.newArrayList((Iterable)resourceSet.getResources());
            for (Resource resource : resourcesToCheck) {
                if (!(resource instanceof XtextResource)) continue;
                XtextResource xtextResource = (XtextResource)resource;
                if (!xtextResource.isLoaded()) {
                    xtextResource.load(resourceSet.getLoadOptions());
                }
                List issues = xtextResource.getResourceServiceProvider().getResourceValidator().validate((Resource)xtextResource, CheckMode.ALL, CancelIndicator.NullImpl);
                for (Issue issue : issues) {
                    if (issue.getSeverity() == Severity.ERROR) {
                        hasErrors = true;
                        log.error((Object)issue);
                        allErrors.add(issue);
                        continue;
                    }
                    log.info((Object)issue);
                }
            }
            if (hasErrors) {
                throw new IllegalStateException("One or more resources contained errors : " + Joiner.on((char)',').join((Iterable)allErrors));
            }
            final InMemoryFileSystemAccess access = (InMemoryFileSystemAccess)this.fileSystemAccessProvider.get();
            for (Resource resource : resourcesToCheck) {
                XtextResource xtextResource;
                IGenerator generator;
                if (!(resource instanceof XtextResource) || (generator = (IGenerator)(xtextResource = (XtextResource)resource).getResourceServiceProvider().get(IGenerator.class)) == null) continue;
                generator.doGenerate((Resource)xtextResource, (IFileSystemAccess)access);
            }
            acceptor.accept((Object)new Result(){
                private Map<String, Class<?>> compiledClasses;
                private Map<String, String> generatedCode;

                public Map<String, Class<?>> getCompiledClasses() {
                    if (this.compiledClasses == null) {
                        try {
                            this.compiledClasses = CompilationTestHelper.this.javaCompiler.compileToClasses(this.getGeneratedCode());
                        }
                        catch (IllegalArgumentException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                    return this.compiledClasses;
                }

                @Override
                public Map<String, String> getGeneratedCode() {
                    if (this.generatedCode == null) {
                        this.generatedCode = Maps.newHashMap();
                        for (Map.Entry e : access.getTextFiles().entrySet()) {
                            String name = ((String)e.getKey()).substring("DEFAULT_OUTPUT".length(), ((String)e.getKey()).length() - ".java".length());
                            this.generatedCode.put(name.replace('/', '.'), ((CharSequence)e.getValue()).toString());
                        }
                    }
                    return this.generatedCode;
                }

                @Override
                public String getGeneratedCode(String typeName) {
                    return this.getGeneratedCode().get(typeName);
                }

                @Override
                public String getSingleGeneratedCode() {
                    if (access.getTextFiles().size() == 1) {
                        return ((CharSequence)access.getTextFiles().values().iterator().next()).toString();
                    }
                    String separator = System.getProperty("line.separator");
                    if (separator == null) {
                        separator = "\n";
                    }
                    ArrayList files = Lists.newArrayList(access.getTextFiles().entrySet());
                    Collections.sort(files, new Comparator<Map.Entry<String, CharSequence>>(){

                        @Override
                        public int compare(Map.Entry<String, CharSequence> o1, Map.Entry<String, CharSequence> o2) {
                            return o1.getKey().compareTo(o2.getKey());
                        }
                    });
                    StringBuilder result = new StringBuilder("MULTIPLE FILES WERE GENERATED" + separator + separator);
                    int i = 1;
                    for (Map.Entry entry : files) {
                        result.append("File " + i + " : " + ((String)entry.getKey()).replace("DEFAULT_OUTPUT", "") + separator + separator);
                        result.append((CharSequence)entry.getValue()).append(separator);
                        ++i;
                    }
                    return result.toString();
                }

                @Override
                public ResourceSet getResourceSet() {
                    return resourceSet;
                }

                @Override
                public Class<?> getCompiledClass() {
                    return (Class)IterableExtensions.head(this.getCompiledClasses().values());
                }

                @Override
                public Class<?> getCompiledClass(String className) {
                    return this.getCompiledClasses().get(className);
                }

                @Override
                public Map<String, CharSequence> getAllGeneratedResources() {
                    return access.getTextFiles();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ResourceSet resourceSet(Pair<String, ? extends CharSequence> ... resources) throws IOException {
        XtextResourceSet result = (XtextResourceSet)this.resourceSetProvider.get();
        Pair<String, ? extends CharSequence>[] pairArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<String, ? extends CharSequence> entry = pairArray[n2];
            URI uri = URI.createURI((String)((String)entry.getKey()));
            Resource resource = result.createResource(uri);
            if (resource == null) {
                throw new IllegalStateException("Couldn't create resource for URI " + uri + ". Resource.Factory not registered?");
            }
            resource.load((InputStream)new StringInputStream(((Object)((CharSequence)entry.getValue())).toString()), Collections.emptyMap());
            ++n2;
        }
        return result;
    }

    public ResourceSet unLoadedResourceSet(Pair<String, ? extends CharSequence> ... resources) throws IOException {
        XtextResourceSet result = (XtextResourceSet)this.resourceSetProvider.get();
        final HashMap uri2Content = Maps.newHashMap();
        result.setURIConverter((URIConverter)new ExtensibleURIConverterImpl(){

            public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
                CharSequence charSequence = (CharSequence)uri2Content.get(uri);
                if (charSequence != null) {
                    return new StringInputStream(charSequence.toString());
                }
                return super.createInputStream(uri, options);
            }
        });
        Pair<String, ? extends CharSequence>[] pairArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<String, ? extends CharSequence> entry = pairArray[n2];
            URI uri = URI.createURI((String)((String)entry.getKey()));
            Resource resource = result.createResource(uri);
            if (resource == null) {
                throw new IllegalStateException("Couldn't create resource for URI " + uri + ". Resource.Factory not registered?");
            }
            uri2Content.put(uri, (CharSequence)entry.getValue());
            ++n2;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Result {
        public Map<String, String> getGeneratedCode();

        public String getGeneratedCode(String var1);

        public String getSingleGeneratedCode();

        public ResourceSet getResourceSet();

        public Class<?> getCompiledClass();

        public Class<?> getCompiledClass(String var1);

        public Map<String, CharSequence> getAllGeneratedResources();
    }
}

