/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.quickfix;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.codebuilder.ICodeBuilder;
import org.eclipse.xtend.ide.codebuilder.JavaConstructorBuilder;
import org.eclipse.xtend.ide.codebuilder.JavaFieldBuilder;
import org.eclipse.xtend.ide.codebuilder.JavaMethodBuilder;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.xtext.ui.JdtHyperlink;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.ui.contentassist.ReplacingAppendable;
import org.eclipse.xtext.xbase.ui.document.DocumentSourceAppender;

public class CodeBuilderQuickfix {
    @Inject
    private IURIEditorOpener editorOpener;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;

    public void addQuickfix(ICodeBuilder builder, String label, Issue issue, IssueResolutionAcceptor acceptor) {
        boolean _isValid = builder.isValid();
        if (_isValid) {
            IModification _switchResult = null;
            boolean _matched = false;
            if (!_matched && builder instanceof ICodeBuilder.Xtend) {
                IModification _xtendModification;
                _matched = true;
                _switchResult = _xtendModification = this.getXtendModification((ICodeBuilder.Xtend)builder);
            }
            if (!_matched && builder instanceof ICodeBuilder.Java) {
                IModification _javaModification;
                _matched = true;
                _switchResult = _javaModification = this.getJavaModification((ICodeBuilder.Java)builder);
            }
            IModification modification = _switchResult;
            String _preview = builder.getPreview();
            String _image = builder.getImage();
            acceptor.accept(issue, label, _preview, _image, modification);
        }
    }

    protected String getImage(ICodeBuilder builder) {
        JvmVisibility _visibility;
        String _switchResult = null;
        JvmVisibility _switchValue = _visibility = builder.getVisibility();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_switchValue, (Object)JvmVisibility.PRIVATE)) {
            _matched = true;
            _switchResult = "fix_private_obj.gif";
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)JvmVisibility.PUBLIC)) {
            _matched = true;
            _switchResult = "fix_public_obj.gif";
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)JvmVisibility.PROTECTED)) {
            _matched = true;
            _switchResult = "fix_protected_obj.gif";
        }
        if (!_matched) {
            _switchResult = "fix_default_obj.gif";
        }
        return _switchResult;
    }

    protected boolean isXtendSource(ICodeBuilder builder) {
        Object _ownerSource = builder.getOwnerSource();
        return _ownerSource instanceof XtendClass;
    }

    protected IModification getXtendModification(final ICodeBuilder.Xtend builder) {
        IModification _function = new IModification(){

            public void apply(IModificationContext it) throws Exception {
                XtendTypeDeclaration xtendClass = builder.getXtendType();
                URI _uRI = EcoreUtil.getURI((EObject)xtendClass);
                IEditorPart editor = CodeBuilderQuickfix.this.editorOpener.open(_uRI, false);
                if (!(editor instanceof XtextEditor)) {
                    return;
                }
                XtextEditor xtextEditor = (XtextEditor)editor;
                IXtextDocument document = xtextEditor.getDocument();
                int offset = builder.getInsertOffset();
                Resource _eResource = xtendClass.eResource();
                DocumentSourceAppender.Factory.OptionalParameters _optionalParameters = new DocumentSourceAppender.Factory.OptionalParameters();
                Procedures.Procedure1<DocumentSourceAppender.Factory.OptionalParameters> _function = new Procedures.Procedure1<DocumentSourceAppender.Factory.OptionalParameters>(){

                    public void apply(DocumentSourceAppender.Factory.OptionalParameters it) {
                        int _indentationLevel;
                        it.baseIndentationLevel = _indentationLevel = builder.getIndentationLevel();
                        it.ensureEmptyLinesAround = true;
                    }
                };
                DocumentSourceAppender.Factory.OptionalParameters _doubleArrow = (DocumentSourceAppender.Factory.OptionalParameters)ObjectExtensions.operator_doubleArrow((Object)_optionalParameters, (Procedures.Procedure1)_function);
                ReplacingAppendable appendable = (ReplacingAppendable)CodeBuilderQuickfix.this.appendableFactory.create(document, (XtextResource)_eResource, offset, 0, _doubleArrow);
                builder.build((ISourceAppender)appendable);
                appendable.commitChanges();
                int _length = appendable.length();
                xtextEditor.setHighlightRange(offset + 1, _length, true);
            }
        };
        return _function;
    }

    protected IModification getJavaModification(final ICodeBuilder.Java builder) {
        IModification _function = new IModification(){

            public void apply(IModificationContext it) throws Exception {
                IField element;
                boolean _notEquals;
                IMethod _createMethod;
                NullProgressMonitor _nullProgressMonitor;
                String _string;
                StringBuilderBasedAppendable _stringBuilderBasedAppendable;
                ImportManager _importManager;
                final IType type = builder.getIType();
                char _charAt = ".".charAt(0);
                ImportManager importManager = _importManager = new ImportManager(true, _charAt);
                StringBuilderBasedAppendable content = _stringBuilderBasedAppendable = new StringBuilderBasedAppendable(importManager);
                builder.build((ISourceAppender)content);
                List _imports = importManager.getImports();
                Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                    public void apply(String it) {
                        try {
                            ICompilationUnit _compilationUnit = type.getCompilationUnit();
                            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                            _compilationUnit.createImport(it, null, (IProgressMonitor)_nullProgressMonitor);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                IterableExtensions.forEach((Iterable)_imports, (Procedures.Procedure1)_function);
                IField _switchResult = null;
                boolean _matched = false;
                if (!_matched && builder instanceof JavaFieldBuilder) {
                    IField _createField;
                    _matched = true;
                    _string = content.toString();
                    _nullProgressMonitor = new NullProgressMonitor();
                    _switchResult = _createField = type.createField(_string, null, true, (IProgressMonitor)_nullProgressMonitor);
                }
                if (!_matched && builder instanceof JavaConstructorBuilder) {
                    _matched = true;
                    _string = content.toString();
                    _nullProgressMonitor = new NullProgressMonitor();
                    _createMethod = type.createMethod(_string, null, true, (IProgressMonitor)_nullProgressMonitor);
                    _switchResult = _createMethod;
                }
                if (!_matched && builder instanceof JavaMethodBuilder) {
                    _matched = true;
                    _string = content.toString();
                    _nullProgressMonitor = new NullProgressMonitor();
                    _createMethod = type.createMethod(_string, null, true, (IProgressMonitor)_nullProgressMonitor);
                    _switchResult = _createMethod;
                }
                if (!_matched) {
                    _switchResult = null;
                }
                boolean bl = _notEquals = !Objects.equal((Object)((IAnnotatable)(element = _switchResult)), null);
                if (_notEquals) {
                    JdtHyperlink _jdtHyperlink = new JdtHyperlink();
                    Procedures.Procedure1<JdtHyperlink> _function_1 = new Procedures.Procedure1<JdtHyperlink>(){

                        public void apply(JdtHyperlink it) {
                            it.setJavaElement((IJavaElement)((IMember)element));
                            it.open();
                        }
                    };
                    ObjectExtensions.operator_doubleArrow((Object)_jdtHyperlink, (Procedures.Procedure1)_function_1);
                }
            }
        };
        return _function;
    }
}

