/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.impl.Primitives;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.scoping.XbaseScopeProvider;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

public class NewFeatureNameUtil {
    @Inject
    private XbaseScopeProvider scopeProvider;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private org.eclipse.xtext.common.types.util.Primitives primitives;
    @Inject
    private IValueConverterService valueConverterService;
    private Set<String> allKeywords;
    private IScope featureCallScope;

    @Inject
    public NewFeatureNameUtil(IGrammarAccess grammarAccess) {
        this.allKeywords = GrammarUtil.getAllKeywords((Grammar)grammarAccess.getGrammar());
    }

    public void setFeatureScopeContext(XExpression siblingExpression) {
        XBlockExpression containerBlock = siblingExpression.eContainer() instanceof XBlockExpression ? (XBlockExpression)siblingExpression.eContainer() : null;
        this.featureCallScope = this.scopeProvider.createSimpleFeatureCallScope(siblingExpression.eContainer(), XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, siblingExpression.eResource(), true, containerBlock != null ? containerBlock.getExpressions().size() : 0);
    }

    public void checkNewFeatureName(String newFeatureName, boolean isLookupInScope, RefactoringStatus status) {
        if (Strings.isEmpty((String)newFeatureName)) {
            status.addFatalError("Choose a name");
            return;
        }
        try {
            Object value = this.valueConverterService.toValue(newFeatureName, "ValidID", null);
            this.valueConverterService.toString(value, "ValidID");
        }
        catch (ValueConverterException exc) {
            status.addFatalError(exc.getMessage());
        }
        if (Character.isUpperCase(newFeatureName.charAt(0))) {
            status.addError("Discouraged name '" + newFeatureName + "'. Name should start with a lowercase letter. ");
        }
        if (this.isKeyword(newFeatureName)) {
            status.addFatalError("'" + newFeatureName + "' is keyword.");
        }
        if (Primitives.forName((String)newFeatureName) != null) {
            status.addFatalError("'" + newFeatureName + "' is reserved.");
        }
        if (isLookupInScope && this.featureCallScope != null && this.isAlreadyDefined(newFeatureName)) {
            status.addError("The name '" + newFeatureName + "' is already defined in this scope.");
        }
    }

    protected boolean isKeyword(String newFeatureName) {
        return this.allKeywords.contains(newFeatureName);
    }

    protected boolean isAlreadyDefined(String newFetaureName) {
        Iterable elements = this.featureCallScope.getElements(QualifiedName.create((String)newFetaureName));
        return !Iterables.isEmpty((Iterable)elements);
    }

    public String getDefaultName(XExpression expression) {
        String defaultName;
        String currentName = defaultName = this.getFancyDefaultName(expression);
        int count = 0;
        while (this.isKeyword(currentName) || this.isAlreadyDefined(currentName)) {
            currentName = String.valueOf(defaultName) + ++count;
        }
        return currentName;
    }

    protected String getFancyDefaultName(XExpression expression) {
        if (expression instanceof XMemberFeatureCall || expression instanceof XFeatureCall) {
            String featureName = ((XAbstractFeatureCall)expression).getFeature().getSimpleName();
            if (featureName.startsWith("get")) {
                return this.toVariableName(featureName.substring(3));
            }
            return this.toVariableName(featureName);
        }
        if (expression instanceof XClosure) {
            return "function";
        }
        JvmTypeReference type = this.typeProvider.getType(expression);
        if (type != null) {
            if (this.primitives.isPrimitive(type)) {
                return type.getSimpleName().substring(0, 1);
            }
            return this.toVariableName(type.getSimpleName());
        }
        return "";
    }

    protected String toVariableName(String name) {
        if (name.toUpperCase().equals(name)) {
            StringBuilder camelCaseBuilder = new StringBuilder();
            boolean isFirst = true;
            String[] stringArray = name.toLowerCase().split("_");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fragment = stringArray[n2];
                camelCaseBuilder.append(isFirst ? fragment : StringExtensions.toFirstUpper((String)fragment));
                isFirst = false;
                ++n2;
            }
            return camelCaseBuilder.toString();
        }
        return StringExtensions.toFirstLower((String)name);
    }
}

