/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.tokens.SerializerScopeProviderBinding;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.util.ITextRegion;

public class RefactoringCrossReferenceSerializer {
    private static final Logger log = Logger.getLogger(RefactoringCrossReferenceSerializer.class);
    @Inject
    @SerializerScopeProviderBinding
    private IScopeProvider scopeProvider;
    @Inject
    private IValueConverterService valueConverter;
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public String getCrossRefText(EObject owner, CrossReference crossref, EObject target, RefTextEvaluator refTextEvaluator, ITextRegion linkTextRegion, StatusWrapper status) {
        try {
            EReference ref = GrammarUtil.getReference((CrossReference)crossref, (EClass)owner.eClass());
            IScope scope = this.scopeProvider.getScope(owner, ref);
            if (scope == null) {
                throw new IllegalStateException("Could not create scope for the given cross reference.");
            }
            String ruleName = this.linkingHelper.getRuleNameFrom((EObject)crossref);
            Iterable descriptionsForCrossRef = scope.getElements(target);
            String bestRefText = null;
            for (IEObjectDescription desc : descriptionsForCrossRef) {
                try {
                    String unconvertedRefText = this.qualifiedNameConverter.toString(desc.getName());
                    String convertedRefText = this.valueConverter.toString((Object)unconvertedRefText, ruleName);
                    if (!refTextEvaluator.isValid(desc) || bestRefText != null && !refTextEvaluator.isBetterThan(convertedRefText, bestRefText)) continue;
                    bestRefText = convertedRefText;
                }
                catch (ValueConverterException e) {
                    status.add(2, "Missconfigured language: New reference text has invalid syntax.", owner, linkTextRegion);
                }
            }
            if (bestRefText == null) {
                status.add(3, "Refactoring introduces a name conflict.", owner, linkTextRegion);
            }
            return bestRefText;
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            status.add(3, exc.getMessage(), owner, linkTextRegion);
            return null;
        }
    }

    public static interface RefTextEvaluator {
        public boolean isBetterThan(String var1, String var2);

        public boolean isValid(IEObjectDescription var1);
    }
}

