/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class JvmExceptions {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypeConformanceComputer conformanceComputer;

    public Iterable<JvmTypeReference> findUnhandledExceptions(EObject context, Iterable<JvmTypeReference> thrownExceptions, Collection<JvmTypeReference> declaredExceptions) {
        JvmTypeReference runtimeException = this.typeReferences.getTypeForName(RuntimeException.class, (Notifier)context, new JvmTypeReference[0]);
        ArrayList allowedExceptions = Lists.newArrayListWithCapacity((int)(declaredExceptions.size() + 1));
        allowedExceptions.add(runtimeException);
        allowedExceptions.addAll(declaredExceptions);
        ArrayList unhandledExceptions = null;
        block0: for (JvmTypeReference thrownException : thrownExceptions) {
            for (JvmTypeReference allowedException : allowedExceptions) {
                if (this.conformanceComputer.isConformant(allowedException, thrownException)) continue block0;
            }
            if (unhandledExceptions == null) {
                unhandledExceptions = Lists.newArrayList();
            }
            unhandledExceptions.add(thrownException);
        }
        return unhandledExceptions == null ? Collections.emptyList() : unhandledExceptions;
    }
}

