/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.builder;

import com.google.common.base.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.xtend.lib.Data;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Data
public class FilteringResourceDescriptions
implements IResourceDescriptions {
    private final IResourceDescriptions _delegate;
    private final IJavaProject _project;

    public IResourceDescriptions getDelegate() {
        return this._delegate;
    }

    public IJavaProject getProject() {
        return this._project;
    }

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        IResourceDescriptions _delegate = this.getDelegate();
        Iterable _allResourceDescriptions = _delegate.getAllResourceDescriptions();
        Functions.Function1<IResourceDescription, Boolean> _function = new Functions.Function1<IResourceDescription, Boolean>(){

            public Boolean apply(IResourceDescription it) {
                URI _uRI = it.getURI();
                boolean _isContainedUri = FilteringResourceDescriptions.this.isContainedUri(_uRI);
                return _isContainedUri;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_allResourceDescriptions, (Functions.Function1)_function);
        return _filter;
    }

    public IResourceDescription getResourceDescription(URI normalizedURI) {
        boolean _isContainedUri = this.isContainedUri(normalizedURI);
        if (_isContainedUri) {
            IResourceDescriptions _delegate = this.getDelegate();
            return _delegate.getResourceDescription(normalizedURI);
        }
        return null;
    }

    private boolean isContainedUri(URI uri) {
        boolean _or = false;
        boolean _equals = Objects.equal((Object)uri, null);
        if (_equals) {
            _or = true;
        } else {
            int _segmentCount = uri.segmentCount();
            boolean _lessThan = _segmentCount < 2;
            boolean bl = _or = _equals || _lessThan;
        }
        if (_or) {
            return false;
        }
        String _segment = uri.segment(1);
        IJavaProject _project = this.getProject();
        IProject _project_1 = _project.getProject();
        String _name = _project_1.getName();
        return Objects.equal((Object)_segment, (Object)_name);
    }

    public Iterable<IEObjectDescription> getExportedObjects() {
        IResourceDescriptions _delegate = this.getDelegate();
        Iterable _exportedObjects = _delegate.getExportedObjects();
        Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                URI _eObjectURI = it.getEObjectURI();
                boolean _isContainedUri = FilteringResourceDescriptions.this.isContainedUri(_eObjectURI);
                return _isContainedUri;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_exportedObjects, (Functions.Function1)_function);
        return _filter;
    }

    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        IResourceDescriptions _delegate = this.getDelegate();
        Iterable _exportedObjects = _delegate.getExportedObjects(type, name, ignoreCase);
        Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                URI _eObjectURI = it.getEObjectURI();
                boolean _isContainedUri = FilteringResourceDescriptions.this.isContainedUri(_eObjectURI);
                return _isContainedUri;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_exportedObjects, (Functions.Function1)_function);
        return _filter;
    }

    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        IResourceDescriptions _delegate = this.getDelegate();
        Iterable _exportedObjectsByObject = _delegate.getExportedObjectsByObject(object);
        Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                URI _eObjectURI = it.getEObjectURI();
                boolean _isContainedUri = FilteringResourceDescriptions.this.isContainedUri(_eObjectURI);
                return _isContainedUri;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_exportedObjectsByObject, (Functions.Function1)_function);
        return _filter;
    }

    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        IResourceDescriptions _delegate = this.getDelegate();
        Iterable _exportedObjectsByType = _delegate.getExportedObjectsByType(type);
        Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                URI _eObjectURI = it.getEObjectURI();
                boolean _isContainedUri = FilteringResourceDescriptions.this.isContainedUri(_eObjectURI);
                return _isContainedUri;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_exportedObjectsByType, (Functions.Function1)_function);
        return _filter;
    }

    public boolean isEmpty() {
        IResourceDescriptions _delegate = this.getDelegate();
        boolean _isEmpty = _delegate.isEmpty();
        return _isEmpty;
    }

    public FilteringResourceDescriptions(IResourceDescriptions delegate, IJavaProject project) {
        this._delegate = delegate;
        this._project = project;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._delegate == null ? 0 : this._delegate.hashCode());
        result = 31 * result + (this._project == null ? 0 : this._project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilteringResourceDescriptions other = (FilteringResourceDescriptions)obj;
        if (this._delegate == null ? other._delegate != null : !this._delegate.equals(other._delegate)) {
            return false;
        }
        return !(this._project == null ? other._project != null : !this._project.equals(other._project));
    }

    public String toString() {
        String result = new ToStringHelper().toString((Object)this);
        return result;
    }
}

