/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.resource.LinkingAssumptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseResource
extends DerivedStateAwareResource {
    @Inject
    private OnChangeEvictingCache onChangeEvictingCache;
    private ThreadLocal<AssumptionState> assumptionState = new ThreadLocal<AssumptionState>(){

        @Override
        protected AssumptionState initialValue() {
            return new AssumptionState();
        }
    };

    protected LinkingAssumptions.Tracker trackAssumptions() {
        return new AssumptionTracker(this.assumptionState.get());
    }

    protected <T> T assumeLinked(JvmIdentifiableElement proxy, JvmIdentifiableElement candidate, XAbstractFeatureCall featureCall, XExpression implicitReceiver, XExpression implicitFirstArgument, Provider<T> algorithm) {
        AssumptionState state = this.assumptionState.get();
        try {
            if (state.proxyToAssumption.put(proxy, candidate) != null) {
                throw new AssertionError((Object)"There is already another assumption about the given proxy. Please make sure that you don't use XAbstractFeatureCall#getFeature in the type inference or in your scoping implementation but AbstractTypeProvider#getFeature instead.\nYou may want to look out for invocations of XAbstractFeatureCall#getFeature in the stack trace to spot the misbehaving implementation.");
            }
            if (featureCall != null) {
                state.featureCallToReceiverAssumption.put(featureCall, implicitReceiver);
                state.featureCallToFirstArgumentAssumption.put(featureCall, implicitFirstArgument);
            }
            Object object = algorithm.get();
            return (T)object;
        }
        finally {
            state.proxyToAssumption.remove(proxy);
            state.featureCallToFirstArgumentAssumption.remove(featureCall);
            state.featureCallToReceiverAssumption.remove(featureCall);
        }
    }

    protected XExpression getImplicitReceiver(XAbstractFeatureCall featureCall) {
        AssumptionState state = this.assumptionState.get();
        XExpression result = state.featureCallToReceiverAssumption.get(featureCall);
        if (result == null) {
            if (state.featureCallToReceiverAssumption.containsKey(featureCall)) {
                state.assumptionTracker.markDependent();
                return null;
            }
            return featureCall.getImplicitReceiver();
        }
        state.assumptionTracker.markDependent();
        return result;
    }

    protected XExpression getImplicitFirstArgument(XAbstractFeatureCall featureCall) {
        AssumptionState state = this.assumptionState.get();
        XExpression result = state.featureCallToFirstArgumentAssumption.get(featureCall);
        if (result == null) {
            if (state.featureCallToFirstArgumentAssumption.containsKey(featureCall)) {
                state.assumptionTracker.markDependent();
                return null;
            }
            return featureCall.getImplicitFirstArgument();
        }
        state.assumptionTracker.markDependent();
        return result;
    }

    protected JvmIdentifiableElement getFeature(XAbstractFeatureCall featureCall, boolean resolve) {
        JvmIdentifiableElement potentialProxy = (JvmIdentifiableElement)featureCall.eGet((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, false);
        if (potentialProxy == null || !potentialProxy.eIsProxy()) {
            return potentialProxy;
        }
        AssumptionState state = this.assumptionState.get();
        JvmIdentifiableElement assumption = state.proxyToAssumption.get(potentialProxy);
        if (assumption != null) {
            state.assumptionTracker.markDependent();
            return assumption;
        }
        if (!resolve) {
            return potentialProxy;
        }
        JvmIdentifiableElement resolvedResult = this.trackResolution(potentialProxy, featureCall, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
        return resolvedResult;
    }

    protected JvmIdentifiableElement trackResolution(JvmIdentifiableElement proxy, XExpression owner, EReference reference) {
        return (JvmIdentifiableElement)owner.eGet((EStructuralFeature)reference);
    }

    protected JvmConstructor getConstructor(XConstructorCall featureCall, boolean resolve) {
        JvmConstructor potentialProxy = (JvmConstructor)featureCall.eGet((EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, false);
        if (potentialProxy == null || !potentialProxy.eIsProxy()) {
            return potentialProxy;
        }
        AssumptionState state = this.assumptionState.get();
        JvmConstructor assumption = (JvmConstructor)state.proxyToAssumption.get(potentialProxy);
        if (assumption != null) {
            state.assumptionTracker.markDependent();
            return assumption;
        }
        if (!resolve) {
            return potentialProxy;
        }
        return (JvmConstructor)this.trackResolution((JvmIdentifiableElement)potentialProxy, featureCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR);
    }

    public synchronized EObject getEObject(final String uriFragment) {
        return (EObject)this.onChangeEvictingCache.execWithoutCacheClear((Resource)this, (IUnitOfWork)new IUnitOfWork<EObject, XbaseResource>(){

            public EObject exec(XbaseResource state) throws Exception {
                return XbaseResource.super.getEObject(uriFragment);
            }
        });
    }

    protected boolean isUnresolveableProxyCacheable(Triple<EObject, EReference, INode> triple) {
        boolean result = TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(((EReference)triple.getSecond()).getEReferenceType());
        return result;
    }

    protected EObject handleCyclicResolution(Triple<EObject, EReference, INode> triple) throws AssertionError {
        return null;
    }

    protected static class AssumptionState {
        protected Map<JvmIdentifiableElement, JvmIdentifiableElement> proxyToAssumption = Maps.newHashMap();
        protected Map<XAbstractFeatureCall, XExpression> featureCallToReceiverAssumption = Maps.newHashMap();
        protected Map<XAbstractFeatureCall, XExpression> featureCallToFirstArgumentAssumption = Maps.newHashMap();
        protected AssumptionTracker assumptionTracker = new RootAssumptionTracker();

        protected AssumptionState() {
        }
    }

    protected static class AssumptionTracker
    implements LinkingAssumptions.Tracker {
        private boolean independent = true;
        private final AssumptionTracker delegate;
        private final AssumptionState host;

        protected AssumptionTracker(AssumptionState host) {
            this.host = host;
            if (host != null) {
                this.delegate = host.assumptionTracker;
                host.assumptionTracker = this;
            } else {
                this.delegate = null;
            }
        }

        public boolean isIndependentOfAssumptions() {
            return this.independent;
        }

        public void stopTracking() {
            if (this.host.assumptionTracker != this) {
                throw new IllegalStateException("Unexpected assumption tracker");
            }
            this.host.assumptionTracker = this.delegate;
        }

        protected void markDependent() {
            if (this.independent) {
                this.independent = false;
                if (this.delegate != null) {
                    this.delegate.markDependent();
                }
            }
        }

        public String toString() {
            return "AssumptionTracker [independent=" + this.independent + "]";
        }
    }

    protected static class RootAssumptionTracker
    extends AssumptionTracker {
        protected RootAssumptionTracker() {
            super(null);
        }

        public boolean isIndependentOfAssumptions() {
            return true;
        }

        public void stopTracking() {
            throw new UnsupportedOperationException();
        }

        protected void markDependent() {
        }

        public String toString() {
            return "RootAssumptionTracker";
        }
    }
}

