/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.resource;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Storage2UriMapperImpl
implements IStorage2UriMapper {
    private static final Logger log = Logger.getLogger(Storage2UriMapperImpl.class);
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
    @Inject
    private UriValidator uriValidator;

    public void setUriValidator(UriValidator uriValidator) {
        this.uriValidator = uriValidator;
    }

    @Override
    public Map<URI, IStorage> getAllEntries(IContainer container) {
        final LinkedHashMap result = Maps.newLinkedHashMap();
        try {
            container.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IFile storage;
                    URI uri;
                    if (resource instanceof IFile && (uri = Storage2UriMapperImpl.this.getUri((IStorage)(storage = (IFile)resource))) != null) {
                        result.put(uri, storage);
                    }
                    if (resource instanceof IFolder) {
                        return Storage2UriMapperImpl.this.isHandled((IFolder)resource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected boolean isHandled(IFolder folder) {
        return true;
    }

    @Override
    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        if (!uri.isPlatformResource()) {
            return Collections.emptySet();
        }
        IFile file = this.getWorkspaceRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        if (!file.isAccessible()) {
            return Collections.emptySet();
        }
        return Collections.singleton(Tuples.create((Object)file, (Object)file.getProject()));
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public final URI getUri(IStorage storage) {
        if (!this.uriValidator.isPossiblyManaged(storage)) {
            return null;
        }
        URI uri = this.internalGetUri(storage);
        if (uri != null && this.isValidUri(uri, storage)) {
            return uri;
        }
        return null;
    }

    protected URI internalGetUri(IStorage storage) {
        if (storage instanceof IFile) {
            return URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
        }
        return null;
    }

    public boolean isValidUri(URI uri, IStorage storage) {
        boolean valid = this.uriValidator.isValid(uri, storage);
        return valid;
    }

    @Deprecated
    public void resourceChanged(IResourceChangeEvent event) {
        log.warn((Object)"Storage2UriMapperImpl.resourceChanged(IResourceChangeEvent) is deperectaed and does nothing.");
    }
}

