/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.parameterized;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.junit4.IInjectorProvider;
import org.eclipse.xtext.junit4.IRegistryConfigurator;
import org.eclipse.xtext.junit4.InjectWith;
import org.eclipse.xtext.junit4.parameterized.IParameterProvider;
import org.eclipse.xtext.junit4.parameterized.InjectParameter;
import org.eclipse.xtext.junit4.parameterized.ResourceURICollector;
import org.eclipse.xtext.junit4.parameterized.ResourceURIs;
import org.eclipse.xtext.junit4.parameterized.TestExpectationValidator;
import org.eclipse.xtext.junit4.parameterized.Xpect;
import org.eclipse.xtext.junit4.parameterized.XpectCommaSeparatedValues;
import org.eclipse.xtext.junit4.parameterized.XpectLines;
import org.eclipse.xtext.junit4.parameterized.XpectString;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Exceptions;
import org.eclipse.xtext.util.ReflectionUtil;
import org.eclipse.xtext.util.Strings;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedXtextRunner
extends ParentRunner<ResourceRunner> {
    private static Map<Class<?>, IInjectorProvider> injectorProviderClassCache = Maps.newHashMap();
    protected List<ResourceRunner> children;
    protected Filter filter = null;
    protected Map<String, MethodWithExpectation> methods = Maps.newHashMap();

    public ParameterizedXtextRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected IInjectorProvider createInjectorProvider() {
        IInjectorProvider injectorProvider = null;
        InjectWith injectWith = this.getTestClass().getJavaClass().getAnnotation(InjectWith.class);
        if (injectWith != null) {
            try {
                injectorProvider = injectWith.value().newInstance();
            }
            catch (Exception e) {
                Exceptions.throwUncheckedException((Throwable)e);
            }
        }
        return injectorProvider;
    }

    protected Description describeChild(ResourceRunner child) {
        return child.getDescription();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        super.filter(filter);
        this.filter = filter;
    }

    protected MethodWithExpectation findTestMethod(String name) throws Throwable {
        MethodWithExpectation result = this.methods.get(name);
        if (result == null) {
            Method method = this.getTestClass().getJavaClass().getMethod(name, new Class[0]);
            if (method == null) {
                throw new RuntimeException("Method " + name + "() not found in " + this.getTestClass().getName());
            }
            result = new MethodWithExpectation(method);
            this.methods.put(name, result);
        }
        return result;
    }

    protected List<ResourceRunner> getChildren() {
        if (this.children == null) {
            this.children = Lists.newArrayList();
            IInjectorProvider injectorProvider = this.getOrCreateInjectorProvider();
            for (URI uri : this.getURIs()) {
                ResourceRunner child = (ResourceRunner)injectorProvider.getInjector().getInstance(ResourceRunner.class);
                child.init(this.getTestClass(), injectorProvider, uri);
                this.children.add(child);
            }
        }
        return this.children;
    }

    protected IInjectorProvider getInjectorProvider() {
        return injectorProviderClassCache.get(this.getTestClass().getJavaClass());
    }

    protected IInjectorProvider getOrCreateInjectorProvider() {
        IInjectorProvider injectorProvider = this.getInjectorProvider();
        if (injectorProvider == null) {
            injectorProvider = this.createInjectorProvider();
            injectorProviderClassCache.put(this.getTestClass().getJavaClass(), injectorProvider);
        }
        return injectorProvider;
    }

    protected List<URI> getURIs() {
        ResourceURIs classAnnotation = this.getTestClass().getJavaClass().getAnnotation(ResourceURIs.class);
        if (classAnnotation != null) {
            return this.getURIs(classAnnotation);
        }
        for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(ResourceURIs.class)) {
            int modifiers = method.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return this.getURIs(method);
        }
        throw new RuntimeException("The class " + this.getTestClass().getJavaClass() + " or one of its static public methods needs to be annotated with @" + ResourceURIs.class.getSimpleName());
    }

    protected List<URI> getURIs(FrameworkMethod method) {
        try {
            return (List)method.invokeExplosively(null, new Object[0]);
        }
        catch (Throwable e) {
            Exceptions.throwUncheckedException((Throwable)e);
            return Collections.emptyList();
        }
    }

    protected List<URI> getURIs(ResourceURIs uris) {
        ArrayList result = Lists.newArrayList();
        ResourceURICollector collector = new ResourceURICollector();
        if (uris.files().length > 0) {
            result.addAll(collector.collectFiles(uris.files()));
        }
        if (!Strings.isEmpty((String)uris.baseDir()) || uris.fileExtensions().length > 0) {
            Assert.assertFalse((String)"@ResourceURIs needs a baseURI", (boolean)Strings.isEmpty((String)uris.baseDir()));
            Assert.assertTrue((String)"@ResourceURIs needs at least one fileExtension", (uris.fileExtensions().length > 0 ? 1 : 0) != 0);
            result.addAll(collector.collectFiles(uris.baseDir(), uris.fileExtensions()));
        }
        return result;
    }

    protected Object newTestInstance() throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor constructor = this.getTestClass().getJavaClass().getConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    protected void injectParameters(Object test, Multimap<String, Object> params) {
        ArrayList fields = Lists.newArrayList();
        Class<?> clazz = test.getClass();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Lists.newArrayList((Object[])clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        for (Field field : fields) {
            InjectParameter annotation = field.getAnnotation(InjectParameter.class);
            if (annotation == null) continue;
            String name = Strings.isEmpty((String)annotation.value()) ? field.getName() : annotation.value();
            Class fieldType = ReflectionUtil.getObjectType(field.getType());
            for (Object value : params.get((Object)name)) {
                if (!fieldType.isInstance(value)) continue;
                field.setAccessible(true);
                try {
                    field.set(test, value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    protected void runChild(ParameterSetRunner ps) throws Throwable {
        MethodWithExpectation method = this.findTestMethod(ps.getMethdoName());
        Object test = this.newTestInstance();
        if (ps.getInjectorProvider() instanceof IRegistryConfigurator) {
            ((IRegistryConfigurator)((Object)ps.getInjectorProvider())).setupRegistry();
        }
        try {
            try {
                this.injectParameters(test, ps.getParams());
                ps.getInjectorProvider().getInjector().injectMembers(test);
                Object result = method.getMethod().invoke(test, new Object[0]);
                method.getValidator().validate(ps.getResource(), ps.getExpectation(), result);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        finally {
            if (ps.getInjectorProvider() instanceof IRegistryConfigurator) {
                ((IRegistryConfigurator)((Object)ps.getInjectorProvider())).restoreRegistry();
            }
        }
    }

    protected void runChild(ResourceRunner arg0, RunNotifier notifier) {
        for (ParameterSetRunner ps : arg0.getParameterSets()) {
            if (this.filter != null && !this.filter.shouldRun(ps.getDescription())) continue;
            notifier.fireTestStarted(ps.getDescription());
            if (ps.isIgnore()) {
                notifier.fireTestIgnored(ps.getDescription());
            } else {
                try {
                    this.runChild(ps);
                }
                catch (Throwable e) {
                    notifier.fireTestFailure(new Failure(ps.getDescription(), e));
                }
            }
            notifier.fireTestFinished(ps.getDescription());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodWithExpectation {
        protected Method method;
        protected TestExpectationValidator.ITestExpectationValidator<Object> validator;

        public MethodWithExpectation(Method method) throws Throwable {
            this.method = method;
            this.validator = this.findValidator();
        }

        protected TestExpectationValidator.ITestExpectationValidator<? extends Object> createValidator(Test annotation) {
            if (this.method.getReturnType() != Void.TYPE) {
                throw new RuntimeException("The method is expected to return void. Method: " + this.method);
            }
            return new TestExpectationValidator.NullTestResultValidator(annotation);
        }

        protected TestExpectationValidator.ITestExpectationValidator<? extends Object> createValidator(TestExpectationValidator trv, Annotation annotation) throws Throwable {
            boolean returnsExpected;
            Class<TestExpectationValidator.ITestExpectationValidator<?>> validatorClass = trv.validator();
            Class<?> expectedResultType = this.getExpectedResultType(validatorClass);
            boolean voidExpected = expectedResultType == Void.TYPE || expectedResultType == Void.class;
            boolean bl = returnsExpected = this.method.getReturnType() == Void.TYPE || this.method.getReturnType() == Void.class;
            if (!(expectedResultType.isAssignableFrom(this.method.getReturnType()) || voidExpected && returnsExpected)) {
                throw new RuntimeException("The return type of " + this.method + " is expected to be " + expectedResultType.getName());
            }
            Constructor<TestExpectationValidator.ITestExpectationValidator<?>> c = validatorClass.getConstructor(annotation.annotationType());
            return c.newInstance(annotation);
        }

        protected TestExpectationValidator.ITestExpectationValidator<Object> findValidator() throws Throwable {
            Annotation[] annotationArray = this.method.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation an = annotationArray[n2];
                if (an instanceof Test) {
                    return this.createValidator((Test)an);
                }
                TestExpectationValidator trv = an.annotationType().getAnnotation(TestExpectationValidator.class);
                if (trv != null) {
                    return this.createValidator(trv, an);
                }
                ++n2;
            }
            Class[] annotations = new Class[]{Test.class, Xpect.class, XpectString.class, XpectLines.class, XpectCommaSeparatedValues.class};
            ArrayList names = Lists.newArrayList();
            Class[] classArray = annotations;
            int n3 = annotations.length;
            int n4 = 0;
            while (n4 < n3) {
                Class o = classArray[n4];
                names.add("@" + o.getSimpleName());
                ++n4;
            }
            throw new RuntimeException("Annotation missing: " + Joiner.on((String)", ").join((Iterable)names) + ", etc. in: " + this.method);
        }

        protected Class<?> getExpectedResultType(Class<? extends TestExpectationValidator.ITestExpectationValidator<?>> clazz) {
            Method[] methodArray = clazz.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method meth = methodArray[n2];
                Annotation[][] annotations = meth.getParameterAnnotations();
                int i = 0;
                while (i < annotations.length) {
                    Annotation[] annotationArray = annotations[i];
                    int n3 = annotationArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Annotation an = annotationArray[n4];
                        if (an instanceof TestExpectationValidator.TestResult) {
                            return meth.getParameterTypes()[i];
                        }
                        ++n4;
                    }
                    ++i;
                }
                ++n2;
            }
            throw new RuntimeException("One of the method parameters of " + clazz.getName() + " must be annotated with @" + TestExpectationValidator.TestResult.class.getSimpleName());
        }

        public Method getMethod() {
            return this.method;
        }

        public TestExpectationValidator.ITestExpectationValidator<Object> getValidator() {
            return this.validator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ParameterSetRunner {
        protected Description description;
        protected IParameterProvider.IExpectation expectation;
        protected boolean ignore;
        protected int index = -1;
        protected String methodName;
        protected Multimap<String, Object> params;
        protected ResourceRunner runner;
        protected String title;

        protected ParameterSetRunner() {
        }

        public Description getDescription() {
            if (this.description == null) {
                this.description = Description.createTestDescription((Class)this.runner.clazz.getJavaClass(), (String)this.getFullTitle());
            }
            return this.description;
        }

        public IParameterProvider.IExpectation getExpectation() {
            return this.expectation;
        }

        public String getFullTitle() {
            StringBuilder result = new StringBuilder();
            result.append(this.methodName);
            if (!Strings.isEmpty((String)this.title)) {
                result.append(" ");
                result.append(this.title);
            }
            if (this.index > -1) {
                result.append("#");
                result.append(this.index);
            }
            result.append(" - ");
            result.append(this.runner.resource.getURI().lastSegment());
            return result.toString();
        }

        public IInjectorProvider getInjectorProvider() {
            return this.runner.injectorProvider;
        }

        public String getMethdoName() {
            return this.methodName;
        }

        public Multimap<String, Object> getParams() {
            return this.params;
        }

        public XtextResource getResource() {
            return this.runner.resource;
        }

        public Class<?> getTestClass() {
            return this.runner.clazz.getJavaClass();
        }

        public void init(ResourceRunner runner, String title, String method, Multimap<String, Object> params, IParameterProvider.IExpectation expectation, boolean ignore) {
            this.runner = runner;
            this.title = title;
            this.methodName = method;
            this.params = params;
            this.expectation = expectation;
            this.ignore = ignore;
        }

        public boolean isIgnore() {
            return this.ignore;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ResourceRunner
    implements IParameterProvider.IParameterAcceptor {
        protected TestClass clazz;
        protected Description description;
        protected IInjectorProvider injectorProvider;
        protected List<ParameterSetRunner> parameterSets = Lists.newArrayList();
        protected XtextResource resource;
        protected ResourceSet resourceSet;

        protected ResourceRunner() {
        }

        @Override
        public void acceptImportURI(URI uri) {
            this.resourceSet.getResource(uri, true);
        }

        @Override
        public void acceptTest(String title, String method, Multimap<String, Object> params, IParameterProvider.IExpectation expectation, boolean ignore) {
            ParameterSetRunner runner = (ParameterSetRunner)this.injectorProvider.getInjector().getInstance(ParameterSetRunner.class);
            runner.init(this, title, method, params, expectation, ignore);
            this.parameterSets.add(runner);
        }

        protected void collectParameters() {
            IParameterProvider parameterProvider = (IParameterProvider)this.injectorProvider.getInjector().getInstance(IParameterProvider.class);
            parameterProvider.collectParameters(this.clazz.getJavaClass(), this.resource, this);
        }

        public Description getDescription() {
            if (this.description == null) {
                this.description = Description.createSuiteDescription((String)this.resource.getURI().lastSegment(), (Annotation[])new Annotation[0]);
                for (ParameterSetRunner child : this.parameterSets) {
                    this.description.addChild(child.getDescription());
                }
            }
            return this.description;
        }

        public List<ParameterSetRunner> getParameterSets() {
            return this.parameterSets;
        }

        public void init(TestClass clazz, IInjectorProvider injector, URI uri) {
            this.clazz = clazz;
            this.injectorProvider = injector;
            this.resourceSet = (ResourceSet)this.injectorProvider.getInjector().getInstance(ResourceSet.class);
            this.resource = (XtextResource)this.resourceSet.getResource(uri, true);
            this.collectParameters();
            this.setIndex();
        }

        protected void setIndex() {
            HashSet visited = Sets.newHashSet();
            HashSet duplicate = Sets.newHashSet();
            for (ParameterSetRunner r : this.getParameterSets()) {
                if (visited.add(r.getFullTitle())) continue;
                duplicate.add(r.getFullTitle());
            }
            HashMap counter = Maps.newHashMap();
            for (ParameterSetRunner r : this.getParameterSets()) {
                if (!duplicate.contains(r.getFullTitle())) continue;
                String title = r.getFullTitle();
                Integer count = (Integer)counter.get(title);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                counter.put(title, count);
                r.index = count;
            }
        }
    }
}

