/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.jvmmodel;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDerivedStateComputer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.jvmmodel.JvmElementsProxifyingUnloader;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelCompleter;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelInferrerRegistry;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class JvmModelAssociator
implements IJvmModelAssociations,
IJvmModelAssociator,
ILogicalContainerProvider,
IDerivedStateComputer {
    private static final Logger LOG = Logger.getLogger(JvmModelAssociator.class);
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private JvmElementsProxifyingUnloader unloader;
    @Inject
    private IJvmModelInferrer inferrer;
    @Inject
    private JvmModelInferrerRegistry inferrerRegistry;
    @Inject
    private JvmModelCompleter completer;

    public void setCompleter(JvmModelCompleter completer) {
        this.completer = completer;
    }

    public void setInferrer(IJvmModelInferrer inferrer) {
        this.inferrer = inferrer;
    }

    protected Adapter getOrInstall(Resource resource) {
        if (!(resource instanceof XtextResource)) {
            return new Adapter();
        }
        if (!this.languageName.equals(((XtextResource)resource).getLanguageName())) {
            return new Adapter();
        }
        Adapter adapter = (Adapter)EcoreUtil.getAdapter((List)resource.eAdapters(), Adapter.class);
        if (adapter == null) {
            adapter = new Adapter();
            resource.eAdapters().add((Object)adapter);
        }
        return adapter;
    }

    protected Map<EObject, JvmIdentifiableElement> getLogicalContainerMapping(Resource resource) {
        return this.getOrInstall((Resource)resource).logicalContainerMap;
    }

    @Override
    public XExpression getAssociatedExpression(JvmIdentifiableElement element) {
        if (element == null) {
            return null;
        }
        Map<EObject, JvmIdentifiableElement> mapping = this.getLogicalContainerMapping(element.eResource());
        for (Map.Entry<EObject, JvmIdentifiableElement> entry : mapping.entrySet()) {
            if (entry.getValue() != element || !(entry.getKey() instanceof XExpression)) continue;
            return (XExpression)entry.getKey();
        }
        return null;
    }

    @Override
    public JvmIdentifiableElement getLogicalContainer(EObject object) {
        if (object == null) {
            return null;
        }
        Map<EObject, JvmIdentifiableElement> mapping = this.getLogicalContainerMapping(object.eResource());
        if (mapping.containsKey(object)) {
            return mapping.get(object);
        }
        if (object.eContainer() != null && !mapping.containsKey(object.eContainer())) {
            Set<EObject> elements = this.getJvmElements(object.eContainer());
            for (EObject eObject : elements) {
                if (!(eObject instanceof JvmIdentifiableElement)) continue;
                return (JvmIdentifiableElement)eObject;
            }
        }
        return null;
    }

    @Override
    public JvmIdentifiableElement getNearestLogicalContainer(EObject context) {
        if (context == null) {
            return null;
        }
        JvmIdentifiableElement locicalContainer = this.getLogicalContainer(context);
        if (locicalContainer != null) {
            return locicalContainer;
        }
        return this.getNearestLogicalContainer(context.eContainer());
    }

    @Override
    public void associateLogicalContainer(EObject logicalChild, JvmIdentifiableElement element) {
        if (logicalChild == null) {
            return;
        }
        Map<EObject, JvmIdentifiableElement> mapping = this.getLogicalContainerMapping(logicalChild.eResource());
        mapping.put(logicalChild, element);
    }

    @Override
    public void removeLogicalChildAssociation(JvmIdentifiableElement container) {
        if (container == null) {
            return;
        }
        Map<EObject, JvmIdentifiableElement> mapping = this.getLogicalContainerMapping(container.eResource());
        Iterator<Map.Entry<EObject, JvmIdentifiableElement>> iterator = mapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EObject, JvmIdentifiableElement> next = iterator.next();
            if (next.getValue() != container) continue;
            iterator.remove();
        }
    }

    protected Map<EObject, Set<EObject>> sourceToTargetMap(Resource res) {
        return this.getOrInstall((Resource)res).sourceToTargetMap;
    }

    protected Map<EObject, Set<EObject>> targetToSourceMap(Resource res) {
        return this.getOrInstall((Resource)res).targetToSourceMap;
    }

    protected Resource getResource(Notifier ctx) {
        Resource res = null;
        if (ctx instanceof EObject) {
            res = ((EObject)ctx).eResource();
        } else if (ctx instanceof Resource) {
            res = (Resource)ctx;
        }
        if (res == null) {
            throw new IllegalArgumentException("Argument must either be an EObject (cotained in a resource) or a resource. But was " + ctx);
        }
        return res;
    }

    @Override
    public void associate(EObject sourceElement, EObject jvmElement) {
        if (sourceElement != null) {
            Resource resource = sourceElement.eResource();
            Map<EObject, Set<EObject>> sourceToTargetMap = this.sourceToTargetMap(resource);
            JvmModelAssociator.putIntoSmallSetMap(sourceElement, jvmElement, sourceToTargetMap);
            Map<EObject, Set<EObject>> targetToSourceMap = this.targetToSourceMap(resource);
            JvmModelAssociator.putIntoSmallSetMap(jvmElement, sourceElement, targetToSourceMap);
        }
    }

    @Override
    public void associatePrimary(EObject sourceElement, EObject jvmElement) {
        if (sourceElement != null) {
            Resource resource = sourceElement.eResource();
            Map<EObject, Set<EObject>> sourceToTargetMap = this.sourceToTargetMap(resource);
            JvmModelAssociator.putIntoSmallSetMap(sourceElement, jvmElement, sourceToTargetMap, true);
            Map<EObject, Set<EObject>> targetToSourceMap = this.targetToSourceMap(resource);
            JvmModelAssociator.putIntoSmallSetMap(jvmElement, sourceElement, targetToSourceMap, true);
        }
    }

    public static <K, V> void putIntoSmallSetMap(K key, V value, Map<? super K, Set<V>> map) {
        Set<V> set = map.get(key);
        if (set == null) {
            set = new ListBasedSet<V>();
            map.put(key, set);
        }
        set.add(value);
    }

    public static <K, V> void putIntoSmallSetMap(K key, V value, Map<? super K, Set<V>> map, boolean head) {
        if (head) {
            Set<V> list = map.get(key);
            if (list == null) {
                list = new ListBasedSet<V>();
                map.put(key, list);
            }
            list.remove(value);
            ((ListBasedSet)list).elements.addFirst(value);
        } else {
            JvmModelAssociator.putIntoSmallSetMap(key, value, map);
        }
    }

    @Override
    public Set<EObject> getJvmElements(EObject sourceElement) {
        if (sourceElement == null) {
            return Collections.emptySet();
        }
        Map<EObject, Set<EObject>> map = this.sourceToTargetMap(sourceElement.eResource());
        Set<EObject> result = map.get(sourceElement);
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<EObject> getSourceElements(EObject jvmElement) {
        if (jvmElement == null) {
            return Collections.emptySet();
        }
        Map<EObject, Set<EObject>> map = this.targetToSourceMap(jvmElement.eResource());
        Set<EObject> result = map.get(jvmElement);
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public EObject getPrimarySourceElement(EObject jvmElement) {
        if (jvmElement == null) {
            return null;
        }
        Map<EObject, Set<EObject>> map = this.targetToSourceMap(jvmElement.eResource());
        Set<EObject> result = map.get(jvmElement);
        if (result != null) {
            return result.iterator().next();
        }
        return null;
    }

    public void installDerivedState(DerivedStateAwareResource resource, boolean preIndexingPhase) {
        if (resource.getContents().isEmpty()) {
            return;
        }
        EObject eObject = (EObject)resource.getContents().get(0);
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"primary JVM Model inference (JvmModelAssociator.installDerivedState)");
        task.start();
        JvmDeclaredTypeAcceptor acceptor = new JvmDeclaredTypeAcceptor(resource);
        this.inferrer.infer(eObject, acceptor, preIndexingPhase);
        if (!preIndexingPhase) {
            for (Pair<JvmDeclaredType, Procedures.Procedure1<? super JvmDeclaredType>> initializer : acceptor.later) {
                ((Procedures.Procedure1)initializer.getValue()).apply(initializer.getKey());
            }
        }
        task.stop();
        task = Stopwatches.forTask((String)"secondary (i.e. Macros) JVM Model inference (JvmModelAssociator.installDerivedState)");
        task.start();
        String fileExtension = resource.getURI().fileExtension();
        List<? extends IJvmModelInferrer> secondaryInferrers = this.inferrerRegistry.getModelInferrer(fileExtension);
        for (IJvmModelInferrer iJvmModelInferrer : secondaryInferrers) {
            acceptor = new JvmDeclaredTypeAcceptor(resource);
            try {
                iJvmModelInferrer.infer(eObject, acceptor, preIndexingPhase);
                if (preIndexingPhase) continue;
                for (Pair<JvmDeclaredType, Procedures.Procedure1<? super JvmDeclaredType>> initializer : acceptor.later) {
                    ((Procedures.Procedure1)initializer.getValue()).apply(initializer.getKey());
                }
            }
            catch (Exception e) {
                this.inferrerRegistry.deregister(fileExtension, iJvmModelInferrer);
                LOG.info((Object)("Removed errorneous model inferrer for *." + fileExtension + ". - " + iJvmModelInferrer), (Throwable)e);
            }
        }
        task.stop();
        if (!preIndexingPhase) {
            for (EObject eObject2 : resource.getContents()) {
                if (!(eObject2 instanceof JvmIdentifiableElement)) continue;
                JvmIdentifiableElement element = (JvmIdentifiableElement)eObject2;
                this.completer.complete(element);
            }
        }
    }

    public void discardDerivedState(DerivedStateAwareResource resource) {
        this.cleanAssociationState((Resource)resource);
    }

    public void cleanAssociationState(Resource resource) {
        ArrayList derived = Lists.newArrayList();
        EList resourcesContentsList = resource.getContents();
        int i = 1;
        while (i < resourcesContentsList.size()) {
            EObject eObject = (EObject)resourcesContentsList.get(i);
            this.unloader.unloadRoot(eObject);
            derived.add(eObject);
            ++i;
        }
        resourcesContentsList.removeAll((Collection)derived);
        this.sourceToTargetMap(resource).clear();
        this.targetToSourceMap(resource).clear();
        this.getLogicalContainerMapping(resource).clear();
    }

    protected static class Adapter
    extends AdapterImpl {
        public Map<EObject, Set<EObject>> sourceToTargetMap = Maps2.newLinkedHashMapWithExpectedSize(40);
        public Map<EObject, Set<EObject>> targetToSourceMap = Maps2.newLinkedHashMapWithExpectedSize(40);
        public Map<EObject, JvmIdentifiableElement> logicalContainerMap = Maps2.newLinkedHashMapWithExpectedSize(40);

        protected Adapter() {
        }

        public boolean isAdapterForType(Object type) {
            return Adapter.class == type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JvmDeclaredTypeAcceptor
    implements IJvmDeclaredTypeAcceptor,
    IJvmDeclaredTypeAcceptor.IPostIndexingInitializing<JvmDeclaredType> {
        public List<Pair<JvmDeclaredType, Procedures.Procedure1<? super JvmDeclaredType>>> later = Lists.newArrayList();
        private JvmDeclaredType lastAccepted = null;
        private DerivedStateAwareResource resource;

        public JvmDeclaredTypeAcceptor(DerivedStateAwareResource resource) {
            this.resource = resource;
        }

        @Override
        public <T extends JvmDeclaredType> IJvmDeclaredTypeAcceptor.IPostIndexingInitializing<T> accept(T type) {
            this.lastAccepted = type;
            if (type != null) {
                this.resource.getContents().add(type);
            }
            return this;
        }

        @Override
        public void initializeLater(Procedures.Procedure1<? super JvmDeclaredType> lateInitialization) {
            if (lateInitialization != null && this.lastAccepted != null) {
                this.later.add((Pair<JvmDeclaredType, Procedures.Procedure1<? super JvmDeclaredType>>)new Pair((Object)this.lastAccepted, lateInitialization));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ListBasedSet<E>
    extends AbstractSet<E> {
        private LinkedList<E> elements = Lists.newLinkedList();

        protected ListBasedSet() {
        }

        @Override
        public boolean add(E e) {
            if (this.elements.contains(e)) {
                return false;
            }
            return this.elements.add(e);
        }

        @Override
        public Iterator<E> iterator() {
            return this.elements.iterator();
        }

        @Override
        public int size() {
            return this.elements.size();
        }
    }
}

