/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.inject.Inject;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.xtext.ui.JdtTypesProposalProvider;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;
import org.eclipse.xtext.xtype.XImportDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportingTypesProposalProvider
extends JdtTypesProposalProvider {
    @Inject
    private RewritableImportSection.Factory importSectionFactory;
    @Inject
    private ReplaceConverter replaceConverter;

    protected ConfigurableCompletionProposal.IReplacementTextApplier createTextApplier(ContentAssistContext context, IScope typeScope, IQualifiedNameConverter qualifiedNameConverter, IValueConverter<String> valueConverter) {
        if (context.getCurrentModel() instanceof XImportDeclaration) {
            return super.createTextApplier(context, typeScope, qualifiedNameConverter, valueConverter);
        }
        return new FQNImporter((Resource)context.getResource(), context.getViewer(), typeScope, qualifiedNameConverter, valueConverter, this.importSectionFactory, this.replaceConverter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FQNImporter
    extends JdtTypesProposalProvider.FQNShortener {
        private static final Logger LOG = Logger.getLogger(FQNImporter.class);
        private final ITextViewer viewer;
        private RewritableImportSection.Factory importSectionFactory;
        private ReplaceConverter replaceConverter;

        public FQNImporter(Resource context, ITextViewer viewer, IScope scope, IQualifiedNameConverter qualifiedNameConverter, IValueConverter<String> valueConverter, RewritableImportSection.Factory importSectionFactory, ReplaceConverter replaceConverter) {
            super(context, scope, qualifiedNameConverter, valueConverter);
            this.viewer = viewer;
            this.importSectionFactory = importSectionFactory;
            this.replaceConverter = replaceConverter;
        }

        public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
            QualifiedName qualifiedName;
            String replacementString;
            String proposalReplacementString;
            String typeName = proposalReplacementString = proposal.getReplacementString();
            if (this.valueConverter != null) {
                typeName = (String)this.valueConverter.toValue(proposalReplacementString, null);
            }
            if (!proposalReplacementString.equals(replacementString = this.getActualReplacementString(proposal))) {
                QualifiedName shortQualifiedName;
                String shortTypeName = replacementString;
                if (this.valueConverter != null) {
                    shortTypeName = (String)this.valueConverter.toValue(replacementString, null);
                }
                if ((shortQualifiedName = this.qualifiedNameConverter.toQualifiedName(shortTypeName)).getSegmentCount() == 1) {
                    proposal.setCursorPosition(replacementString.length());
                    document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), replacementString);
                    return;
                }
            }
            if ((qualifiedName = this.qualifiedNameConverter.toQualifiedName(typeName)).getSegmentCount() == 1) {
                proposal.setCursorPosition(proposalReplacementString.length());
                document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), proposalReplacementString);
                return;
            }
            IEObjectDescription description = this.scope.getSingleElement(qualifiedName.skipFirst(qualifiedName.getSegmentCount() - 1));
            if (description != null) {
                proposal.setCursorPosition(proposalReplacementString.length());
                document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), proposalReplacementString);
                return;
            }
            String shortName = qualifiedName.getLastSegment();
            int topPixel = -1;
            StyledText widget = this.viewer.getTextWidget();
            if (widget != null) {
                topPixel = widget.getTopPixel();
            }
            ITextViewerExtension viewerExtension = null;
            if (this.viewer instanceof ITextViewerExtension) {
                viewerExtension = (ITextViewerExtension)this.viewer;
                viewerExtension.setRedraw(false);
            }
            RewritableImportSection importSection = this.importSectionFactory.parse((XtextResource)this.context);
            IEObjectDescription typeToImport = this.scope.getSingleElement(qualifiedName);
            if (typeToImport == null) {
                LOG.error((Object)("Could not find unique type named '" + Strings.notNull((Object)qualifiedName) + "' in scope"));
                if (viewerExtension != null) {
                    viewerExtension.setRedraw(true);
                }
                return;
            }
            EObject resolved = EcoreUtil.resolve((EObject)typeToImport.getEObjectOrProxy(), (Resource)this.context);
            Assert.isTrue((!resolved.eIsProxy() && resolved instanceof JvmDeclaredType ? 1 : 0) != 0);
            importSection.addImport((JvmDeclaredType)resolved);
            DocumentRewriteSession rewriteSession = null;
            try {
                if (document instanceof IDocumentExtension4) {
                    rewriteSession = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
                }
                String escapedShortname = shortName;
                if (this.valueConverter != null) {
                    escapedShortname = this.valueConverter.toString((Object)shortName);
                }
                proposal.setCursorPosition(escapedShortname.length());
                int initialCursorLine = document.getLineOfOffset(proposal.getReplacementOffset());
                document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), escapedShortname);
                List importChanges = importSection.rewrite();
                TextEdit textEdit = this.replaceConverter.convertToTextEdit(importChanges);
                textEdit.apply(document);
                int cursorPosition = proposal.getCursorPosition() + this.replaceConverter.getReplaceLengthDelta(importChanges);
                proposal.setCursorPosition(cursorPosition);
                int newCursorLine = document.getLineOfOffset(cursorPosition);
                if (widget != null) {
                    int additionalTopPixel = (newCursorLine - initialCursorLine) * widget.getLineHeight();
                    widget.setTopPixel(topPixel + additionalTopPixel);
                }
            }
            finally {
                if (rewriteSession != null) {
                    ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
                }
                if (viewerExtension != null) {
                    viewerExtension.setRedraw(true);
                }
            }
        }
    }
}

