/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.copyqualifiedname;

import com.google.inject.Inject;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.copyqualifiedname.AbstractCopyQualifiedNameHandler;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class EditorCopyQualifiedNameHandler
extends AbstractCopyQualifiedNameHandler {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;

    protected String getQualifiedName(ExecutionEvent event) {
        XtextEditor activeXtextEditor = EditorUtils.getActiveXtextEditor(event);
        if (activeXtextEditor == null) {
            return null;
        }
        final ITextSelection selection = this.getTextSelection(activeXtextEditor);
        return (String)activeXtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

            public String exec(XtextResource xTextResource) throws Exception {
                EObject selectedElement = EditorCopyQualifiedNameHandler.this.getSelectedName(selection, xTextResource);
                return EditorCopyQualifiedNameHandler.this.getQualifiedName(selectedElement);
            }
        });
    }

    private EObject getSelectedName(ITextSelection selection, XtextResource xTextResource) {
        return this.eObjectAtOffsetHelper.resolveElementAt(xTextResource, selection.getOffset());
    }

    private ITextSelection getTextSelection(XtextEditor activeXtextEditor) {
        return (ITextSelection)activeXtextEditor.getSelectionProvider().getSelection();
    }
}

