/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.scoping;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.scoping.featurecalls.AbstractStaticMethodsFeatureForTypeProvider;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendImport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticallyImportedFeaturesProvider
extends AbstractStaticMethodsFeatureForTypeProvider {
    protected Map<JvmTypeReference, Collection<String>> getVisibleTypesContainingStaticMethods(Iterable<JvmTypeReference> hierarchy) {
        boolean extension = this.isExtensionProvider();
        if (hierarchy == null || Iterables.isEmpty(hierarchy)) {
            extension = false;
        }
        List<XtendImport> imports = this.getImports();
        ArrayList result = Lists.newArrayList();
        for (XtendImport imported : imports) {
            String typeName;
            if (!imported.isStatic() || extension && !imported.isExtension() || !imported.isWildcard() || Strings.isEmpty((String)(typeName = imported.getImportedTypeName()))) continue;
            result.add(typeName);
        }
        if (result.isEmpty()) {
            return Collections.emptyMap();
        }
        if (!extension || hierarchy == null) {
            return Collections.singletonMap(null, result);
        }
        HashMap map = Maps.newHashMap();
        for (JvmTypeReference reference : hierarchy) {
            map.put(reference, result);
        }
        return map;
    }

    protected void collectFeatures(String name, Iterable<JvmTypeReference> hierarchy, Collection<JvmFeature> result) {
        Map staticTypeNames = this.getVisibleJvmTypesContainingStaticMethods(hierarchy);
        Iterator iterator = staticTypeNames.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            for (JvmTypeReference staticType : (Collection)e.getValue()) {
                List rawTypes = this.getRawTypeHelper().getAllRawTypes(staticType, this.context);
                for (JvmType rawType : rawTypes) {
                    if (!(rawType instanceof JvmDeclaredType)) continue;
                    Iterable features = name != null ? ((JvmDeclaredType)rawType).findAllFeaturesByName(name) : ((JvmDeclaredType)rawType).getAllFeatures();
                    block2: for (JvmFeature feature : features) {
                        if (feature instanceof JvmOperation) {
                            if (e.getKey() == null) {
                                if (!this.isMatchingExtension((JvmTypeReference)e.getKey(), (JvmOperation)feature)) continue;
                                result.add(feature);
                                continue;
                            }
                            for (JvmTypeReference key : hierarchy) {
                                if (!this.isMatchingExtension(key, (JvmOperation)feature)) continue;
                                result.add(feature);
                                continue block2;
                            }
                            continue;
                        }
                        if (!(feature instanceof JvmField)) continue;
                        result.add(feature);
                    }
                }
            }
            return;
        }
    }

    protected List<XtendImport> getImports() {
        Resource resource = this.getContext();
        if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof XtendFile)) {
            return Collections.emptyList();
        }
        XtendFile file = (XtendFile)resource.getContents().get(0);
        return file.getImports();
    }
}

