/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmShortAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.CompilationStrategyAdapter;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.BooleanExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerExtensions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmModelGenerator
implements IGenerator {
    @Inject
    private ILogicalContainerProvider _iLogicalContainerProvider;
    @Inject
    private TypeReferences _typeReferences;
    @Inject
    private XbaseCompiler compiler;
    @Inject
    private TypeReferenceSerializer typeRefSerializer;

    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        EList _contents = input.getContents();
        for (EObject obj : _contents) {
            this.internalDoGenerate(obj, fsa);
        }
    }

    protected void _internalDoGenerate(EObject obj, IFileSystemAccess fsa) {
    }

    protected void _internalDoGenerate(JvmGenericType type, IFileSystemAccess fsa) {
        String _qualifiedName = type.getQualifiedName();
        String _replace = _qualifiedName.replace(".", "/");
        String _operator_plus = StringExtensions.operator_plus((String)_replace, (Object)".java");
        CharSequence _generateType = this.generateType(type);
        fsa.generateFile(_operator_plus, _generateType);
    }

    public CharSequence generateType(JvmGenericType type) {
        CharSequence _generateBody;
        ImportManager _importManager;
        StringConcatenation _xblockexpression = null;
        ImportManager importManager = _importManager = new ImportManager(true, (JvmDeclaredType)type);
        CharSequence typeBody = _generateBody = this.generateBody(type, importManager);
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = type.getPackageName();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_packageName, null);
        if (_operator_notEquals) {
            _builder.append((Object)"package ");
            String _packageName_1 = type.getPackageName();
            _builder.append((Object)_packageName_1, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        List<String> _imports = importManager.getImports();
        boolean _hasElements = false;
        for (String i : _imports) {
            if (!_hasElements) {
                _hasElements = true;
            }
            _builder.append((Object)"import ");
            _builder.append((Object)i, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            _builder.append((Object)"\n", "");
        }
        _builder.append((Object)typeBody, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateBody(JvmGenericType it, final ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _generateJavaDoc = this.generateJavaDoc((EObject)it);
        _builder.append((Object)_generateJavaDoc, "");
        _builder.newLineIfNotEmpty();
        EList _annotations = it.getAnnotations();
        CharSequence _generateAnnotations = this.generateAnnotations((List<JvmAnnotationReference>)_annotations, importManager);
        _builder.append((Object)_generateAnnotations, "");
        _builder.newLineIfNotEmpty();
        CharSequence _generateModifier = this.generateModifier((JvmMember)it);
        _builder.append((Object)_generateModifier, "");
        boolean _isInterface = it.isInterface();
        if (_isInterface) {
            _builder.append((Object)"interface");
        } else {
            _builder.append((Object)"class");
        }
        _builder.append((Object)" ");
        String _simpleName = it.getSimpleName();
        _builder.append((Object)_simpleName, "");
        EList _typeParameters = it.getTypeParameters();
        CharSequence _generateTypeParameterDeclaration = this.generateTypeParameterDeclaration((List<JvmTypeParameter>)_typeParameters, importManager);
        _builder.append((Object)_generateTypeParameterDeclaration, "");
        _builder.append((Object)" ");
        String _generateExtendsClause = this.generateExtendsClause(it, importManager);
        _builder.append((Object)_generateExtendsClause, "");
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        EList _members = it.getMembers();
        Functions.Function1<JvmMember, CharSequence> _function = new Functions.Function1<JvmMember, CharSequence>(){

            public CharSequence apply(JvmMember m) {
                CharSequence _generateMember = JvmModelGenerator.this.generateMember(m, importManager);
                return _generateMember;
            }
        };
        List _map = ListExtensions.map((List)_members, (Functions.Function1)_function);
        Functions.Function1<CharSequence, Boolean> _function_1 = new Functions.Function1<CharSequence, Boolean>(){

            public Boolean apply(CharSequence c) {
                boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)c, null);
                return _operator_notEquals;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_map, (Functions.Function1)_function_1);
        boolean _hasElements = false;
        for (CharSequence memberCode : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "  ");
            }
            _builder.append((Object)"  ");
            _builder.append((Object)memberCode, "  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _generateModifier(JvmGenericType it) {
        boolean _isStatic;
        boolean _isFinal;
        StringConcatenation _builder = new StringConcatenation();
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        _builder.append((Object)_javaName, "");
        boolean _isAbstract = it.isAbstract();
        if (_isAbstract) {
            _builder.append((Object)"abstract ");
        }
        if (_isFinal = it.isFinal()) {
            _builder.append((Object)"final ");
        }
        if (_isStatic = it.isStatic()) {
            _builder.append((Object)"static ");
        }
        return _builder;
    }

    protected CharSequence _generateModifier(JvmField it) {
        boolean _isStatic;
        StringConcatenation _builder = new StringConcatenation();
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        _builder.append((Object)_javaName, "");
        boolean _isFinal = it.isFinal();
        if (_isFinal) {
            _builder.append((Object)"final ");
        }
        if (_isStatic = it.isStatic()) {
            _builder.append((Object)"static ");
        }
        return _builder;
    }

    protected CharSequence _generateModifier(JvmOperation it) {
        boolean _isStatic;
        boolean _isFinal;
        StringConcatenation _builder = new StringConcatenation();
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        _builder.append((Object)_javaName, "");
        boolean _isAbstract = it.isAbstract();
        if (_isAbstract) {
            _builder.append((Object)"abstract ");
        }
        if (_isFinal = it.isFinal()) {
            _builder.append((Object)"final ");
        }
        if (_isStatic = it.isStatic()) {
            _builder.append((Object)"static ");
        }
        return _builder;
    }

    protected CharSequence _generateModifier(JvmConstructor it) {
        StringConcatenation _builder = new StringConcatenation();
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        _builder.append((Object)_javaName, "");
        return _builder;
    }

    public String javaName(JvmVisibility visibility) {
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)visibility, null);
        if (_operator_notEquals) {
            String _switchResult = null;
            boolean matched = false;
            if (!matched && ObjectExtensions.operator_equals((Object)visibility, (Object)JvmVisibility.PRIVATE)) {
                matched = true;
                _switchResult = "private ";
            }
            if (!matched && ObjectExtensions.operator_equals((Object)visibility, (Object)JvmVisibility.PUBLIC)) {
                matched = true;
                _switchResult = "public ";
            }
            if (!matched && ObjectExtensions.operator_equals((Object)visibility, (Object)JvmVisibility.PROTECTED)) {
                matched = true;
                _switchResult = "protected ";
            }
            if (!matched && ObjectExtensions.operator_equals((Object)visibility, (Object)JvmVisibility.DEFAULT)) {
                matched = true;
                _switchResult = "";
            }
            return _switchResult;
        }
        return "";
    }

    public String generateExtendsClause(JvmGenericType it, final ImportManager importManager) {
        String _operator_plus_1;
        String _xblockexpression = null;
        EList _superTypes = it.getSuperTypes();
        boolean _isEmpty = _superTypes.isEmpty();
        if (_isEmpty) {
            return null;
        }
        String _xifexpression = null;
        boolean _isInterface = it.isInterface();
        if (!_isInterface) {
            boolean _isEmpty_1;
            boolean _operator_not;
            Iterable _filter_2;
            JvmTypeReference _head;
            Iterable _filter;
            EList _superTypes_2 = it.getSuperTypes();
            Functions.Function1<JvmTypeReference, Boolean> _function_1 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    String _identifier = typeRef.getIdentifier();
                    boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_identifier, (Object)"java.lang.Object");
                    return _operator_notEquals;
                }
            };
            Iterable withoutObject = _filter = IterableExtensions.filter((Iterable)_superTypes_2, (Functions.Function1)_function_1);
            Functions.Function1<JvmTypeReference, Boolean> _function_2 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    boolean _operator_and = false;
                    JvmType _type = typeRef.getType();
                    if (!(_type instanceof JvmGenericType)) {
                        _operator_and = false;
                    } else {
                        JvmType _type_1 = typeRef.getType();
                        boolean _isInterface = ((JvmGenericType)_type_1).isInterface();
                        boolean _operator_not = BooleanExtensions.operator_not((boolean)_isInterface);
                        _operator_and = BooleanExtensions.operator_and((boolean)(_type instanceof JvmGenericType), (boolean)_operator_not);
                    }
                    return _operator_and;
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)withoutObject, (Functions.Function1)_function_2);
            final JvmTypeReference superClazz = _head = (JvmTypeReference)IterableExtensions.head((Iterable)_filter_1);
            Functions.Function1<JvmTypeReference, Boolean> _function_3 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)typeRef, (Object)superClazz);
                    return _operator_notEquals;
                }
            };
            Iterable superInterfaces = _filter_2 = IterableExtensions.filter((Iterable)withoutObject, (Functions.Function1)_function_3);
            String result = "";
            boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)superClazz, null);
            if (_operator_notEquals) {
                String _operator_plus_3;
                String _serialize = this.serialize(superClazz, importManager);
                String _operator_plus_2 = StringExtensions.operator_plus((String)"extends ", (Object)_serialize);
                result = _operator_plus_3 = StringExtensions.operator_plus((String)_operator_plus_2, (Object)" ");
            }
            if (_operator_not = BooleanExtensions.operator_not((boolean)(_isEmpty_1 = IterableExtensions.isEmpty((Iterable)superInterfaces)))) {
                String _operator_plus_6;
                String _operator_plus_4 = StringExtensions.operator_plus((String)result, (Object)"implements ");
                Functions.Function1<JvmTypeReference, String> _function_4 = new Functions.Function1<JvmTypeReference, String>(){

                    public String apply(JvmTypeReference t) {
                        String _serialize = JvmModelGenerator.this.serialize(t, importManager);
                        return _serialize;
                    }
                };
                Iterable _map_1 = IterableExtensions.map((Iterable)superInterfaces, (Functions.Function1)_function_4);
                String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)", ");
                String _operator_plus_5 = StringExtensions.operator_plus((String)_operator_plus_4, (Object)_join_1);
                result = _operator_plus_6 = StringExtensions.operator_plus((String)_operator_plus_5, (Object)" ");
            }
            return result;
        }
        EList _superTypes_1 = it.getSuperTypes();
        Functions.Function1<JvmTypeReference, String> _function = new Functions.Function1<JvmTypeReference, String>(){

            public String apply(JvmTypeReference t) {
                String _serialize = JvmModelGenerator.this.serialize(t, importManager);
                return _serialize;
            }
        };
        List _map = ListExtensions.map((List)_superTypes_1, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
        String _operator_plus = StringExtensions.operator_plus((String)"extends ", (Object)_join);
        _xifexpression = _operator_plus_1 = StringExtensions.operator_plus((String)_operator_plus, (Object)" ");
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected CharSequence _generateMember(JvmMember it, ImportManager importManager) {
        String _operator_plus = StringExtensions.operator_plus((String)"generateMember not implemented for elements of type ", (Object)it);
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException(_operator_plus);
        throw _unsupportedOperationException;
    }

    protected CharSequence _generateMember(JvmField it, ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _generateJavaDoc = this.generateJavaDoc((EObject)it);
        _builder.append((Object)_generateJavaDoc, "");
        _builder.newLineIfNotEmpty();
        EList _annotations = it.getAnnotations();
        boolean _isEmpty = _annotations.isEmpty();
        boolean _operator_not = BooleanExtensions.operator_not((boolean)_isEmpty);
        if (_operator_not) {
            EList _annotations_1 = it.getAnnotations();
            CharSequence _generateAnnotations = this.generateAnnotations((List<JvmAnnotationReference>)_annotations_1, importManager);
            _builder.append((Object)_generateAnnotations, "");
        }
        _builder.newLineIfNotEmpty();
        CharSequence _generateModifier = this.generateModifier((JvmMember)it);
        _builder.append((Object)_generateModifier, "");
        JvmTypeReference _type = it.getType();
        String _serialize = this.serialize(_type, importManager);
        _builder.append((Object)_serialize, "");
        _builder.append((Object)" ");
        String _simpleName = it.getSimpleName();
        _builder.append((Object)_simpleName, "");
        CharSequence _generateInitialization = this.generateInitialization(it, importManager);
        _builder.append((Object)_generateInitialization, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateMember(JvmOperation it, final ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _generateJavaDoc = this.generateJavaDoc((EObject)it);
        _builder.append((Object)_generateJavaDoc, "");
        _builder.newLineIfNotEmpty();
        EList _annotations = it.getAnnotations();
        boolean _isEmpty = _annotations.isEmpty();
        boolean _operator_not = BooleanExtensions.operator_not((boolean)_isEmpty);
        if (_operator_not) {
            EList _annotations_1 = it.getAnnotations();
            CharSequence _generateAnnotations = this.generateAnnotations((List<JvmAnnotationReference>)_annotations_1, importManager);
            _builder.append((Object)_generateAnnotations, "");
        }
        _builder.newLineIfNotEmpty();
        CharSequence _generateModifier = this.generateModifier((JvmMember)it);
        _builder.append((Object)_generateModifier, "");
        EList _typeParameters = it.getTypeParameters();
        CharSequence _generateTypeParameterDeclaration = this.generateTypeParameterDeclaration((List<JvmTypeParameter>)_typeParameters, importManager);
        _builder.append((Object)_generateTypeParameterDeclaration, "");
        String _xifexpression = null;
        JvmTypeReference _returnType = it.getReturnType();
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)_returnType, null);
        if (_operator_equals) {
            _xifexpression = "void";
        } else {
            String _serialize;
            JvmTypeReference _returnType_1 = it.getReturnType();
            _xifexpression = _serialize = this.serialize(_returnType_1, importManager);
        }
        _builder.append((Object)_xifexpression, "");
        _builder.append((Object)" ");
        String _simpleName = it.getSimpleName();
        _builder.append((Object)_simpleName, "");
        _builder.append((Object)"(");
        EList _parameters = it.getParameters();
        Functions.Function1<JvmFormalParameter, String> _function = new Functions.Function1<JvmFormalParameter, String>(){

            public String apply(JvmFormalParameter p) {
                String _generateParameter = JvmModelGenerator.this.generateParameter(p, importManager);
                return _generateParameter;
            }
        };
        List _map = ListExtensions.map((List)_parameters, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
        _builder.append((Object)_join, "");
        _builder.append((Object)")");
        CharSequence _generateThrowsClause = this.generateThrowsClause((JvmExecutable)it, importManager);
        _builder.append((Object)_generateThrowsClause, "");
        boolean _isAbstract = it.isAbstract();
        if (_isAbstract) {
            _builder.append((Object)";");
        } else {
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"  ");
            CharSequence _generateBody = this.generateBody((JvmExecutable)it, importManager);
            _builder.append((Object)_generateBody, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _generateMember(JvmConstructor it, final ImportManager importManager) {
        StringConcatenation _xifexpression = null;
        boolean _operator_or = false;
        EList _parameters = it.getParameters();
        boolean _isEmpty = _parameters.isEmpty();
        boolean _operator_not = BooleanExtensions.operator_not((boolean)_isEmpty);
        if (_operator_not) {
            _operator_or = true;
        } else {
            XExpression _associatedExpression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it);
            boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_associatedExpression, null);
            _operator_or = BooleanExtensions.operator_or((boolean)_operator_not, (boolean)_operator_notEquals);
        }
        if (_operator_or) {
            StringConcatenation _builder = new StringConcatenation();
            StringConcatenation _generateJavaDoc = this.generateJavaDoc((EObject)it);
            _builder.append((Object)_generateJavaDoc, "");
            _builder.newLineIfNotEmpty();
            EList _annotations = it.getAnnotations();
            boolean _isEmpty_1 = _annotations.isEmpty();
            boolean _operator_not_1 = BooleanExtensions.operator_not((boolean)_isEmpty_1);
            if (_operator_not_1) {
                EList _annotations_1 = it.getAnnotations();
                CharSequence _generateAnnotations = this.generateAnnotations((List<JvmAnnotationReference>)_annotations_1, importManager);
                _builder.append((Object)_generateAnnotations, "");
            }
            _builder.newLineIfNotEmpty();
            CharSequence _generateModifier = this.generateModifier((JvmMember)it);
            _builder.append((Object)_generateModifier, "");
            String _simpleName = it.getSimpleName();
            _builder.append((Object)_simpleName, "");
            _builder.append((Object)"(");
            EList _parameters_1 = it.getParameters();
            Functions.Function1<JvmFormalParameter, String> _function = new Functions.Function1<JvmFormalParameter, String>(){

                public String apply(JvmFormalParameter p) {
                    String _generateParameter = JvmModelGenerator.this.generateParameter(p, importManager);
                    return _generateParameter;
                }
            };
            List _map = ListExtensions.map((List)_parameters_1, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
            _builder.append((Object)_join, "");
            _builder.append((Object)")");
            CharSequence _generateThrowsClause = this.generateThrowsClause((JvmExecutable)it, importManager);
            _builder.append((Object)_generateThrowsClause, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"  ");
            CharSequence _generateBody = this.generateBody((JvmExecutable)it, importManager);
            _builder.append((Object)_generateBody, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _xifexpression = _builder;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public CharSequence generateInitialization(JvmField it, ImportManager importManager) {
        CompilationStrategyAdapter _head;
        String _xblockexpression = null;
        EList _eAdapters = it.eAdapters();
        Iterable _filter = IterableExtensions.filter((Iterable)_eAdapters, CompilationStrategyAdapter.class);
        CompilationStrategyAdapter adapter = _head = (CompilationStrategyAdapter)((Object)IterableExtensions.head((Iterable)_filter));
        String _xifexpression = null;
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)((Object)adapter), null);
        if (_operator_notEquals) {
            String _operator_plus;
            Functions.Function1<ImportManager, ? extends CharSequence> _compilationStrategy = adapter.getCompilationStrategy();
            CharSequence _apply = (CharSequence)_compilationStrategy.apply((Object)importManager);
            _xifexpression = _operator_plus = StringExtensions.operator_plus((String)" = ", (Object)_apply);
        } else {
            XExpression _associatedExpression;
            String _xblockexpression_1 = null;
            XExpression expression = _associatedExpression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it);
            String _xifexpression_1 = null;
            boolean _operator_notEquals_1 = ObjectExtensions.operator_notEquals((Object)expression, null);
            if (_operator_notEquals_1) {
                StringBuilderBasedAppendable _createAppendable;
                StringBuilderBasedAppendable appendable = _createAppendable = this.createAppendable((EObject)it, importManager);
                JvmTypeReference _type = it.getType();
                this.compiler.compileAsJavaExpression(expression, appendable, _type);
                String _string = appendable.toString();
                String _operator_plus_1 = StringExtensions.operator_plus((String)" = ", (Object)_string);
                return _operator_plus_1;
            }
            _xifexpression = _xblockexpression_1 = (_xifexpression_1 = "");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public CharSequence generateTypeParameterDeclaration(List<JvmTypeParameter> typeParameters, ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasElements = false;
        for (JvmTypeParameter it : typeParameters) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append((Object)"<", "");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateTypeParameterDeclaration = this.generateTypeParameterDeclaration(it, importManager);
            _builder.append((Object)_generateTypeParameterDeclaration, "");
        }
        if (_hasElements) {
            _builder.append((Object)"> ", "");
        }
        return _builder;
    }

    public CharSequence generateTypeParameterDeclaration(JvmTypeParameter it, ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _serialize = importManager.serialize((JvmType)it);
        _builder.append((Object)_serialize, "");
        CharSequence _generateTypeParameterConstraints = this.generateTypeParameterConstraints(it, importManager);
        _builder.append((Object)_generateTypeParameterConstraints, "");
        return _builder;
    }

    public CharSequence generateTypeParameterConstraints(JvmTypeParameter it, ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        EList _constraints = it.getConstraints();
        Iterable _filter = IterableExtensions.filter((Iterable)_constraints, JvmUpperBound.class);
        boolean _hasElements = false;
        for (JvmUpperBound it_1 : _filter) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append((Object)" extends ", "");
            } else {
                _builder.appendImmediate((Object)" & ", "");
            }
            JvmTypeReference _typeReference = it_1.getTypeReference();
            String _serialize = this.serialize(_typeReference, importManager);
            _builder.append((Object)_serialize, "");
        }
        return _builder;
    }

    public CharSequence generateThrowsClause(JvmExecutable it, ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        EList _exceptions = it.getExceptions();
        boolean _hasElements = false;
        for (JvmTypeReference exc : _exceptions) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append((Object)" throws ", "");
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _serialize = this.serialize(exc, importManager);
            _builder.append((Object)_serialize, "");
        }
        return _builder;
    }

    public String generateParameter(JvmFormalParameter it, ImportManager importManager) {
        JvmTypeReference _parameterType = it.getParameterType();
        String _serialize = this.serialize(_parameterType, importManager);
        String _operator_plus = StringExtensions.operator_plus((String)"final ", (Object)_serialize);
        String _operator_plus_1 = StringExtensions.operator_plus((String)_operator_plus, (Object)" ");
        String _simpleName = it.getSimpleName();
        String _operator_plus_2 = StringExtensions.operator_plus((String)_operator_plus_1, (Object)_simpleName);
        return _operator_plus_2;
    }

    public CharSequence generateBody(JvmExecutable op, ImportManager importManager) {
        EList _eAdapters = op.eAdapters();
        Iterable _filter = IterableExtensions.filter((Iterable)_eAdapters, CompilationStrategyAdapter.class);
        CompilationStrategyAdapter _head = (CompilationStrategyAdapter)((Object)IterableExtensions.head((Iterable)_filter));
        CompilationStrategyAdapter adapter = _head;
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)((Object)adapter), null);
        if (_operator_notEquals) {
            Functions.Function1<ImportManager, ? extends CharSequence> _compilationStrategy = adapter.getCompilationStrategy();
            CharSequence _apply = (CharSequence)_compilationStrategy.apply((Object)importManager);
            return _apply;
        }
        XExpression _associatedExpression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)op);
        XExpression expression = _associatedExpression;
        boolean _operator_notEquals_1 = ObjectExtensions.operator_notEquals((Object)expression, null);
        if (_operator_notEquals_1) {
            StringBuilderBasedAppendable _createAppendable;
            StringBuilderBasedAppendable appendable = _createAppendable = this.createAppendable((EObject)op, importManager);
            EList _parameters = op.getParameters();
            for (JvmFormalParameter p : _parameters) {
                String _simpleName = p.getSimpleName();
                appendable.declareVariable(p, _simpleName);
            }
            JvmTypeReference _switchResult = null;
            boolean matched = false;
            if (!matched && op instanceof JvmOperation) {
                JvmTypeReference _returnType;
                JvmOperation _jvmOperation = (JvmOperation)op;
                matched = true;
                _switchResult = _returnType = _jvmOperation.getReturnType();
            }
            if (!matched && op instanceof JvmConstructor) {
                JvmTypeReference _typeForName;
                JvmConstructor _jvmConstructor = (JvmConstructor)op;
                matched = true;
                _switchResult = _typeForName = this._typeReferences.getTypeForName(Void.TYPE, (EObject)_jvmConstructor, new JvmTypeReference[0]);
            }
            if (!matched) {
                _switchResult = null;
            }
            JvmTypeReference returnType = _switchResult;
            EList _exceptions = op.getExceptions();
            Set _set = IterableExtensions.toSet((Iterable)_exceptions);
            this.compiler.compile(expression, appendable, returnType, _set);
            String _string = appendable.toString();
            String _removeSurroundingCurlies = this.removeSurroundingCurlies(_string);
            return _removeSurroundingCurlies;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"throw new UnsupportedOperationException(\"");
        String _simpleName_1 = op.getSimpleName();
        _builder.append((Object)_simpleName_1, "");
        _builder.append((Object)" is not implemented\");");
        return _builder;
    }

    public String removeSurroundingCurlies(String code) {
        String _trim;
        String result = _trim = code.trim();
        boolean _operator_and = false;
        boolean _startsWith = result.startsWith("{\n");
        if (!_startsWith) {
            _operator_and = false;
        } else {
            boolean _endsWith = result.endsWith("}");
            _operator_and = BooleanExtensions.operator_and((boolean)_startsWith, (boolean)_endsWith);
        }
        if (_operator_and) {
            int _length = result.length();
            int _operator_minus = IntegerExtensions.operator_minus((int)_length, (int)1);
            String _substring = result.substring(2, _operator_minus);
            return _substring;
        }
        boolean _operator_and_1 = false;
        boolean _startsWith_1 = result.startsWith("{");
        if (!_startsWith_1) {
            _operator_and_1 = false;
        } else {
            boolean _endsWith_1 = result.endsWith("}");
            _operator_and_1 = BooleanExtensions.operator_and((boolean)_startsWith_1, (boolean)_endsWith_1);
        }
        if (_operator_and_1) {
            int _length_1 = result.length();
            int _operator_minus_1 = IntegerExtensions.operator_minus((int)_length_1, (int)1);
            String _substring_1 = result.substring(1, _operator_minus_1);
            return _substring_1;
        }
        return result;
    }

    public StringConcatenation generateJavaDoc(EObject it) {
        DocumentationAdapter _head;
        StringConcatenation _xblockexpression = null;
        EList _eAdapters = it.eAdapters();
        Iterable _filter = IterableExtensions.filter((Iterable)_eAdapters, DocumentationAdapter.class);
        DocumentationAdapter adapter = _head = (DocumentationAdapter)((Object)IterableExtensions.head((Iterable)_filter));
        StringConcatenation _xifexpression = null;
        String _documentation = adapter == null ? null : adapter.getDocumentation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_documentation);
        boolean _operator_not = BooleanExtensions.operator_not((boolean)_isNullOrEmpty);
        if (_operator_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/**");
            StringConcatenation doc = _builder;
            doc.newLine();
            doc.append((Object)" * ");
            String _documentation_1 = adapter.getDocumentation();
            doc.append((Object)_documentation_1, " * ");
            doc.newLine();
            doc.append((Object)" */");
            doc.newLine();
            return doc;
        }
        _xblockexpression = _xifexpression = null;
        return _xblockexpression;
    }

    public CharSequence generateAnnotations(List<JvmAnnotationReference> annotations, ImportManager importManager) {
        StringConcatenation _xblockexpression = null;
        boolean _isEmpty = annotations.isEmpty();
        if (_isEmpty) {
            return null;
        }
        StringConcatenation _builder = new StringConcatenation();
        for (JvmAnnotationReference a : annotations) {
            _builder.append((Object)"@");
            JvmAnnotationType _annotation = a.getAnnotation();
            CharSequence _serialize = importManager.serialize((JvmType)_annotation);
            _builder.append((Object)_serialize, "");
            EList _values = a.getValues();
            boolean _hasElements = false;
            for (JvmAnnotationValue value : _values) {
                if (!_hasElements) {
                    _hasElements = true;
                    _builder.append((Object)"(", "");
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _java = this.toJava(value, importManager);
                _builder.append((Object)_java, "");
            }
            if (_hasElements) {
                _builder.append((Object)")", "");
            }
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence toJava(JvmAnnotationValue it, ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        JvmOperation _operation = it.getOperation();
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)_operation, null);
        if (_operator_notEquals) {
            JvmOperation _operation_1 = it.getOperation();
            String _simpleName = _operation_1.getSimpleName();
            _builder.append((Object)_simpleName, "");
            _builder.append((Object)" = ");
        }
        CharSequence _javaLiteral = this.toJavaLiteral(it, importManager);
        _builder.append((Object)_javaLiteral, "");
        return _builder;
    }

    protected CharSequence _toJavaLiteral(JvmAnnotationAnnotationValue it, ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        EList _annotations = it.getAnnotations();
        CharSequence _generateAnnotations = this.generateAnnotations((List<JvmAnnotationReference>)_annotations, importManager);
        _builder.append((Object)_generateAnnotations, "");
        return _builder;
    }

    protected CharSequence _toJavaLiteral(JvmShortAnnotationValue it, ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        EList _values = it.getValues();
        int _size = _values.size();
        boolean _operator_equals = IntegerExtensions.operator_equals((int)_size, (int)1);
        if (_operator_equals) {
            EList _values_1 = it.getValues();
            Short _head = (Short)IterableExtensions.head((Iterable)_values_1);
            _builder.append((Object)_head, "");
        } else {
            _builder.append((Object)"{");
            EList _values_2 = it.getValues();
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)",");
            _builder.append((Object)_join, "");
            _builder.append((Object)"}");
        }
        return _builder;
    }

    protected CharSequence _toJavaLiteral(JvmStringAnnotationValue it, ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        EList _values = it.getValues();
        int _size = _values.size();
        boolean _operator_equals = IntegerExtensions.operator_equals((int)_size, (int)1);
        if (_operator_equals) {
            _builder.append((Object)"\"");
            EList _values_1 = it.getValues();
            String _head = (String)IterableExtensions.head((Iterable)_values_1);
            _builder.append((Object)_head, "");
            _builder.append((Object)"\"");
        } else {
            _builder.append((Object)"{");
            EList _values_2 = it.getValues();
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String s) {
                    String _operator_plus = StringExtensions.operator_plus((String)"\"", (Object)s);
                    String _operator_plus_1 = StringExtensions.operator_plus((String)_operator_plus, (Object)"\"");
                    return _operator_plus_1;
                }
            };
            List _map = ListExtensions.map((List)_values_2, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",");
            _builder.append((Object)_join, "");
            _builder.append((Object)"}");
        }
        return _builder;
    }

    protected CharSequence _toJavaLiteral(JvmTypeAnnotationValue it, final ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        EList _values = it.getValues();
        int _size = _values.size();
        boolean _operator_equals = IntegerExtensions.operator_equals((int)_size, (int)1);
        if (_operator_equals) {
            EList _values_1 = it.getValues();
            JvmTypeReference _head = (JvmTypeReference)IterableExtensions.head((Iterable)_values_1);
            String _serialize = this.serialize(_head, importManager);
            _builder.append((Object)_serialize, "");
            _builder.append((Object)".class");
        } else {
            _builder.append((Object)"{");
            EList _values_2 = it.getValues();
            Functions.Function1<JvmTypeReference, String> _function = new Functions.Function1<JvmTypeReference, String>(){

                public String apply(JvmTypeReference t) {
                    String _serialize = JvmModelGenerator.this.serialize(t, importManager);
                    String _operator_plus = StringExtensions.operator_plus((String)_serialize, (Object)".class");
                    return _operator_plus;
                }
            };
            List _map = ListExtensions.map((List)_values_2, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",");
            _builder.append((Object)_join, "");
            _builder.append((Object)"}");
        }
        return _builder;
    }

    protected CharSequence _toJavaLiteral(JvmBooleanAnnotationValue it, ImportManager importManager) {
        StringConcatenation _builder = new StringConcatenation();
        EList _values = it.getValues();
        int _size = _values.size();
        boolean _operator_equals = IntegerExtensions.operator_equals((int)_size, (int)1);
        if (_operator_equals) {
            EList _values_1 = it.getValues();
            Boolean _head = (Boolean)IterableExtensions.head((Iterable)_values_1);
            _builder.append((Object)_head, "");
        } else {
            _builder.append((Object)"{");
            EList _values_2 = it.getValues();
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)",");
            _builder.append((Object)_join, "");
            _builder.append((Object)"}");
        }
        return _builder;
    }

    protected CharSequence _toJavaLiteral(JvmCustomAnnotationValue it, ImportManager importManager) {
        String _string;
        int _size;
        StringBuilderBasedAppendable _createAppendable;
        String _xblockexpression = null;
        final StringBuilderBasedAppendable appendable = _createAppendable = this.createAppendable((EObject)it, importManager);
        EList _values = it.getValues();
        int __valOfSwitchOver = _size = _values.size();
        boolean matched = false;
        if (!matched && ObjectExtensions.operator_equals((Object)__valOfSwitchOver, (Object)0)) {
            matched = true;
            appendable.append("{}");
        }
        if (!matched && ObjectExtensions.operator_equals((Object)__valOfSwitchOver, (Object)1)) {
            matched = true;
            EList _values_1 = it.getValues();
            Object _head = IterableExtensions.head((Iterable)_values_1);
            this.compiler.toJavaExpression((XExpression)_head, appendable);
        }
        if (!matched) {
            appendable.append("{");
            EList _values_2 = it.getValues();
            Object _head_1 = IterableExtensions.head((Iterable)_values_2);
            this.compiler.toJavaExpression((XExpression)_head_1, appendable);
            EList _values_3 = it.getValues();
            Iterable _tail = IterableExtensions.tail((Iterable)_values_3);
            Iterable _filter = IterableExtensions.filter((Iterable)_tail, XExpression.class);
            Procedures.Procedure1<XExpression> _function = new Procedures.Procedure1<XExpression>(){

                public void apply(XExpression it) {
                    appendable.append(",");
                    JvmModelGenerator.this.compiler.toJavaExpression(it, appendable);
                }
            };
            IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function);
            appendable.append("}");
        }
        _xblockexpression = _string = appendable.toString();
        return _xblockexpression;
    }

    public String serialize(JvmTypeReference it, ImportManager importManager) {
        String _string;
        StringBuilderBasedAppendable _createAppendable;
        String _xblockexpression = null;
        StringBuilderBasedAppendable appendable = _createAppendable = this.createAppendable((EObject)it, importManager);
        EObject _eContainer = it.eContainer();
        this.typeRefSerializer.serialize(it, _eContainer, appendable);
        _xblockexpression = _string = appendable.toString();
        return _xblockexpression;
    }

    public StringBuilderBasedAppendable createAppendable(EObject context, ImportManager importManager) {
        StringBuilderBasedAppendable _stringBuilderBasedAppendable;
        StringBuilderBasedAppendable _xblockexpression = null;
        StringBuilderBasedAppendable appendable = _stringBuilderBasedAppendable = new StringBuilderBasedAppendable(importManager);
        JvmGenericType _containerType = this.containerType(context);
        JvmGenericType type = _containerType;
        boolean _operator_notEquals = ObjectExtensions.operator_notEquals((Object)type, null);
        if (_operator_notEquals) {
            JvmTypeReference _extendedClass;
            JvmGenericType _containerType_1 = this.containerType(context);
            appendable.declareVariable(_containerType_1, "this");
            JvmGenericType _containerType_2 = this.containerType(context);
            JvmTypeReference superType = _extendedClass = _containerType_2.getExtendedClass();
            boolean _operator_notEquals_1 = ObjectExtensions.operator_notEquals((Object)superType, null);
            if (_operator_notEquals_1) {
                JvmType _type = superType.getType();
                appendable.declareVariable(_type, "super");
            }
        }
        _xblockexpression = appendable;
        return _xblockexpression;
    }

    public JvmGenericType containerType(EObject context) {
        JvmGenericType _xifexpression = null;
        boolean _operator_equals = ObjectExtensions.operator_equals((Object)context, null);
        if (_operator_equals) {
            _xifexpression = null;
        } else {
            JvmGenericType _xifexpression_1 = null;
            if (context instanceof JvmGenericType) {
                _xifexpression_1 = (JvmGenericType)context;
            } else {
                JvmGenericType _containerType;
                EObject _eContainer = context.eContainer();
                _xifexpression_1 = _containerType = this.containerType(_eContainer);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public void internalDoGenerate(EObject type, IFileSystemAccess fsa) {
        if (type instanceof JvmGenericType) {
            this._internalDoGenerate((JvmGenericType)type, fsa);
        } else {
            this._internalDoGenerate(type, fsa);
        }
    }

    public CharSequence generateModifier(JvmMember it) {
        if (it instanceof JvmConstructor) {
            return this._generateModifier((JvmConstructor)it);
        }
        if (it instanceof JvmGenericType) {
            return this._generateModifier((JvmGenericType)it);
        }
        if (it instanceof JvmOperation) {
            return this._generateModifier((JvmOperation)it);
        }
        if (it instanceof JvmField) {
            return this._generateModifier((JvmField)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public CharSequence generateMember(JvmMember it, ImportManager importManager) {
        if (it instanceof JvmConstructor) {
            return this._generateMember((JvmConstructor)it, importManager);
        }
        if (it instanceof JvmOperation) {
            return this._generateMember((JvmOperation)it, importManager);
        }
        if (it instanceof JvmField) {
            return this._generateMember((JvmField)it, importManager);
        }
        return this._generateMember(it, importManager);
    }

    public CharSequence toJavaLiteral(JvmAnnotationValue it, ImportManager importManager) {
        if (it instanceof JvmAnnotationAnnotationValue) {
            return this._toJavaLiteral((JvmAnnotationAnnotationValue)it, importManager);
        }
        if (it instanceof JvmBooleanAnnotationValue) {
            return this._toJavaLiteral((JvmBooleanAnnotationValue)it, importManager);
        }
        if (it instanceof JvmCustomAnnotationValue) {
            return this._toJavaLiteral((JvmCustomAnnotationValue)it, importManager);
        }
        if (it instanceof JvmShortAnnotationValue) {
            return this._toJavaLiteral((JvmShortAnnotationValue)it, importManager);
        }
        if (it instanceof JvmStringAnnotationValue) {
            return this._toJavaLiteral((JvmStringAnnotationValue)it, importManager);
        }
        if (it instanceof JvmTypeAnnotationValue) {
            return this._toJavaLiteral((JvmTypeAnnotationValue)it, importManager);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, importManager).toString());
    }
}

