/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hierarchy;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;

public abstract class AbstractTypeHierarchyHandler
extends AbstractHandler {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IJavaElementFinder javaElementFinder;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
        if (editor != null) {
            final ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
            editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Void, XtextResource>(){

                public Void exec(XtextResource resource) throws Exception {
                    IJavaElement javaType;
                    JvmIdentifiableElement jvmIdentifiable;
                    EObject selectedElement = AbstractTypeHierarchyHandler.this.eObjectAtOffsetHelper.resolveElementAt(resource, selection.getOffset());
                    if (selectedElement != null && (jvmIdentifiable = this.getJvmIdentifiableElement(selectedElement)) != null && (javaType = AbstractTypeHierarchyHandler.this.javaElementFinder.findElementFor(jvmIdentifiable)) != null) {
                        AbstractTypeHierarchyHandler.this.openPresentation(editor, javaType, selectedElement);
                    }
                    return null;
                }

                private JvmIdentifiableElement getJvmIdentifiableElement(EObject element) {
                    JvmIdentifiableElement type;
                    if (element instanceof JvmIdentifiableElement) {
                        return (JvmIdentifiableElement)element;
                    }
                    Set jvmElements = AbstractTypeHierarchyHandler.this.associations.getJvmElements(element);
                    if (!jvmElements.isEmpty() && (type = (JvmIdentifiableElement)jvmElements.iterator().next()) != null) {
                        return type;
                    }
                    return null;
                }
            });
        }
        return null;
    }

    protected abstract void openPresentation(XtextEditor var1, IJavaElement var2, EObject var3);
}

