/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.editor.quickfix;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;

public class XtextGrammarQuickfixProvider
extends DefaultQuickfixProvider {
    private String NULL_QUICKFIX_IMAGE = null;

    @Fix(value="org.eclipse.xtext.grammar.UnresolvedRule")
    public void fixUnresolvedRule(Issue issue, IssueResolutionAcceptor acceptor) {
        final String ruleName = issue.getData()[0];
        acceptor.accept(issue, "Create rule '" + ruleName + "'", "Create rule '" + ruleName + "'", this.NULL_QUICKFIX_IMAGE, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws BadLocationException {
                AbstractRule abstractRule = (AbstractRule)EcoreUtil2.getContainerOfType((EObject)element, ParserRule.class);
                ICompositeNode node = NodeModelUtils.getNode((EObject)abstractRule);
                int offset = node.getOffset() + node.getLength();
                StringBuilder builder = new StringBuilder("\n\n");
                if (abstractRule instanceof TerminalRule) {
                    builder.append("terminal ");
                }
                String newRule = builder.append(ruleName).append(":\n\t\n;\n").toString();
                context.getXtextDocument().replace(offset, 0, newRule);
            }
        });
        this.createLinkingIssueResolutions(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.grammar.InvalidMetaModelName")
    public void fixInvalidMetaModelName(Issue issue, IssueResolutionAcceptor acceptor) {
        String metaModelName = issue.getData()[0];
        acceptor.accept(issue, "Fix metamodel name '" + metaModelName + "'", "Fix metamodel name '" + metaModelName + "'", this.NULL_QUICKFIX_IMAGE, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) {
                GeneratedMetamodel generatedMetamodel = (GeneratedMetamodel)element;
                generatedMetamodel.setName(Strings.toFirstLower((String)generatedMetamodel.getName()));
            }
        });
    }

    @Fix(value="org.eclipse.xtext.grammar.EmptyEnumLiteral")
    public void fixEmptyEnumLiteral(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Fix empty enum literal", "Fix empty enum literal", this.NULL_QUICKFIX_IMAGE, new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) {
                EnumLiteralDeclaration enumLiteralDeclaration = (EnumLiteralDeclaration)element;
                Keyword keyword = XtextFactory.eINSTANCE.createKeyword();
                keyword.setValue(enumLiteralDeclaration.getEnumLiteral().getName().toLowerCase());
                enumLiteralDeclaration.setLiteral(keyword);
            }
        });
    }

    @Fix(value="org.eclipse.xtext.grammar.InvalidActionUsage")
    public void fixInvalidActionUsage(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Fix invalid action usage", "Fix invalid action usage", this.NULL_QUICKFIX_IMAGE, new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                context.getXtextDocument().replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
            }
        });
    }
}

