/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.builder;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtend2.compiler.Xtend2Compiler;
import org.eclipse.xtext.xtend2.ui.builder.CompilationFileProvider;
import org.eclipse.xtext.xtend2.ui.builder.FolderUtil;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;

public class Xtend2BuilderParticipant
implements IXtextBuilderParticipant {
    private static final Logger LOG = Logger.getLogger(Xtend2BuilderParticipant.class);
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private Xtend2Compiler compiler;
    @Inject
    private CompilationFileProvider compilationFileProvider;
    @Inject
    private IEncodingProvider encodingProvider;
    @Inject
    private FolderUtil folderUtil;

    public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        try {
            if (!JavaCore.create((IProject)context.getBuiltProject()).exists()) {
                return;
            }
            Iterable xtendDeltas = Iterables.filter((Iterable)context.getDeltas(), (Predicate)new Predicate<IResourceDescription.Delta>(){

                public boolean apply(IResourceDescription.Delta input) {
                    return Xtend2BuilderParticipant.this.fileExtensionProvider.isValid(input.getUri().fileExtension());
                }
            });
            if (!Iterables.isEmpty((Iterable)xtendDeltas)) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(Iterables.size((Iterable)xtendDeltas) + 3));
                IFolder targetFolder = this.compilationFileProvider.getTargetFolder(context.getBuiltProject(), progress.newChild(1));
                this.wipeTargetFolder(targetFolder, context, progress.newChild(1));
                for (IResourceDescription.Delta delta : xtendDeltas) {
                    this.processDelta(delta, context, progress.newChild(1));
                }
                this.folderUtil.removeEmptySubFolders(targetFolder, progress.newChild(1));
                context.needRebuild();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void processDelta(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, SubMonitor progress) {
        progress.setWorkRemaining(100);
        URI sourceURI = delta.getUri();
        if (sourceURI.isArchive()) {
            return;
        }
        IFile sourceFile = null;
        try {
            sourceFile = this.compilationFileProvider.getFile(sourceURI, context.getBuiltProject());
            if (sourceFile == null) {
                return;
            }
            if (sourceFile.exists() && this.hasErrors(sourceFile)) {
                return;
            }
            if (!sourceFile.exists() && delta.getNew() != null) {
                return;
            }
            IFile targetFile = this.compilationFileProvider.getTargetFile(sourceURI, context.getBuiltProject(), progress.newChild(10));
            if (delta.getNew() != null) {
                Resource sourceResource = null;
                sourceResource = context.getResourceSet().getResource(sourceURI, true);
                if (sourceResource == null) {
                    throw new IllegalStateException("Cannot load source Xtend2 resource " + Strings.notNull((Object)sourceURI));
                }
                EcoreUtil.resolveAll((Resource)sourceResource);
                if (!sourceResource.getErrors().isEmpty()) {
                    return;
                }
                if (!sourceResource.getContents().isEmpty()) {
                    this.compile(sourceResource, targetFile, progress.newChild(80));
                }
            } else if (delta.getOld() != null) {
                targetFile.delete(true, (IProgressMonitor)progress.newChild(10));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error compiling " + Strings.notNull((Object)sourceURI)), (Throwable)e);
        }
    }

    protected boolean hasErrors(IFile sourceFile) throws CoreException {
        return sourceFile.findMaxProblemSeverity(null, true, 0) == 2;
    }

    protected void wipeTargetFolder(IFolder targetFolder, IXtextBuilderParticipant.IBuildContext context, SubMonitor progress) throws CoreException {
        switch (context.getBuildType()) {
            case CLEAN: 
            case RECOVERY: {
                this.folderUtil.clearFolder(targetFolder, progress);
                break;
            }
        }
    }

    protected void compile(Resource sourceResource, IFile targetFile, SubMonitor progress) throws CoreException, UnsupportedEncodingException {
        progress.setWorkRemaining(100);
        StringWriter appendable = new StringWriter();
        this.compiler.compile((XtendFile)sourceResource.getContents().get(0), (Writer)appendable);
        progress.worked(50);
        String encoding = this.encodingProvider.getEncoding(sourceResource.getURI());
        this.folderUtil.createParentFolders((IResource)targetFile, progress.newChild(10));
        if (targetFile.exists()) {
            targetFile.setContents((InputStream)new StringInputStream(appendable.toString(), encoding), true, false, (IProgressMonitor)progress.newChild(40));
        } else {
            targetFile.create((InputStream)new StringInputStream(appendable.toString(), encoding), true, (IProgressMonitor)progress.newChild(40));
        }
        targetFile.setDerived(true);
        if (!Strings.equal((String)targetFile.getCharset(), (String)encoding)) {
            targetFile.setCharset(encoding, (IProgressMonitor)progress);
        }
    }
}

