/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynonymTypesProvider {
    @Inject
    private Primitives primitives;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private SuperTypeCollector superTypeCollector;

    public Iterable<JvmTypeReference> getSynonymTypes(JvmTypeReference type) {
        if (type == null || this.typeRefs.is(type, Void.class) || this.typeRefs.is(type, Void.TYPE)) {
            return Collections.emptySet();
        }
        if (this.primitives.isPrimitive(type)) {
            return Collections.singleton(this.primitives.asWrapperTypeIfPrimitive(type));
        }
        if (this.primitives.isWrapperType(type)) {
            return Collections.singleton(this.primitives.asPrimitiveIfWrapperType(type));
        }
        if (this.typeRefs.isArray(type)) {
            JvmArrayType array = (JvmArrayType)type.getType();
            JvmTypeReference typeArg = this.primitives.asWrapperTypeIfPrimitive(array.getComponentType());
            JvmTypeReference iterable = this.typeRefs.getTypeForName(List.class, this.findContext((JvmType)array), new JvmTypeReference[]{typeArg});
            return Collections.singleton(iterable);
        }
        if (this.isList(type)) {
            JvmTypeReference jvmTypeReference;
            EList arguments;
            JvmTypeReference componentType = null;
            if (type instanceof JvmParameterizedTypeReference && (arguments = ((JvmParameterizedTypeReference)type).getArguments()).size() == 1 && (componentType = (jvmTypeReference = (JvmTypeReference)arguments.get(0))) instanceof JvmWildcardTypeReference) {
                EList list = ((JvmWildcardTypeReference)componentType).getConstraints();
                componentType = this.typeRefs.getTypeForName(Object.class, this.findContext(type.getType()), new JvmTypeReference[0]);
                for (JvmTypeConstraint constraint : list) {
                    if (!(constraint instanceof JvmUpperBound)) continue;
                    componentType = constraint.getTypeReference();
                }
            }
            if (componentType == null) {
                componentType = this.typeRefs.getTypeForName(Object.class, (EObject)type.getType(), new JvmTypeReference[0]);
            }
            JvmGenericArrayTypeReference result = this.typeRefs.createArrayType(componentType);
            return Collections.singleton(result);
        }
        return Collections.emptySet();
    }

    protected boolean isList(JvmTypeReference type) {
        return this.typeRefs.is(type, List.class) || this.typeRefs.is(type, Iterable.class) || this.typeRefs.is(type, Collection.class);
    }

    protected EObject findContext(JvmType type) {
        if (type instanceof JvmArrayType) {
            return this.findContext(((JvmArrayType)type).getComponentType().getType());
        }
        return type;
    }

    public boolean hasSynonymTypes(JvmTypeReference toBeConverted) {
        Iterable<JvmTypeReference> synonymTypes = this.getSynonymTypes(toBeConverted);
        if (synonymTypes instanceof Collection) {
            return !((Collection)synonymTypes).isEmpty();
        }
        return !Iterables.isEmpty(synonymTypes);
    }

    public JvmTypeReference findCompatibleSynonymType(JvmTypeReference toBeConverted, JvmType toBeCompatible) {
        if (this.isAssignable(toBeConverted, toBeCompatible)) {
            return toBeConverted;
        }
        Iterable<JvmTypeReference> types = this.getSynonymTypes(toBeConverted);
        for (JvmTypeReference synonym : types) {
            if (!this.isAssignable(synonym, toBeCompatible)) continue;
            return synonym;
        }
        return null;
    }

    protected boolean isAssignable(JvmTypeReference toBeConverted, JvmType toBeCompatible) {
        if (toBeConverted.getType() == toBeCompatible) {
            return true;
        }
        Set rawTypes = this.superTypeCollector.collectSuperTypesAsRawTypes(toBeConverted);
        for (JvmType jvmType : rawTypes) {
            if (jvmType != toBeCompatible) continue;
            return true;
        }
        return false;
    }
}

