/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.typing.XbaseTypeConformanceComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeProvider
implements ITypeProvider {
    private static final Logger logger = Logger.getLogger(AbstractTypeProvider.class);
    @Inject
    private XbaseTypeConformanceComputer typeConformanceComputer;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    private OnChangeEvictingCache typeReferenceAwareCache;
    private final PolymorphicDispatcher<JvmTypeReference> typeDispatcher;
    protected CyclicHandlingSupport<XExpression> getType;
    private final PolymorphicDispatcher<JvmTypeReference> expectedTypeDispatcher;
    protected CyclicHandlingSupport<XExpression> getExpectedType;
    private final PolymorphicDispatcher<JvmTypeReference> typeForIdentifiableDispatcher;
    protected CyclicHandlingSupport<JvmIdentifiableElement> getTypeForIdentifiable;
    private PolymorphicDispatcher<Void> earlyExits;

    public AbstractTypeProvider() {
        this.checkIsSingelton();
        this.typeReferenceAwareCache = new OnChangeEvictingCache(){

            public <T> T get(Object key, Resource resource, Provider<T> provider) {
                if (resource == null) {
                    return (T)provider.get();
                }
                OnChangeEvictingCache.CacheAdapter adapter = this.getOrCreate(resource);
                Object element = adapter.get(key);
                if (element == null) {
                    element = provider.get();
                    boolean rawType = (Boolean)((Triple)key).getThird();
                    if (element == null || element instanceof JvmTypeReference && !AbstractTypeProvider.this.isResolved((JvmTypeReference)element, null, rawType)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(String.valueOf(AbstractTypeProvider.this.getDebugIndentation(rawType)) + "cache skip: " + element));
                        }
                        return (T)element;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(String.valueOf(AbstractTypeProvider.this.getDebugIndentation(rawType)) + "cache: " + element));
                    }
                    adapter.set(key, element);
                }
                return (T)element;
            }
        };
        this.typeDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_type", (int)2, (int)2, (Object)this);
        this.getType = new CyclicHandlingSupport<XExpression>(){

            @Override
            protected JvmTypeReference doComputation(XExpression t, boolean rawType) {
                return (JvmTypeReference)AbstractTypeProvider.this.typeDispatcher.invoke(new Object[]{t, rawType});
            }

            @Override
            protected JvmTypeReference doHandleCyclicCall(XExpression t, boolean rawType) {
                return AbstractTypeProvider.this.handleCyclicGetType(t, rawType);
            }
        };
        this.expectedTypeDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_expectedType", (int)4, (int)4, (Object)this);
        this.getExpectedType = new CyclicHandlingSupport<XExpression>(){

            @Override
            protected JvmTypeReference doComputation(XExpression t, boolean rawType) {
                Triple<EObject, EReference, Integer> triple = AbstractTypeProvider.this.getContainingInfo(t);
                if (triple == null) {
                    return null;
                }
                return (JvmTypeReference)AbstractTypeProvider.this.expectedTypeDispatcher.invoke(new Object[]{triple.getFirst(), triple.getSecond(), triple.getThird(), rawType});
            }

            @Override
            protected JvmTypeReference doHandleCyclicCall(XExpression t, boolean rawType) {
                return AbstractTypeProvider.this.handleCycleGetExpectedType(t, rawType);
            }
        };
        this.typeForIdentifiableDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"_typeForIdentifiable", (int)2, (int)2, (Object)this);
        this.getTypeForIdentifiable = new CyclicHandlingSupport<JvmIdentifiableElement>(){

            @Override
            protected JvmTypeReference doComputation(JvmIdentifiableElement t, boolean rawType) {
                return (JvmTypeReference)AbstractTypeProvider.this.typeForIdentifiableDispatcher.invoke(new Object[]{t, rawType});
            }

            @Override
            protected JvmTypeReference doHandleCyclicCall(JvmIdentifiableElement t, boolean rawType) {
                return AbstractTypeProvider.this.handleCycleGetTypeForIdentifiable(t, rawType);
            }
        };
        this.earlyExits = PolymorphicDispatcher.createForSingleTarget((String)"_earlyExits", (int)2, (int)2, (Object)this);
    }

    protected void checkIsSingelton() {
        Singleton singleton = this.getClass().getAnnotation(Singleton.class);
        if (singleton == null) {
            throw new IllegalStateException("The class " + this.getClass().getSimpleName() + " must be annotated with @Singleton annotation.");
        }
    }

    protected boolean isResolved(JvmTypeReference reference, JvmTypeParameterDeclarator declarator, boolean rawType) {
        if (reference == null) {
            return false;
        }
        if (reference.getType() instanceof JvmTypeParameter) {
            return this.isDeclaratorOf(declarator, (JvmTypeParameter)reference.getType());
        }
        if (reference instanceof JvmParameterizedTypeReference) {
            if (rawType) {
                return true;
            }
            JvmParameterizedTypeReference parameterized = (JvmParameterizedTypeReference)reference;
            for (JvmTypeReference argument : parameterized.getArguments()) {
                if (this.isResolved(argument, declarator, rawType)) continue;
                return false;
            }
        }
        if (reference instanceof JvmWildcardTypeReference) {
            for (JvmTypeConstraint constraint : ((JvmWildcardTypeReference)reference).getConstraints()) {
                if (this.isResolved(constraint.getTypeReference(), declarator, rawType)) continue;
                return false;
            }
        }
        return true;
    }

    protected JvmTypeParameterDeclarator getNearestTypeParameterDeclarator(EObject obj) {
        return (JvmTypeParameterDeclarator)EcoreUtil2.getContainerOfType((EObject)obj, JvmTypeParameterDeclarator.class);
    }

    protected boolean isDeclaratorOf(JvmTypeParameterDeclarator declarator, JvmTypeParameter param) {
        return param.getDeclarator() == declarator;
    }

    protected JvmTypeReference _type(XExpression expression, boolean rawType) {
        throw new IllegalArgumentException("Type computation is not implemented for " + expression);
    }

    protected String getDebugIndentation(boolean rawType) {
        int size = this.getType.getOngoingComputationsSize(rawType) + this.getExpectedType.getOngoingComputationsSize(rawType) + this.getTypeForIdentifiable.getOngoingComputationsSize(rawType);
        char[] chars = new char[size];
        Arrays.fill(chars, ' ');
        return String.valueOf(chars);
    }

    protected <T extends EObject> JvmTypeReference doGetType(String key, T object, boolean rawType, CyclicHandlingSupport<T> typeComputer) {
        String debugIndentation = null;
        if (logger.isDebugEnabled()) {
            debugIndentation = this.getDebugIndentation(rawType);
            if (debugIndentation.length() == 0) {
                StackTraceElement[] stackTrace;
                StackTraceElement[] stackTraceElementArray = stackTrace = new RuntimeException().getStackTrace();
                int n = stackTrace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    if (!element.isNativeMethod() && !AbstractTypeProvider.class.getName().equals(element.getClassName())) {
                        logger.debug((Object)(String.valueOf(debugIndentation) + key + "(" + (rawType ? "raw" : "parameterized") + ") : " + element));
                        break;
                    }
                    ++n2;
                }
            }
            logger.debug((Object)(String.valueOf(debugIndentation) + key + ": " + object));
        }
        JvmTypeReference result = typeComputer.getType(object, rawType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(debugIndentation) + "result: " + result + " " + key + "(" + (rawType ? "raw" : "parameterized") + ") : " + object));
        }
        return result;
    }

    @Override
    public JvmTypeReference getType(XExpression expression) {
        return this.getType(expression, false);
    }

    @Override
    public JvmTypeReference getType(XExpression expression, boolean rawType) {
        return this.doGetType("getType", expression, rawType, this.getType);
    }

    protected JvmTypeReference handleCyclicGetType(XExpression expression, boolean rawType) {
        return null;
    }

    protected JvmTypeReference _expectedType(EObject container, EReference reference, int index, boolean rawType) {
        return null;
    }

    @Override
    public JvmTypeReference getExpectedType(XExpression expression) {
        return this.getExpectedType(expression, false);
    }

    @Override
    public JvmTypeReference getExpectedType(XExpression expression, boolean rawType) {
        return this.doGetType("getExpectedType", expression, rawType, this.getExpectedType);
    }

    protected JvmTypeReference handleCycleGetExpectedType(XExpression expression, boolean rawType) {
        return null;
    }

    protected Triple<EObject, EReference, Integer> getContainingInfo(XExpression obj) {
        if (obj == null) {
            return null;
        }
        if (obj.eIsProxy()) {
            return null;
        }
        EReference containmentReference = obj.eContainmentFeature();
        if (containmentReference == null) {
            return null;
        }
        EObject container = obj.eContainer();
        int index = containmentReference.isMany() ? ((List)container.eGet((EStructuralFeature)containmentReference)).indexOf(obj) : -1;
        Triple triple = Tuples.create((Object)container, (Object)containmentReference, (Object)index);
        return triple;
    }

    protected JvmTypeReference _typeForIdentifiable(JvmIdentifiableElement identifiable, boolean rawType) {
        throw new IllegalArgumentException("Type computation is not implemented for " + identifiable);
    }

    @Override
    public JvmTypeReference getTypeForIdentifiable(JvmIdentifiableElement identifiableElement) {
        return this.getTypeForIdentifiable(identifiableElement, false);
    }

    @Override
    public JvmTypeReference getTypeForIdentifiable(JvmIdentifiableElement identifiableElement, boolean rawType) {
        return this.doGetType("getTypeForIdentifiable", identifiableElement, rawType, this.getTypeForIdentifiable);
    }

    protected JvmTypeReference handleCycleGetTypeForIdentifiable(JvmIdentifiableElement identifiableElement, boolean rawType) {
        return null;
    }

    @Override
    public JvmTypeReference getCommonReturnType(XExpression expression, boolean assumeImplicitReturnExpression) {
        JvmTypeReference implicitReturnType;
        EarlyExitAcceptor acceptor = new EarlyExitAcceptor();
        this.internalCollectEarlyExits(expression, acceptor);
        List<JvmTypeReference> returns = acceptor.returns;
        if (assumeImplicitReturnExpression && (implicitReturnType = this.getType(expression)) != null && !this.typeReferences.is(implicitReturnType, Void.TYPE)) {
            acceptor.returns.add(implicitReturnType);
        }
        if (returns.isEmpty()) {
            if (expression != null) {
                return this.typeReferences.getTypeForName(Void.TYPE, (EObject)expression, new JvmTypeReference[0]);
            }
            return null;
        }
        JvmTypeReference superType = this.typeConformanceComputer.getCommonSuperType(returns);
        return superType;
    }

    @Override
    public Iterable<JvmTypeReference> getThrownExceptionTypes(XExpression expression) {
        EarlyExitAcceptor acceptor = new EarlyExitAcceptor();
        this.internalCollectEarlyExits(expression, acceptor);
        HashMap result = Maps.newHashMap();
        for (JvmTypeReference thrownType : acceptor.thrown) {
            result.put(thrownType.getType(), thrownType);
        }
        return result.values();
    }

    protected void internalCollectEarlyExits(EObject expr, EarlyExitAcceptor acceptor) {
        this.earlyExits.invoke(new Object[]{expr, acceptor});
    }

    protected void _earlyExits(Void expr, EarlyExitAcceptor a) {
    }

    protected void _earlyExits(JvmTypeReference ref, EarlyExitAcceptor a) {
    }

    protected void _earlyExits(EObject expr, EarlyExitAcceptor acceptor) {
        EList list = expr.eContents();
        for (EObject eObject : list) {
            this.internalCollectEarlyExits(eObject, acceptor);
        }
    }

    protected XbaseTypeConformanceComputer getTypeConformanceComputer() {
        return this.typeConformanceComputer;
    }

    protected TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    protected TypeArgumentContextProvider getTypeArgumentContextProvider() {
        return this.typeArgumentContextProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ComputationData<T extends EObject> {
        protected final Set<T> computations = Sets.newHashSet();
        protected ImmutableLinkedItem queryState = null;
        protected Resource resource;
        protected boolean resourceLeftOrCyclic;

        protected ComputationData() {
        }

        protected boolean add(T t) {
            boolean result = this.computations.add(t);
            if (result) {
                if (this.queryState == null) {
                    this.resource = t.eResource();
                }
                this.queryState = new ImmutableLinkedItem((EObject)t, this.queryState);
            }
            return result;
        }

        protected void remove(T t) {
            this.computations.remove(t);
            this.queryState = this.queryState.prev;
            if (this.queryState == null) {
                this.resource = null;
            }
        }

        protected int size() {
            return this.computations.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class CyclicHandlingSupport<T extends EObject> {
        private final ThreadLocal<ComputationData<T>> ongoingComputations = new ThreadLocal<ComputationData<T>>(){

            @Override
            protected ComputationData<T> initialValue() {
                return new ComputationData();
            }
        };
        private final ThreadLocal<ComputationData<T>> ongoingRawTypeComputations = new ThreadLocal<ComputationData<T>>(){

            @Override
            protected ComputationData<T> initialValue() {
                return new ComputationData();
            }
        };

        CyclicHandlingSupport() {
        }

        protected ComputationData<T> getTypeComputations(boolean rawType) {
            ThreadLocal<ComputationData<T>> computations = rawType ? this.ongoingRawTypeComputations : this.ongoingComputations;
            ComputationData<T> result = computations.get();
            return result;
        }

        public JvmTypeReference getType(final T t, final boolean rawType) {
            if (t == null) {
                return null;
            }
            if (t.eIsProxy()) {
                return null;
            }
            ComputationData<T> computationData = this.getTypeComputations(rawType);
            if (computationData.add(t)) {
                try {
                    if (computationData.resource == t.eResource() && !computationData.resourceLeftOrCyclic) {
                        Triple cacheKey = Tuples.create((Object)this, (Object)computationData.queryState, (Object)rawType);
                        final boolean[] hit = new boolean[]{true};
                        JvmTypeReference result = (JvmTypeReference)AbstractTypeProvider.this.typeReferenceAwareCache.get((Object)cacheKey, computationData.resource, (Provider)new Provider<JvmTypeReference>(){

                            public JvmTypeReference get() {
                                hit[0] = false;
                                JvmTypeReference result = CyclicHandlingSupport.this.doComputation(t, rawType);
                                return result;
                            }
                        });
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(String.valueOf(AbstractTypeProvider.this.getDebugIndentation(rawType)) + "cache hit: " + hit[0] + " for: " + t));
                        }
                        JvmTypeReference jvmTypeReference = result;
                        return jvmTypeReference;
                    }
                    if (computationData.resourceLeftOrCyclic) {
                        JvmTypeReference jvmTypeReference = this.doComputation(t, rawType);
                        return jvmTypeReference;
                    }
                    try {
                        computationData.resourceLeftOrCyclic = true;
                        JvmTypeReference jvmTypeReference = this.doComputation(t, rawType);
                        computationData.resourceLeftOrCyclic = false;
                        return jvmTypeReference;
                    }
                    catch (Throwable throwable) {
                        computationData.resourceLeftOrCyclic = false;
                        throw throwable;
                    }
                }
                finally {
                    computationData.remove(t);
                }
            }
            if (computationData.resourceLeftOrCyclic) {
                return this.doHandleCyclicCall(t, rawType);
            }
            try {
                computationData.resourceLeftOrCyclic = true;
                JvmTypeReference jvmTypeReference = this.doHandleCyclicCall(t, rawType);
                return jvmTypeReference;
            }
            finally {
                computationData.resourceLeftOrCyclic = false;
            }
        }

        protected int getOngoingComputationsSize(boolean rawType) {
            return this.getTypeComputations(rawType).size();
        }

        protected abstract JvmTypeReference doComputation(T var1, boolean var2);

        protected abstract JvmTypeReference doHandleCyclicCall(T var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EarlyExitAcceptor {
        protected List<JvmTypeReference> returns = Lists.newArrayList();
        protected List<JvmTypeReference> thrown = Lists.newArrayList();

        public List<JvmTypeReference> getReturns() {
            return this.returns;
        }

        public List<JvmTypeReference> getThrown() {
            return this.thrown;
        }

        public void appendThrown(Iterable<JvmTypeReference> exceptions) {
            this.thrown.addAll(Lists.newArrayList(exceptions));
        }
    }

    protected static final class ImmutableLinkedItem {
        protected final EObject object;
        protected final ImmutableLinkedItem prev;
        protected final int hashCode;
        protected final int size;

        public ImmutableLinkedItem(EObject object, ImmutableLinkedItem immutableStack) {
            this.object = object;
            this.prev = immutableStack;
            this.size = immutableStack == null ? 1 : immutableStack.size + 1;
            this.hashCode = this.prev != null ? 31 * this.size * this.prev.hashCode() + object.hashCode() : object.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.hashCode() != this.hashCode() || obj.getClass() != ImmutableLinkedItem.class) {
                return false;
            }
            ImmutableLinkedItem other = (ImmutableLinkedItem)obj;
            return other.object == this.object && other.size == this.size && (other.prev == this.prev || this.prev != null && this.prev.equals(other.prev));
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

