/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.Later;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringBuilderBasedAppendable
implements IAppendable {
    private StringBuilder builder = new StringBuilder(8192);
    private int indentationlevel = 0;
    private String indentation = "  ";
    private ImportManager importManager;
    private Stack<Map<Object, String>> localVars = new Stack();
    private Stack<Set<String>> usedNamesInScope = new Stack();

    @Override
    public IAppendable append(Object obj) {
        if (obj instanceof Later) {
            throw new IllegalArgumentException("Later cannot be appended. Call exec on it.");
        }
        if (obj instanceof JvmTypeReference) {
            this.appendTypeRef((JvmTypeReference)obj);
        } else if (obj instanceof JvmType) {
            this.appendType((JvmType)obj);
        } else {
            String string = String.valueOf(obj);
            String replaced = string.replace("\n", this.getIndentationString());
            this.builder.append(replaced);
        }
        return this;
    }

    private CharSequence getIndentationString() {
        StringBuilder sb = new StringBuilder(10);
        sb.append("\n");
        int i = 0;
        while (i < this.indentationlevel) {
            sb.append(this.indentation);
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return this.builder.toString();
    }

    @Override
    public IAppendable increaseIndentation() {
        ++this.indentationlevel;
        return this;
    }

    @Override
    public IAppendable decreaseIndentation() {
        if (this.indentationlevel == 0) {
            throw new IllegalStateException("Can't reduce indentation level. It's already zero.");
        }
        --this.indentationlevel;
        return this;
    }

    public StringBuilderBasedAppendable(ImportManager typeSerializer) {
        this.importManager = typeSerializer;
        this.openScope();
    }

    public StringBuilderBasedAppendable() {
        this(new ImportManager(false));
    }

    @Override
    public void openScope() {
        this.localVars.push(new HashMap());
        this.usedNamesInScope.push(new LinkedHashSet());
    }

    @Override
    public String declareVariable(Object key, String proposedName) {
        if (this.localVars.isEmpty()) {
            throw new IllegalStateException("No local scope has been opened.");
        }
        Map<Object, String> currentScope = this.localVars.peek();
        Set<String> names = this.usedNamesInScope.peek();
        String newName = this.findNewName(names, proposedName);
        currentScope.put(key, newName);
        names.add(newName);
        return newName;
    }

    protected String findNewName(Set<String> names, String proposedName) {
        if (names.contains(proposedName)) {
            int i = 1;
            while (i < Integer.MAX_VALUE) {
                String newProposal = String.valueOf(proposedName) + "_" + i;
                if (!names.contains(newProposal)) {
                    return newProposal;
                }
                ++i;
            }
        }
        return proposedName;
    }

    @Override
    public String getName(Object key) {
        if (this.localVars.isEmpty()) {
            throw new IllegalStateException("No local scope has been opened.");
        }
        int size = this.localVars.size();
        int i = size - 1;
        while (i >= 0) {
            Map currentScope;
            String string;
            if ((string = (String)(currentScope = (Map)this.localVars.get(i--)).get(key)) == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public void closeScope() {
        if (this.localVars.isEmpty()) {
            throw new IllegalStateException("No local scope has been opened.");
        }
        this.localVars.pop();
        this.usedNamesInScope.pop();
    }

    protected void appendTypeRef(JvmTypeReference typeRef) {
        this.importManager.appendTypeRef(typeRef, this.builder);
    }

    protected void appendType(JvmType type) {
        this.importManager.appendType(type, this.builder);
    }

    @Override
    public List<String> getImports() {
        return this.importManager.getImports();
    }
}

