/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.RenameElementHandler;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.RenameJvmDeclarationContext;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.RenameJvmReferenceContext;

public class JvmRenameElementHandler
extends RenameElementHandler {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IJavaElementFinder javaElementFinder;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return super.execute(event);
    }

    public IRenameElementContext createRenameElementContext(EObject targetElement, XtextEditor editor, ITextSelection selection, XtextResource resource) {
        ArrayList javaElements;
        IJavaElement javaElement;
        if (targetElement.eClass() != null && targetElement.eClass().getEPackage() == TypesPackage.eINSTANCE && targetElement instanceof JvmMember && (javaElement = this.javaElementFinder.findElementFor((JvmIdentifiableElement)((JvmMember)targetElement))) != null) {
            return new RenameJvmReferenceContext((JvmMember)targetElement, javaElement, (IEditorPart)editor, (ISelection)selection, resource.getURI());
        }
        Set jvmElements = this.associations.getJvmElements(targetElement);
        if (!jvmElements.isEmpty() && !(javaElements = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)jvmElements, JvmIdentifiableElement.class), (Function)new Function<JvmIdentifiableElement, IJavaElement>(){

            public IJavaElement apply(JvmIdentifiableElement from) {
                return JvmRenameElementHandler.this.javaElementFinder.findElementFor(from);
            }
        }), (Predicate)Predicates.notNull()))).isEmpty()) {
            return new RenameJvmDeclarationContext(EcoreUtil2.getNormalizedURI((EObject)targetElement), targetElement.eClass(), javaElements, (IEditorPart)editor, (ISelection)selection, EcoreUtil2.getNormalizedURI((Resource)resource));
        }
        return super.createRenameElementContext(targetElement, editor, selection, resource);
    }

    protected void startRenameElement(IRenameElementContext renameElementContext) throws InterruptedException {
        super.startRenameElement(renameElementContext);
    }
}

