/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;

public class JvmMemberRenameStrategy
implements IRenameStrategy {
    protected URI targetMemberOriginalURI;
    protected URI targetMemberNewURI;
    protected String originalName;

    public JvmMemberRenameStrategy(JvmMember targetMember) {
        this.targetMemberOriginalURI = EcoreUtil.getURI((EObject)targetMember);
        this.originalName = targetMember.getSimpleName();
    }

    public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
        JvmMember member = this.setName(this.targetMemberOriginalURI, resourceSet, newName);
        this.targetMemberNewURI = EcoreUtil.getURI((EObject)member);
    }

    public void revertDeclarationChange(ResourceSet resourceSet) {
        this.setName(this.targetMemberNewURI, resourceSet, this.originalName);
    }

    protected JvmMember setName(URI targetURI, ResourceSet resourceSet, String newName) {
        Resource typeResource;
        JvmMember member = (JvmMember)resourceSet.getEObject(targetURI, true);
        member.internalSetIdentifier(null);
        member.setSimpleName(newName);
        if (member instanceof JvmGenericType && ((InternalEObject)member).eDirectResource() != null && (typeResource = member.eResource()) instanceof TypeResource) {
            String originalURI = typeResource.getURI().toString();
            int lastIndexOf = Math.max(originalURI.lastIndexOf(46), originalURI.lastIndexOf(47) + 1);
            URI typeResourceNewURI = URI.createURI((String)(String.valueOf(originalURI.substring(0, lastIndexOf)) + newName));
            typeResource.setURI(typeResourceNewURI);
            ((TypeResource)typeResource).setMirror(null);
        }
        return member;
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public RefactoringStatus validateNewName(String newName) {
        return new RefactoringStatus();
    }
}

