/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.inject.Inject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.ui.refactoring.IChangeRedirector;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringException;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.DefaultJvmModelRenameStrategy;

public class XtendRenameStrategy
extends DefaultJvmModelRenameStrategy {
    @Inject
    private XtendGrammarAccess grammarAccess;
    @Inject
    private OperatorMapping operatorMapping;
    private IRenameElementContext context;

    public boolean initialize(EObject targetElement, IRenameElementContext context) {
        this.context = context;
        return super.initialize(targetElement, context);
    }

    public RefactoringStatus validateNewName(String newName) {
        if (this.grammarAccess.getFunctionIDRule().getName().equals(this.nameRuleName) && this.operatorMapping.getOperator(QualifiedName.create((String)newName)) != null) {
            RefactoringStatus status = new RefactoringStatus();
            if (this.nameRuleName != null) {
                try {
                    String value = this.getNameAsValue(newName, this.grammarAccess.getValidIDRule().getName());
                    String text = this.getNameAsText(value, this.grammarAccess.getValidIDRule().getName());
                    if (!Strings.equal((String)text, (String)newName)) {
                        status.addError("Illegal name: '" + newName + "'. Consider using '" + text + "' instead.");
                    }
                }
                catch (ValueConverterException vce) {
                    status.addFatalError("Illegal name: " + Strings.notNull((Object)vce.getMessage()));
                }
            }
            return status;
        }
        return super.validateNewName(newName);
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        super.createDeclarationUpdates(newName, resourceSet, updateAcceptor);
        IPath path = this.getPathToRename(this.getTargetElementOriginalURI(), resourceSet);
        if (path != null && path.lastSegment().equals(this.getOriginalName() + ".xtend")) {
            updateAcceptor.accept(this.getTargetElementOriginalURI().trimFragment(), (Change)new RenameResourceChange(path, newName + "." + path.getFileExtension()));
        }
    }

    protected IPath getPathToRename(URI elementURI, ResourceSet resourceSet) {
        EObject targetObject = resourceSet.getEObject(elementURI, false);
        if (targetObject instanceof XtendTypeDeclaration) {
            URI resourceURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)targetObject).trimFragment();
            if (!resourceURI.isPlatformResource()) {
                throw new RefactoringException("Renamed type does not reside in the workspace");
            }
            Path path = new Path(resourceURI.toPlatformString(true));
            if (this.context instanceof IChangeRedirector.Aware && ((IChangeRedirector.Aware)this.context).getChangeRedirector().getRedirectedPath((IPath)path) != path) {
                return null;
            }
            return path;
        }
        return null;
    }
}

