/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.jet.article2.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.examples.jet.article2.model.Attribute;
import org.eclipse.emf.examples.jet.article2.model.Instance;
import org.eclipse.emf.examples.jet.article2.model.NameUtil;
import org.eclipse.emf.examples.jet.article2.model.TypesafeEnum;
import org.eclipse.emf.examples.jet.article2.ui.EditInstanceDialog;
import org.eclipse.emf.examples.jet.article2.ui.NewTypesafeEnumCreationWizardPageAttributes;
import org.eclipse.emf.examples.jet.article2.ui.WizardMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class NewTypesafeEnumCreationWizardPageInstances
extends WizardPage {
    private static final String PAGE_NAME = "InstancesPage";
    private String[] mColumnNames = new String[]{WizardMessages.getString("NewEnumWizPageInst.col.Default"), WizardMessages.getString("NewEnumWizPageInst.col.Name")};
    private static final int COL_DEFAULT = 0;
    private static final int COL_NAME = 1;
    private int[] mColumnWidths = new int[]{30, 400};
    private static final int TABLE_ROWS = 15;
    private boolean mIgnoreCheckEvents = false;
    private CheckboxTableViewer mTableViewer = null;
    private Table mTableWidget = null;
    private Button mButtonAdd = null;
    private Button mButtonEdit = null;
    private Button mButtonRemove = null;

    public NewTypesafeEnumCreationWizardPageInstances() {
        super(PAGE_NAME);
        this.setTitle(WizardMessages.getString("NewEnumWizPageInst.title"));
        this.setDescription(WizardMessages.getString("NewEnumWizPageInst.description"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createTableWidget(container);
        this.createButtonsPanel(container);
        this.hookListeners();
        this.updateEnabledState();
        this.mButtonAdd.forceFocus();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        this.setPageComplete(false);
    }

    private void hookListeners() {
        this.mTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (NewTypesafeEnumCreationWizardPageInstances.this.mIgnoreCheckEvents) {
                    return;
                }
                Object element = event.getElement();
                if (element instanceof TableItem) {
                    element = ((TableItem)element).getData();
                }
                if (element instanceof Instance) {
                    Instance instance = (Instance)element;
                    if (event.getChecked()) {
                        instance.setDefault();
                    } else {
                        instance.getType().setDefaultInstance(null);
                    }
                    NewTypesafeEnumCreationWizardPageInstances.this.syncTableCheckWithModel();
                    NewTypesafeEnumCreationWizardPageInstances.this.validatePage();
                }
            }
        });
        this.mTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewTypesafeEnumCreationWizardPageInstances.this.updateEnabledState();
            }
        });
        this.mTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NewTypesafeEnumCreationWizardPageInstances.this.handleEditPressed();
            }
        });
        this.mButtonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTypesafeEnumCreationWizardPageInstances.this.handleAddPressed();
            }
        });
        this.mButtonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTypesafeEnumCreationWizardPageInstances.this.handleEditPressed();
            }
        });
        this.mButtonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewTypesafeEnumCreationWizardPageInstances.this.handleRemovePressed();
            }
        });
    }

    private void syncTableCheckWithModel() {
        this.mIgnoreCheckEvents = true;
        Iterator<Instance> i = this.getTypesafeEnumModel().instances();
        while (i.hasNext()) {
            Instance inst = i.next();
            this.mTableViewer.setChecked((Object)inst, inst.isDefault());
        }
        this.mIgnoreCheckEvents = false;
    }

    private void updateEnabledState() {
        this.mTableWidget.setEnabled(this.mTableWidget.getItemCount() > 0);
        boolean enabled = this.mTableWidget.getSelectionCount() > 0;
        this.mButtonEdit.setEnabled(enabled);
        this.mButtonRemove.setEnabled(enabled);
    }

    private void handleAddPressed() {
        EditInstanceDialog dialog = new EditInstanceDialog(this.getShell());
        Instance instance = new Instance();
        this.getTypesafeEnumModel().addInstance(instance);
        dialog.setInstance(instance);
        dialog.setAttributes(this.getTypesafeEnumModel().attributeArray());
        dialog.setTitle(WizardMessages.getString("NewEnumWizPageInst.Add_Instance"));
        int reply = dialog.open();
        if (reply == 0) {
            this.mTableViewer.refresh();
            this.mTableViewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getInstance()));
            this.syncTableCheckWithModel();
        } else {
            this.getTypesafeEnumModel().removeInstance(dialog.getInstance());
            this.mTableViewer.refresh();
        }
        this.updateEnabledState();
        this.validatePage();
        this.mButtonAdd.forceFocus();
    }

    private void handleEditPressed() {
        Instance instance = this.getSelectedInstance();
        if (instance == null) {
            return;
        }
        EditInstanceDialog dialog = new EditInstanceDialog(this.getShell());
        dialog.setInstance(instance);
        dialog.setAttributes(this.getTypesafeEnumModel().attributeArray());
        dialog.setTitle(WizardMessages.getString("NewEnumWizPageInst.Edit_Instance"));
        dialog.open();
        this.mTableViewer.refresh();
        this.mTableViewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getInstance()));
        this.syncTableCheckWithModel();
        this.updateEnabledState();
        this.validatePage();
    }

    private void handleRemovePressed() {
        Instance instance = this.getSelectedInstance();
        if (instance == null) {
            return;
        }
        this.getTypesafeEnumModel().removeInstance(instance);
        this.mTableViewer.refresh();
        this.updateEnabledState();
        this.validatePage();
    }

    private Instance getSelectedInstance() {
        IStructuredSelection selection = (IStructuredSelection)this.mTableViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof TableItem) {
            element = ((TableItem)element).getData();
        }
        Instance result = (Instance)element;
        return result;
    }

    private void createButtonsPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        this.mButtonAdd = new Button(panel, 8);
        this.mButtonEdit = new Button(panel, 8);
        this.mButtonRemove = new Button(panel, 8);
        this.mButtonAdd.setText(WizardMessages.getString("NewEnumWizPageAttr.button.Add"));
        this.mButtonEdit.setText(WizardMessages.getString("NewEnumWizPageAttr.button.Edit"));
        this.mButtonRemove.setText(WizardMessages.getString("NewEnumWizPageAttr.button.Remove"));
    }

    private void createTableWidget(Composite container) {
        this.mTableWidget = new Table(container, 68386);
        this.mTableWidget.setHeaderVisible(true);
        this.mTableWidget.setLinesVisible(true);
        this.initTableLayoutData(15);
        this.initTableColumns();
        this.mTableWidget.pack();
        this.mTableViewer = new CheckboxTableViewer(this.mTableWidget);
        this.mTableViewer.setColumnProperties(this.mColumnNames);
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new InstanceLabelProvider());
        this.mTableViewer.setContentProvider((IContentProvider)new InstanceContentProvider());
        this.mTableViewer.setInput((Object)this.getTypesafeEnumModel());
    }

    private void initTableLayoutData(int rows) {
        int listHeight = this.mTableWidget.getItemHeight() * rows;
        Rectangle trim = this.mTableWidget.computeTrim(0, 0, 0, listHeight);
        GridData tblGD = new GridData(1808);
        tblGD.heightHint = trim.height;
        tblGD.horizontalSpan = 2;
        this.mTableWidget.setLayoutData((Object)tblGD);
    }

    private void initTableColumns() {
        TableColumn[] existing = this.mTableWidget.getColumns();
        int i = 0;
        while (i < existing.length) {
            existing[i].setText("");
            ++i;
        }
        i = existing.length;
        while (i < this.mColumnNames.length) {
            new TableColumn(this.mTableWidget, 0);
            ++i;
        }
        i = 0;
        while (i < this.mColumnNames.length) {
            TableColumn column = this.mTableWidget.getColumn(i);
            column.setText(this.mColumnNames[i]);
            ++i;
        }
        TableLayout tableLayout = new TableLayout();
        int i2 = 0;
        while (i2 < this.mColumnWidths.length) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, this.mColumnWidths[i2], true));
            ++i2;
        }
        this.mTableWidget.setLayout((Layout)tableLayout);
    }

    void validatePage() {
        TypesafeEnum type = this.getTypesafeEnumModel();
        if (type.instanceCount() == 0) {
            this.setErrorMessage(WizardMessages.getString("NewEnumWizPageInst.Must_have_at_least_one_instance"));
            this.setPageComplete(false);
            return;
        }
        Iterator<Instance> i = type.instances();
        while (i.hasNext()) {
            Instance instance = i.next();
            if (instance.getName().length() == 0) {
                this.setErrorMessage(WizardMessages.getString("NewEnumWizPageInst.Every_instance_must_have_a_name"));
                this.setPageComplete(false);
                return;
            }
            if (!NameUtil.isValidIdentifier(instance.getName())) {
                this.setErrorMessage(WizardMessages.getFormattedString("NewEnumWizPageInst.invalid_instance_name", instance.getName()));
                this.setPageComplete(false);
                return;
            }
            Iterator<Attribute> attributes = type.attributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                String value = instance.getAttributeValue(attribute);
                if (value != null && value.trim().length() != 0) continue;
                this.setErrorMessage(WizardMessages.getFormattedString("NewEnumWizPageInst.Instance_does_not_have_a_value_for_attribute", new String[]{instance.getName(), attribute.getName()}));
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.mapAttributesToTableModel();
            this.mTableViewer.setInput((Object)this.getTypesafeEnumModel());
            this.getControl().pack(true);
            this.mTableViewer.refresh();
        }
        super.setVisible(visible);
    }

    private void mapAttributesToTableModel() {
        this.reinitColumnNames();
        this.reinitColumnWidths();
        this.initTableLayoutData(15);
        this.initTableColumns();
    }

    private void reinitColumnNames() {
        this.mColumnNames = new String[2 + this.getTypesafeEnumModel().attributeCount()];
        int col = 0;
        this.mColumnNames[col++] = WizardMessages.getString("NewEnumWizPageInst.col.Default");
        this.mColumnNames[col++] = WizardMessages.getString("NewEnumWizPageInst.col.Name");
        Iterator<Attribute> i = this.getTypesafeEnumModel().attributes();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            this.mColumnNames[col++] = attribute.getName();
        }
    }

    private void reinitColumnWidths() {
        this.mColumnWidths = new int[2 + this.getTypesafeEnumModel().attributeCount()];
        this.mColumnWidths[0] = 30;
        this.mColumnWidths[1] = 120;
        int i = 2;
        while (i < this.mColumnWidths.length) {
            this.mColumnWidths[i] = 250 / (this.mColumnWidths.length - 2);
            ++i;
        }
    }

    public TypesafeEnum getTypesafeEnumModel() {
        return ((NewTypesafeEnumCreationWizardPageAttributes)this.getPreviousPage()).getTypesafeEnumModel();
    }

    protected class InstanceContentProvider
    implements IStructuredContentProvider {
        protected InstanceContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Instance> result = new ArrayList<Instance>();
            Iterator<Instance> i = ((TypesafeEnum)inputElement).instances();
            while (i.hasNext()) {
                result.add(i.next());
            }
            return result.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class InstanceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected InstanceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Instance) {
                Instance instance = (Instance)element;
                switch (columnIndex) {
                    case 0: {
                        NewTypesafeEnumCreationWizardPageInstances.this.mTableViewer.setChecked((Object)instance, instance.isDefault());
                        return "";
                    }
                    case 1: {
                        return instance.getName() == null ? "" : instance.getName();
                    }
                }
                String property = NewTypesafeEnumCreationWizardPageInstances.this.mColumnNames[columnIndex];
                String result = instance.getAttributeValue(property);
                return result == null ? "" : result;
            }
            return "";
        }
    }
}

